/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import mezz.jei.config.SearchMode;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.search.CombinedSearchables;
import mezz.jei.search.ElementPrefixParser;
import mezz.jei.search.IElementSearch;
import mezz.jei.search.ISearchStorage;
import mezz.jei.search.ISearchable;
import mezz.jei.search.PrefixInfo;
import mezz.jei.search.PrefixedSearchable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElementSearch
implements IElementSearch {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<PrefixInfo<IIngredientListElementInfo<?>>, PrefixedSearchable<IIngredientListElementInfo<?>>> prefixedSearchables = new IdentityHashMap();
    private final CombinedSearchables<IIngredientListElementInfo<?>> combinedSearchables = new CombinedSearchables();

    public ElementSearch(ElementPrefixParser elementPrefixParser) {
        for (PrefixInfo<IIngredientListElementInfo<?>> prefixInfo : elementPrefixParser.allPrefixInfos()) {
            ISearchStorage<IIngredientListElementInfo<?>> storage = prefixInfo.createStorage();
            PrefixedSearchable prefixedSearchable = new PrefixedSearchable(storage, prefixInfo);
            this.prefixedSearchables.put(prefixInfo, prefixedSearchable);
            this.combinedSearchables.addSearchable(prefixedSearchable);
        }
    }

    @Override
    public Set<IIngredientListElementInfo<?>> getSearchResults(ElementPrefixParser.TokenInfo tokenInfo) {
        String token = tokenInfo.token();
        if (token.isEmpty()) {
            return ImmutableSet.of();
        }
        Set<IIngredientListElementInfo<?>> results = Collections.newSetFromMap(new IdentityHashMap());
        PrefixInfo<IIngredientListElementInfo<?>> prefixInfo = tokenInfo.prefixInfo();
        if (prefixInfo == ElementPrefixParser.NO_PREFIX) {
            this.combinedSearchables.getSearchResults(token, results);
            return results;
        }
        ISearchable searchable = this.prefixedSearchables.get(prefixInfo);
        if (searchable == null || searchable.getMode() == SearchMode.DISABLED) {
            this.combinedSearchables.getSearchResults(token, results);
            return results;
        }
        searchable.getSearchResults(token, results);
        return results;
    }

    @Override
    public void add(IIngredientListElementInfo<?> info) {
        for (PrefixedSearchable<IIngredientListElementInfo<?>> prefixedSearchable : this.prefixedSearchables.values()) {
            SearchMode searchMode = prefixedSearchable.getMode();
            if (searchMode == SearchMode.DISABLED) continue;
            Collection<String> strings = prefixedSearchable.getStrings(info);
            ISearchStorage<IIngredientListElementInfo<?>> searchable = prefixedSearchable.getSearchStorage();
            for (String string : strings) {
                searchable.put(string, info);
            }
        }
    }

    public Set<IIngredientListElementInfo<?>> getAllIngredients() {
        Set<IIngredientListElementInfo<?>> results = Collections.newSetFromMap(new IdentityHashMap());
        this.prefixedSearchables.get(ElementPrefixParser.NO_PREFIX).getAllElements(results);
        return results;
    }

    @Override
    public void logStatistics() {
        this.prefixedSearchables.forEach((prefixInfo, value) -> {
            if (prefixInfo.getMode() != SearchMode.DISABLED) {
                ISearchStorage storage = value.getSearchStorage();
                LOGGER.info("ElementSearch {} Storage Stats: {}", prefixInfo, (Object)storage.statistics());
            }
        });
    }
}

