/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.element.render.map.MinimapElementMapRendererHandler;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.element.RadarRenderer;
import xaero.common.minimap.waypoints.render.CompassRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class MinimapFBORenderer
extends MinimapRenderer {
    private ImprovedFramebuffer scalingFramebuffer;
    private ImprovedFramebuffer rotationFramebuffer;
    private MinimapElementMapRendererHandler minimapElementMapRendererHandler;
    private RadarRenderer radarRenderer;
    private EntityIconManager entityIconManager;
    private boolean triedFBO;
    private boolean loadedFBO;

    public MinimapFBORenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface, CompassRenderer compassRenderer) {
        super(modMain, mc, waypointsGuiRenderer, minimapInterface, compassRenderer);
    }

    public void loadFrameBuffer(MinimapProcessor minimapProcessor) {
        if (!minimapProcessor.canUseFrameBuffer()) {
            MinimapLogs.LOGGER.info("FBO mode not supported! Using minimap safe mode.");
        } else {
            this.scalingFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(512, 512, true);
            this.rotationFramebuffer.func_147607_a(9729);
            this.entityIconManager = new EntityIconManager(this.modMain, new EntityIconPrerenderer(this.modMain));
            this.loadedFBO = this.scalingFramebuffer.field_147616_f != -1 && this.rotationFramebuffer.field_147616_f != -1;
            this.minimapElementMapRendererHandler = MinimapElementMapRendererHandler.Builder.begin().build();
            this.radarRenderer = RadarRenderer.Builder.begin().setModMain(this.modMain).setEntityIconManager(this.entityIconManager).setMinimapInterface(this.minimapInterface).build();
            this.minimapElementMapRendererHandler.add(this.radarRenderer);
            this.minimapInterface.getOverMapRendererHandler().add(this.radarRenderer);
            if (this.modMain.getSupportMods().worldmap()) {
                this.modMain.getSupportMods().worldmapSupport.createRadarRenderWrapper(this.radarRenderer);
            }
        }
        this.triedFBO = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderChunks(XaeroMinimapSession minimapSession, MatrixStack matrixStack, MinimapProcessor minimap, double playerX, double playerZ, double playerDimDiv, double mapDimensionScale, int mapSize, int bufferSize, float sizeFix, float partial, int lightLevel, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, ModSettings settings, CustomVertexConsumers cvc) {
        MinimapWriter minimapWriter = minimap.getMinimapWriter();
        synchronized (minimapWriter) {
            this.renderChunksToFBO(minimapSession, matrixStack, minimap, (PlayerEntity)this.mc.field_71439_g, this.mc.func_175606_aa(), playerX, playerZ, playerDimDiv, mapDimensionScale, bufferSize, mapSize, sizeFix, partial, lightLevel, true, useWorldMap, lockedNorth, shape, ps, pc, cave, circle, cvc);
        }
        ImprovedFramebuffer.bindDefaultFramebuffer(this.scalingFramebuffer.getType(), 36160, Minecraft.func_71410_x());
        GlStateManager.func_227714_e_((int)0, (int)0, (int)Minecraft.func_71410_x().func_228018_at_().func_198109_k(), (int)Minecraft.func_71410_x().func_228018_at_().func_198091_l());
        this.rotationFramebuffer.func_147612_c();
    }

    public void renderChunksToFBO(XaeroMinimapSession minimapSession, MatrixStack matrixStack, MinimapProcessor minimap, PlayerEntity player, Entity renderEntity, double playerX, double playerZ, double playerDimDiv, double mapDimensionScale, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, CustomVertexConsumers cvc) {
        int drawX;
        double zInsidePixel;
        MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers = minimapSession.getMultiTextureRenderTypeRenderers();
        double maxVisibleLength = lockedNorth || shape == 1 ? (double)viewW : (double)viewW * Math.sqrt(2.0);
        double halfMaxVisibleLength = maxVisibleLength / 2.0;
        double radiusBlocks = maxVisibleLength / 2.0 / this.zoom;
        int xFloored = OptimizedMath.myFloor(playerX);
        int zFloored = OptimizedMath.myFloor(playerZ);
        int playerChunkX = xFloored >> 6;
        int playerChunkZ = zFloored >> 6;
        int offsetX = xFloored & 0x3F;
        int offsetZ = zFloored & 0x3F;
        boolean zooming = (double)((int)this.zoom) != this.zoom;
        this.scalingFramebuffer.func_147610_a(true);
        GL11.glClear((int)16640);
        GlStateManager.func_227619_H_();
        RenderHelper.func_74518_a();
        long before = System.currentTimeMillis();
        GlStateManager.func_227658_a_((int)256, (boolean)Minecraft.field_142025_a);
        RenderSystem.matrixMode((int)5889);
        this.getHelper().defaultOrtho(this.scalingFramebuffer, false);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        before = System.currentTimeMillis();
        double xInsidePixel = playerX - (double)xFloored;
        if (xInsidePixel < 0.0) {
            xInsidePixel += 1.0;
        }
        if ((zInsidePixel = playerZ - (double)zFloored) < 0.0) {
            zInsidePixel += 1.0;
        }
        float halfWView = (float)viewW / 2.0f;
        float angle = (float)(90.0 - this.getRenderAngle(lockedNorth));
        RenderSystem.enableBlend();
        RenderSystem.translatef((float)256.0f, (float)256.0f, (float)-2000.0f);
        RenderSystem.scaled((double)this.zoom, (double)this.zoom, (double)1.0);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)-256, (int)-256, (int)256, (int)256, (int)-16777216);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IRenderTypeBuffer.Impl renderTypeBuffers = cvc.getBetterPVPRenderTypeBuffers();
        IVertexBuilder overlayBufferBuilder = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_CHUNK_OVERLAY);
        float chunkGridAlphaMultiplier = 1.0f;
        int minX = playerChunkX + (int)Math.floor(((double)offsetX - radiusBlocks) / 64.0);
        int minZ = playerChunkZ + (int)Math.floor(((double)offsetZ - radiusBlocks) / 64.0);
        int maxX = playerChunkX + (int)Math.floor(((double)(offsetX + 1) + radiusBlocks) / 64.0);
        int maxZ = playerChunkZ + (int)Math.floor(((double)(offsetZ + 1) + radiusBlocks) / 64.0);
        if (!cave || !this.mc.field_71439_g.func_70644_a(Effects.NO_CAVE_MAPS) && !this.mc.field_71439_g.func_70644_a(Effects.NO_CAVE_MAPS_HARMFUL)) {
            if (useWorldMap) {
                chunkGridAlphaMultiplier = this.modMain.getSupportMods().worldmapSupport.getMinimapBrightness();
                this.modMain.getSupportMods().worldmapSupport.drawMinimap(minimapSession, matrixStack, this.getHelper(), xFloored, zFloored, minX, minZ, maxX, maxZ, zooming, this.zoom, mapDimensionScale, overlayBufferBuilder, multiTextureRenderTypeRenderers);
            } else if (minimap.getMinimapWriter().getLoadedBlocks() != null && level >= 0) {
                int loadedLevels = minimap.getMinimapWriter().getLoadedLevels();
                chunkGridAlphaMultiplier = loadedLevels <= 1 ? 1.0f : 0.375f + 0.625f * (1.0f - (float)level / (float)(loadedLevels - 1));
                int loadedMapChunkX = minimap.getMinimapWriter().getLoadedMapChunkX();
                int loadedMapChunkZ = minimap.getMinimapWriter().getLoadedMapChunkZ();
                int loadedWidth = minimap.getMinimapWriter().getLoadedBlocks().length;
                boolean slimeChunks = this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager());
                minX = Math.max(minX, loadedMapChunkX);
                minZ = Math.max(minZ, loadedMapChunkZ);
                maxX = Math.min(maxX, loadedMapChunkX + loadedWidth - 1);
                maxZ = Math.min(maxZ, loadedMapChunkZ + loadedWidth - 1);
                MultiTextureRenderTypeRenderer multiTextureRenderTypeRenderer = multiTextureRenderTypeRenderers.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR);
                MinimapRendererHelper helper = this.getHelper();
                for (int X = minX; X <= maxX; ++X) {
                    int canvasX = X - minimap.getMinimapWriter().getLoadedMapChunkX();
                    for (int Z = minZ; Z <= maxZ; ++Z) {
                        int canvasZ = Z - minimap.getMinimapWriter().getLoadedMapChunkZ();
                        MinimapChunk mchunk = minimap.getMinimapWriter().getLoadedBlocks()[canvasX][canvasZ];
                        if (mchunk == null) continue;
                        int texture = mchunk.bindTexture(level);
                        if (!mchunk.isHasSomething() || level >= mchunk.getLevelsBuffered() || texture == 0) continue;
                        if (!zooming) {
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                        } else {
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                        }
                        drawX = (X - playerChunkX) * 64 - offsetX;
                        int drawZ = (Z - playerChunkZ) * 64 - offsetZ;
                        helper.prepareMyTexturedColoredModalRect(matrixStack.func_227866_c_().func_227870_a_(), drawX, drawZ, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f, texture, 1.0f, 1.0f, 1.0f, 1.0f, multiTextureRenderTypeRenderer);
                        if (!slimeChunks) continue;
                        for (int t = 0; t < 16; ++t) {
                            if (mchunk.getTile(t % 4, t / 4) == null || !mchunk.getTile(t % 4, t / 4).isSlimeChunk()) continue;
                            int slimeDrawX = drawX + 16 * (t % 4);
                            int slimeDrawZ = drawZ + 16 * (t / 4);
                            helper.addColoredRectToExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), overlayBufferBuilder, slimeDrawX, slimeDrawZ, 16, 16, -2142047936);
                        }
                    }
                }
                multiTextureRenderTypeRenderers.draw(multiTextureRenderTypeRenderer);
            }
        }
        if (this.modMain.getSettings().chunkGrid > -1) {
            int i;
            IVertexBuilder lineBufferBuilder = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_LINES);
            int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
            int r = grid >> 16 & 0xFF;
            int g = grid >> 8 & 0xFF;
            int b = grid & 0xFF;
            float red = (float)r / 255.0f;
            float green = (float)g / 255.0f;
            float blue = (float)b / 255.0f;
            float alpha = 0.8f;
            float colorMultiplier = chunkGridAlphaMultiplier;
            red *= colorMultiplier;
            green *= colorMultiplier;
            blue *= colorMultiplier;
            RenderSystem.lineWidth((float)this.modMain.getSettings().chunkGridLineWidth);
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            int bias = (int)Math.ceil(this.zoom);
            for (int X = minX; X <= maxX; ++X) {
                drawX = (X - playerChunkX + 1) * 64 - offsetX;
                for (i = 0; i < 4; ++i) {
                    float lineX = (float)drawX + (float)(-16 * i);
                    this.helper.addColoredLineToExistingBuffer(matrix, lineBufferBuilder, lineX, -((float)halfMaxVisibleLength), lineX, (float)halfMaxVisibleLength + (float)bias, red, green, blue, alpha);
                }
            }
            for (int Z = minZ; Z <= maxZ; ++Z) {
                int drawZ = (Z - playerChunkZ + 1) * 64 - offsetZ;
                for (i = 0; i < 4; ++i) {
                    float lineZ = (float)drawZ + (float)((double)(-16 * i) - 1.0 / this.zoom);
                    this.helper.addColoredLineToExistingBuffer(matrix, lineBufferBuilder, -((float)halfMaxVisibleLength), lineZ, (float)halfMaxVisibleLength + (float)bias, lineZ, red, green, blue, alpha);
                }
            }
        }
        renderTypeBuffers.func_228461_a_();
        this.scalingFramebuffer.func_147609_e();
        this.rotationFramebuffer.func_147610_a(false);
        GL11.glClear((int)16640);
        this.scalingFramebuffer.func_147612_c();
        RenderSystem.loadIdentity();
        if (this.modMain.getSettings().getAntiAliasing()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        RenderSystem.translatef((float)halfWView, (float)halfWView, (float)-2980.0f);
        GL11.glPushMatrix();
        if (!lockedNorth) {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        RenderSystem.translated((double)(-xInsidePixel * this.zoom), (double)(-zInsidePixel * this.zoom), (double)0.0);
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(this.modMain.getSettings().minimapOpacity / 100.0)));
        this.helper.drawMyTexturedModalRect(-256.0f, -256.0f, 0, 0, 512.0f, 512.0f, 512.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        before = System.currentTimeMillis();
        GlStateManager.func_227700_d_();
        GlStateManager.func_227639_a_((int)516, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)1);
        GlStateManager.func_227674_b_((int)519);
        GlStateManager.func_227674_b_((int)515);
        GlStateManager.func_227667_a_((boolean)false);
        GlStateManager.func_227667_a_((boolean)true);
        GL11.glBindTexture((int)3553, (int)0);
        GlStateManager.func_227760_t_((int)0);
        GlStateManager.func_227709_e_();
        GlStateManager.func_227639_a_((int)516, (float)0.1f);
        GlStateManager.func_227740_m_();
        GlStateManager.func_227644_a_((int)770, (int)771, (int)1, (int)771);
        matrixStack.func_227860_a_();
        this.minimapElementMapRendererHandler.render(matrixStack, renderEntity, player, playerX, renderEntity.func_226278_cu_(), playerZ, playerDimDiv, ps, pc, this.zoom, cave, partial, this.rotationFramebuffer, this.modMain, this.helper, renderTypeBuffers, this.mc.field_71466_p, multiTextureRenderTypeRenderers, halfWView);
        matrixStack.func_227865_b_();
        renderTypeBuffers.func_228461_a_();
        this.rotationFramebuffer.func_147609_e();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.matrixMode((int)5889);
        Misc.minecraftOrtho(this.mc, false);
        RenderSystem.matrixMode((int)5888);
        GL11.glPopMatrix();
    }

    public void deleteFramebuffers() {
        this.scalingFramebuffer.func_147608_a();
        this.rotationFramebuffer.func_147608_a();
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public boolean isLoadedFBO() {
        return this.loadedFBO;
    }

    public void setLoadedFBO(boolean loadedFBO) {
        this.loadedFBO = loadedFBO;
    }

    public boolean isTriedFBO() {
        return this.triedFBO;
    }

    public void resetEntityIcons() {
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public void resetEntityIconsResources() {
        if (this.entityIconManager != null) {
            this.entityIconManager.resetResources();
        }
    }

    public void onEntityIconsModelRenderDetection(EntityModel<?> model, IVertexBuilder vertexConsumer, float red, float green, float blue, float alpha) {
        this.entityIconManager.onModelRenderDetection(model, vertexConsumer, red, green, blue, alpha);
    }

    public void onEntityIconsModelPartRenderDetection(ModelRenderer modelRenderer, float red, float green, float blue, float alpha) {
        this.entityIconManager.onModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }

    public void renderMainEntityDot(MatrixStack matrixStack, MinimapProcessor minimap, PlayerEntity p, Entity renderEntity, double ps, double pc, double playerX, double playerZ, float partial, MinimapRadar minimapRadar, boolean lockedNorth, int style, boolean smooth, boolean debug, boolean cave, double dotNameScale, ModSettings settings, IRenderTypeBuffer.Impl renderTypeBuffers, float minimapScale) {
        EntityRadarCategory mainEntityCategory = minimapRadar.getEntityCategoryManager().getRuleResolver().resolve(minimapRadar.getEntityCategoryManager().getRootCategory(), renderEntity, p);
        if (mainEntityCategory == null) {
            mainEntityCategory = minimapRadar.getEntityCategoryManager().getRootCategory();
        }
        int dotSize = settings.mainDotSize;
        this.radarRenderer.renderEntityDotToFBO(1, false, matrixStack, minimap, p, renderEntity, renderEntity, partial, false, false, minimapRadar, style, smooth, debug, false, cave, dotNameScale, renderTypeBuffers, CustomRenderTypes.GUI_BILINEAR, renderTypeBuffers.getBuffer(CustomRenderTypes.GUI_BILINEAR), null, null, 0, false, 100, false, 100, 1.0, dotSize, mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue(), 0, mainEntityCategory, this.getHelper(), this.mc.field_71466_p, this.rotationFramebuffer, minimapScale);
        renderTypeBuffers.func_228461_a_();
    }

    public RadarRenderer getRadarRenderer() {
        return this.radarRenderer;
    }
}

