/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedbackpacks.util.FilterItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FilterLogic
extends FilterLogicBase {
    private final int filterSlotCount;
    private final Predicate<ItemStack> isItemValid;
    private FilterItemStackHandler filterHandler = null;
    private boolean emptyAllowListMatchesEverything = false;

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount) {
        this(upgrade, saveHandler, filterSlotCount, s -> true, "");
    }

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, Predicate<ItemStack> isItemValid) {
        this(upgrade, saveHandler, filterSlotCount, isItemValid, "");
    }

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, Predicate<ItemStack> isItemValid, String parentTagKey) {
        super(upgrade, saveHandler, parentTagKey);
        this.filterSlotCount = filterSlotCount;
        this.isItemValid = isItemValid;
    }

    public void setEmptyAllowListMatchesEverything() {
        this.emptyAllowListMatchesEverything = true;
    }

    public FilterItemStackHandler getFilterHandler() {
        if (this.filterHandler == null) {
            this.filterHandler = new FilterItemStackHandler(this.filterSlotCount){

                @Override
                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    NBTHelper.setCompoundNBT(FilterLogic.this.upgrade, FilterLogic.this.parentTagKey, "filters", this.serializeNBT());
                    FilterLogic.this.save();
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    this.setSize(FilterLogic.this.filterSlotCount);
                    ListNBT tagList = nbt.func_150295_c("Items", 10);
                    for (int i = 0; i < tagList.size(); ++i) {
                        CompoundNBT itemTags = tagList.func_150305_b(i);
                        int slot = itemTags.func_74762_e("Slot");
                        if (slot < 0 || slot >= this.stacks.size()) continue;
                        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)itemTags);
                        this.stacks.set(slot, (Object)stack);
                    }
                    this.onLoad();
                }

                public boolean isItemValid(int slot, ItemStack stack) {
                    return stack.func_190926_b() || this.doesNotContain(stack) && FilterLogic.this.isItemValid.test(stack);
                }

                private boolean doesNotContain(ItemStack stack) {
                    return !InventoryHelper.hasItem((IItemHandler)this, s -> ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack));
                }
            };
            NBTHelper.getCompound(this.upgrade, this.parentTagKey, "filters").ifPresent(arg_0 -> ((FilterItemStackHandler)this.filterHandler).deserializeNBT(arg_0));
        }
        return this.filterHandler;
    }

    public boolean matchesFilter(ItemStack stack) {
        if (this.isAllowList()) {
            if (this.getPrimaryMatch() == PrimaryMatch.TAGS) {
                return this.isTagMatch(stack);
            }
            return this.getFilterHandler().hasOnlyEmptyFilters() && this.emptyAllowListMatchesEverything || InventoryHelper.iterate((IItemHandler)this.getFilterHandler(), (slot, filter) -> this.stackMatchesFilter(stack, (ItemStack)filter), () -> false, returnValue -> returnValue) != false;
        }
        if (this.getPrimaryMatch() == PrimaryMatch.TAGS) {
            return !this.isTagMatch(stack);
        }
        return this.getFilterHandler().hasOnlyEmptyFilters() || InventoryHelper.iterate((IItemHandler)this.getFilterHandler(), (slot, filter) -> !this.stackMatchesFilter(stack, (ItemStack)filter), () -> true, returnValue -> returnValue == false) != false;
    }

    private boolean isTagMatch(ItemStack stack) {
        if (this.shouldMatchAnyTag()) {
            return this.anyTagMatches(stack.func_77973_b().getTags());
        }
        return this.allTagsMatch(stack.func_77973_b().getTags());
    }

    private boolean allTagsMatch(Set<ResourceLocation> tags) {
        if (this.tagNames == null) {
            this.initTags();
        }
        for (ResourceLocation tagName : this.tagNames) {
            if (tags.contains(tagName)) continue;
            return false;
        }
        return true;
    }

    private boolean anyTagMatches(Set<ResourceLocation> tags) {
        if (this.tagNames == null) {
            this.initTags();
        }
        for (ResourceLocation tag : tags) {
            if (!this.tagNames.contains(tag)) continue;
            return true;
        }
        return false;
    }
}

