/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.NonNullFunction;

public class WorldAttached<T> {
    static List<Map<IWorld, ?>> allMaps = new ArrayList();
    Map<IWorld, T> attached;
    private final NonNullFunction<IWorld, T> factory;

    public WorldAttached(NonNullFunction<IWorld, T> factory) {
        this.factory = factory;
        this.attached = new HashMap<IWorld, T>();
        allMaps.add(this.attached);
    }

    public static void invalidateWorld(IWorld world) {
        allMaps.forEach(m -> m.remove(world));
    }

    @Nonnull
    public T get(IWorld world) {
        T t = this.attached.get(world);
        if (t != null) {
            return t;
        }
        Object entry = this.factory.apply((Object)world);
        this.put(world, entry);
        return (T)entry;
    }

    public void put(IWorld world, T entry) {
        this.attached.put(world, entry);
    }
}

