/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.network.NetworkEvent;

public class CConfigureConfigPacket<T>
extends SimplePacketBase {
    private String modID;
    private String path;
    private String value;

    public CConfigureConfigPacket(String modID, String path, T value) {
        this.modID = Objects.requireNonNull(modID);
        this.path = path;
        this.value = this.serialize(value);
    }

    public CConfigureConfigPacket(PacketBuffer buffer) {
        this.modID = buffer.func_150789_c(Short.MAX_VALUE);
        this.path = buffer.func_150789_c(Short.MAX_VALUE);
        this.value = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_180714_a(this.modID);
        buffer.func_180714_a(this.path);
        buffer.func_180714_a(this.value);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            try {
                ForgeConfigSpec.ConfigValue configValue;
                Object v;
                ServerPlayerEntity sender = ((NetworkEvent.Context)context.get()).getSender();
                if (sender == null || !sender.func_211513_k(2)) {
                    return;
                }
                ForgeConfigSpec spec = ConfigHelper.findConfigSpecFor(ModConfig.Type.SERVER, this.modID);
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(this.path);
                if (!valueSpec.test(v = CConfigureConfigPacket.deserialize((configValue = (ForgeConfigSpec.ConfigValue)spec.getValues().get(this.path)).get(), this.value))) {
                    return;
                }
                configValue.set(v);
            }
            catch (Exception e) {
                Create.LOGGER.warn("Unable to handle ConfigureConfig Packet. ", (Throwable)e);
            }
        });
        context.get().setPacketHandled(true);
    }

    public String serialize(T value) {
        if (value instanceof Boolean) {
            return Boolean.toString((Boolean)value);
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Float) {
            return Float.toString(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        throw new IllegalArgumentException("unknown type " + value + ": " + value.getClass().getSimpleName());
    }

    public static Object deserialize(Object type, String sValue) {
        if (type instanceof Boolean) {
            return Boolean.parseBoolean(sValue);
        }
        if (type instanceof Enum) {
            return Enum.valueOf(((Enum)type).getClass(), sValue);
        }
        if (type instanceof Integer) {
            return Integer.parseInt(sValue);
        }
        if (type instanceof Float) {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        if (type instanceof Double) {
            return Double.parseDouble(sValue);
        }
        throw new IllegalArgumentException("unknown type " + type + ": " + type.getClass().getSimpleName());
    }
}

