/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.palettes;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.palettes.PaletteBlockPartial;
import com.simibubi.create.content.palettes.PaletteBlockPattern;
import com.simibubi.create.content.palettes.PaletteStoneVariants;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.utility.ColorHandlers;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.builders.ItemBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateRecipeProvider;
import com.simibubi.create.repack.registrate.util.DataIngredient;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import com.simibubi.create.repack.registrate.util.entry.RegistryEntry;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;

public class PalettesVariantEntry {
    public final ImmutableList<BlockEntry<? extends Block>> registeredBlocks;
    public final ImmutableList<BlockEntry<? extends Block>> registeredPartials;

    public PalettesVariantEntry(PaletteStoneVariants variant, PaletteBlockPattern[] patterns) {
        String name = Lang.asId(variant.name());
        NonNullSupplier<Block> initialProperties = variant.getBaseBlock();
        ImmutableList.Builder registeredBlocks = ImmutableList.builder();
        ImmutableList.Builder registeredPartials = ImmutableList.builder();
        CreateRegistrate registrate = Create.registrate();
        for (PaletteBlockPattern pattern : patterns) {
            ITag.INamedTag<Item>[] itemTags;
            BlockBuilder<? extends Block, String> builder = registrate.block(pattern.createName(name), pattern.getBlockFactory()).initialProperties(initialProperties).blockstate(((PaletteBlockPattern.IBlockStateProvider)((Function)pattern.getBlockStateGenerator().apply(pattern)).apply(name))::accept);
            ItemBuilder<BlockItem, BlockBuilder<? extends Block, String>> itemBuilder = builder.item();
            ITag.INamedTag<Block>[] blockTags = pattern.getBlockTags();
            if (blockTags != null) {
                builder.tag(blockTags);
            }
            if ((itemTags = pattern.getItemTags()) != null) {
                itemBuilder.tag(itemTags);
            }
            if (pattern.isTranslucent()) {
                builder.addLayer(() -> RenderType::func_228645_f_);
            }
            if (pattern.hasFoliage()) {
                builder.color(() -> ColorHandlers::getGrassyBlock);
                itemBuilder.color(() -> ColorHandlers::getGrassyItem);
            }
            pattern.createCTBehaviour(variant).ifPresent(b -> {
                BlockBuilder cfr_ignored_0 = (BlockBuilder)builder.onRegister(CreateRegistrate.connectedTextures(b));
            });
            builder.recipe((c, p) -> {
                p.stonecutting(DataIngredient.items((IItemProvider)((IItemProvider)variant.getBaseBlock().get()), (IItemProvider[])new Block[0]), c::get);
                pattern.addRecipes(variant, (DataGenContext<Block, ? extends Block>)c, (RegistrateRecipeProvider)p);
            });
            itemBuilder.register();
            RegistryEntry block = builder.register();
            registeredBlocks.add((Object)block);
            for (PaletteBlockPartial<? extends Block> partialBlock : pattern.getPartials()) {
                registeredPartials.add((Object)partialBlock.create(name, pattern, block).register());
            }
        }
        this.registeredBlocks = registeredBlocks.build();
        this.registeredPartials = registeredPartials.build();
    }
}

