/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.goggles;

import com.simibubi.create.foundation.utility.Lang;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IHaveGoggleInformation {
    public static final Format numberFormat = new Format();
    public static final String spacing = "    ";
    public static final ITextComponent componentSpacing = new StringTextComponent("    ");

    default public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    public static String format(double d) {
        return numberFormat.get().format(d).replace("\u00a0", " ");
    }

    default public boolean containedFluidTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking, LazyOptional<IFluidHandler> handler) {
        tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("gui.goggles.fluid_container", new Object[0])));
        TranslationTextComponent mb = Lang.translate("generic.unit.millibuckets", new Object[0]);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        StringTextComponent indent = new StringTextComponent("     ");
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            IFormattableTextComponent fluidName = new TranslationTextComponent(fluidStack.getTranslationKey()).func_240699_a_(TextFormatting.GRAY);
            IFormattableTextComponent contained = new StringTextComponent(IHaveGoggleInformation.format(fluidStack.getAmount())).func_230529_a_((ITextComponent)mb).func_240699_a_(TextFormatting.GOLD);
            IFormattableTextComponent slash = new StringTextComponent(" / ").func_240699_a_(TextFormatting.GRAY);
            IFormattableTextComponent capacity = new StringTextComponent(IHaveGoggleInformation.format(tank.getTankCapacity(i))).func_230529_a_((ITextComponent)mb).func_240699_a_(TextFormatting.DARK_GRAY);
            tooltip.add((ITextComponent)indent.func_230531_f_().func_230529_a_((ITextComponent)fluidName));
            tooltip.add((ITextComponent)indent.func_230531_f_().func_230529_a_((ITextComponent)contained).func_230529_a_((ITextComponent)slash).func_230529_a_((ITextComponent)capacity));
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        IFormattableTextComponent capacity = Lang.translate("gui.goggles.fluid_container.capacity", new Object[0]).func_240699_a_(TextFormatting.GRAY);
        IFormattableTextComponent amount = new StringTextComponent(IHaveGoggleInformation.format(tank.getTankCapacity(0))).func_230529_a_((ITextComponent)mb).func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)indent.func_230531_f_().func_230529_a_((ITextComponent)capacity).func_230529_a_((ITextComponent)amount));
        return true;
    }

    public static class Format {
        private NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);

        private Format() {
        }

        public NumberFormat get() {
            return this.format;
        }

        public void update() {
            this.format = NumberFormat.getInstance(Minecraft.func_71410_x().func_135016_M().func_135041_c().getJavaLocale());
            this.format.setMaximumFractionDigits(2);
            this.format.setMinimumFractionDigits(0);
            this.format.setGroupingUsed(true);
        }
    }
}

