/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AbstractAdvancedPathNavigate;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Node;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathResult;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.SurfaceType;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.AbstractPathJob;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PathJobRandomPos
extends AbstractPathJob {
    protected final BlockPos destination;
    protected final int minDistFromStart;
    private static Random random = new Random();
    private final int maxDistToDest;

    public PathJobRandomPos(World world, BlockPos start, int minDistFromStart, int range, LivingEntity entity) {
        super(world, start, start, range, new PathResult(), entity);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = range;
        Tuple<Direction, Direction> dir = PathJobRandomPos.getRandomDirectionTuple(random);
        this.destination = start.func_177967_a((Direction)dir.func_76341_a(), minDistFromStart).func_177967_a((Direction)dir.func_76340_b(), minDistFromStart);
    }

    public PathJobRandomPos(World world, BlockPos start, int minDistFromStart, int searchRange, int maxDistToDest, LivingEntity entity, BlockPos dest) {
        super(world, start, dest, searchRange, new PathResult(), entity);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = maxDistToDest;
        this.destination = dest;
    }

    public PathJobRandomPos(World world, BlockPos start, int minDistFromStart, int range, LivingEntity entity, BlockPos startRestriction, BlockPos endRestriction, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        super(world, start, startRestriction, endRestriction, range, false, new PathResult(), entity, restrictionType);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = range;
        Tuple<Direction, Direction> dir = PathJobRandomPos.getRandomDirectionTuple(random);
        this.destination = start.func_177967_a((Direction)dir.func_76341_a(), minDistFromStart).func_177967_a((Direction)dir.func_76340_b(), minDistFromStart);
    }

    public static Tuple<Direction, Direction> getRandomDirectionTuple(Random random) {
        return new Tuple((Object)Direction.func_239631_a_((Random)random), (Object)Direction.func_239631_a_((Random)random));
    }

    @Override
    @Nullable
    protected Path search() {
        if (Pathfinding.isDebug()) {
            IceAndFire.LOGGER.info(String.format("Pathfinding from [%d,%d,%d] in the direction of [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.destination.func_177958_n(), this.destination.func_177956_o(), this.destination.func_177952_p()));
        }
        return super.search();
    }

    @Override
    public PathResult getResult() {
        return super.getResult();
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        return Math.sqrt(this.destination.func_177951_i((Vector3i)new BlockPos(pos.func_177958_n(), this.destination.func_177956_o(), pos.func_177952_p())));
    }

    @Override
    protected boolean isAtDestination(Node n) {
        return random.nextInt(10) == 0 && this.isInRestrictedArea(n.pos) && this.start.func_177951_i((Vector3i)n.pos) > (double)(this.minDistFromStart * this.minDistFromStart) && SurfaceType.getSurfaceType((IBlockReader)this.world, this.world.func_180495_p(n.pos.func_177977_b()), n.pos.func_177977_b()) == SurfaceType.WALKABLE && this.destination.func_177951_i((Vector3i)n.pos) < (double)(this.maxDistToDest * this.maxDistToDest);
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return this.destination.func_177951_i((Vector3i)n.pos);
    }

    public boolean posAndRangeMatch(int range, BlockPos pos) {
        return this.destination != null && pos != null && range == this.maxDistToDest && this.destination.equals((Object)pos);
    }
}

