/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.core.AELog;
import appeng.core.Api;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStorageWorldData;
import appeng.spatial.TransitionInfo;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class SpatialStoragePlotManager {
    public static final SpatialStoragePlotManager INSTANCE = new SpatialStoragePlotManager();

    private SpatialStoragePlotManager() {
    }

    public ServerWorld getWorld() {
        MinecraftServer server = SpatialStoragePlotManager.getServer();
        ServerWorld world = server.func_71218_a(SpatialStorageDimensionIds.WORLD_ID);
        if (world == null) {
            throw new IllegalStateException("The storage cell world is missing.");
        }
        return world;
    }

    private SpatialStorageWorldData getWorldData() {
        return (SpatialStorageWorldData)this.getWorld().func_72863_F().func_217227_h().func_215752_a(SpatialStorageWorldData::new, "ae2_spatial_storage");
    }

    @Nullable
    public SpatialStoragePlot getPlot(int plotId) {
        if (plotId == -1) {
            return null;
        }
        return this.getWorldData().getPlotById(plotId);
    }

    public SpatialStoragePlot allocatePlot(BlockPos size, int ownerId) {
        SpatialStoragePlot plot = this.getWorldData().allocatePlot(size, ownerId);
        AELog.info("Allocating storage cell plot %d with size %s for %d", plot.getId(), size, ownerId);
        return plot;
    }

    public void setLastTransition(int plotId, TransitionInfo info) {
        this.getWorldData().setLastTransition(plotId, info);
    }

    public List<SpatialStoragePlot> getPlots() {
        return this.getWorldData().getPlots();
    }

    public void freePlot(int plotId, boolean resetBlocks) {
        SpatialStoragePlot plot = this.getPlot(plotId);
        if (plot == null) {
            return;
        }
        if (resetBlocks) {
            BlockPos from = plot.getOrigin();
            BlockPos to = from.func_177971_a((Vector3i)plot.getSize()).func_177982_a(-1, -1, -1);
            AELog.info("Clearing spatial storage plot %s (%s -> %s)", plotId, from, to);
            ServerWorld world = this.getWorld();
            BlockState matrixFrame = Api.instance().definitions().blocks().matrixFrame().block().func_176223_P();
            for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)from, (BlockPos)to)) {
                world.func_175656_a(blockPos, matrixFrame);
            }
        }
        this.getWorldData().removePlot(plotId);
    }

    private static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }
}

