/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.util.AEColor;
import appeng.client.render.BasicUnbakedModel;
import appeng.client.render.cablebus.CableBuilder;
import appeng.client.render.cablebus.CableBusBakedModel;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.FacadeBuilder;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.features.registries.PartModels;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;

public class CableBusModel
implements BasicUnbakedModel<CableBusModel> {
    public static final ResourceLocation TRANSLUCENT_FACADE_MODEL = AppEng.makeId("part/translucent_facade");
    private final PartModels partModels;

    public CableBusModel(PartModels partModels) {
        this.partModels = partModels;
    }

    @Override
    public Collection<ResourceLocation> getModelDependencies() {
        this.partModels.setInitialized(true);
        ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>(this.partModels.getModels());
        models.add(TRANSLUCENT_FACADE_MODEL);
        return models;
    }

    @Override
    public Stream<RenderMaterial> getAdditionalTextures() {
        return CableBuilder.getTextures().stream();
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        Map<ResourceLocation, IBakedModel> partModels = this.loadPartModels(bakery, spriteGetter, modelTransform);
        CableBuilder cableBuilder = new CableBuilder(spriteGetter);
        IBakedModel translucentFacadeModel = bakery.getBakedModel(TRANSLUCENT_FACADE_MODEL, modelTransform, spriteGetter);
        FacadeBuilder facadeBuilder = new FacadeBuilder(translucentFacadeModel);
        TextureAtlasSprite particleTexture = cableBuilder.getCoreTexture(CableCoreType.GLASS, AEColor.TRANSPARENT);
        return new CableBusBakedModel(cableBuilder, facadeBuilder, partModels, particleTexture);
    }

    private Map<ResourceLocation, IBakedModel> loadPartModels(ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetterIn, IModelTransform transformIn) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ResourceLocation location : this.partModels.getModels()) {
            IBakedModel bakedModel = bakery.getBakedModel(location, transformIn, spriteGetterIn);
            if (bakedModel == null) {
                AELog.warn("Failed to bake part model {}", location);
                continue;
            }
            result.put((Object)location, (Object)bakedModel);
        }
        return result.build();
    }
}

