/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.util;

import com.mrcrayfish.controllable.client.ISearchable;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class ScreenUtil {
    public static boolean isMouseWithin(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static Button.ITooltip createButtonTooltip(Screen screen, ITextComponent message, int maxWidth) {
        return ScreenUtil.createButtonTooltip(screen, message, maxWidth, button -> button.field_230693_o_ && button.func_230449_g_());
    }

    public static Button.ITooltip createButtonTooltip(Screen screen, ITextComponent message, int maxWidth, Predicate<Button> predicate) {
        return (button, matrixStack, mouseX, mouseY) -> {
            if (predicate.test(button)) {
                screen.func_238654_b_(matrixStack, Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)message, maxWidth), mouseX, mouseY);
            }
        };
    }

    public static void updateSearchTextFieldSuggestion(TextFieldWidget textField, String value, List<? extends ISearchable> entries) {
        if (!value.isEmpty()) {
            Optional<ISearchable> optional = entries.stream().filter(info -> info.getLabel().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(ISearchable::getLabel));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getLabel();
                textField.func_195612_c(displayName.substring(length));
            } else {
                textField.func_195612_c("");
            }
        } else {
            textField.func_195612_c(new TranslationTextComponent("controllable.gui.search").getString());
        }
    }
}

