/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.IToolTip;
import com.mrcrayfish.controllable.client.gui.ListMenuScreen;
import com.mrcrayfish.controllable.client.settings.ControllerOptions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SettingsScreen
extends ListMenuScreen {
    private static final AbstractOption[] OPTIONS = new AbstractOption[]{ControllerOptions.AUTO_SELECT, ControllerOptions.RENDER_MINI_PLAYER, ControllerOptions.VIRTUAL_MOUSE, ControllerOptions.CONSOLE_HOTBAR, ControllerOptions.CONTROLLER_ICONS, ControllerOptions.CURSOR_TYPE, ControllerOptions.INVERT_LOOK, ControllerOptions.DEAD_ZONE, ControllerOptions.ROTATION_SPEED, ControllerOptions.MOUSE_SPEED, ControllerOptions.SHOW_ACTIONS, ControllerOptions.QUICK_CRAFT, ControllerOptions.UI_SOUNDS, ControllerOptions.RADIAL_THUMBSTICK, ControllerOptions.SNEAK_MODE, ControllerOptions.CURSOR_THUMBSTICK, ControllerOptions.HOVER_MODIFIER};
    private IToolTip hoveredTooltip;
    private int hoveredCounter;

    protected SettingsScreen(Screen parent) {
        super(parent, (ITextComponent)new TranslationTextComponent("controllable.gui.title.settings"), 24);
        this.setSearchBarVisible(false);
        this.setRowWidth(310);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 32, 200, 20, DialogTexts.field_240637_h_, button -> this.field_230706_i_.func_147108_a(this.parent)));
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        for (int i = 0; i < OPTIONS.length; i += 2) {
            entries.add(new OptionRowItem(this.getOption(i), this.getOption(i + 1)));
        }
    }

    @Nullable
    private AbstractOption getOption(int index) {
        if (index >= 0 && index < OPTIONS.length) {
            return OPTIONS[index];
        }
        return null;
    }

    public void func_231164_f_() {
        Config.save();
    }

    public void func_231023_e_() {
        if (this.hoveredTooltip != null) {
            if (this.hoveredCounter < 20) {
                ++this.hoveredCounter;
            }
        } else {
            this.hoveredCounter = 0;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.hoveredTooltip = this.getHoveredToolTip(mouseX, mouseY);
        if (this.hoveredTooltip != null && this.hoveredCounter >= 20) {
            this.func_238654_b_(matrixStack, this.hoveredTooltip.getToolTip(), mouseX, mouseY);
        }
    }

    @Nullable
    private IToolTip getHoveredToolTip(int mouseX, int mouseY) {
        for (int i = 0; i < OPTIONS.length; ++i) {
            AbstractOption option = OPTIONS[i];
            if (!(option instanceof IToolTip)) continue;
            int x = this.field_230708_k_ / 2 - 155 + i % 2 * 160;
            int y = this.field_230709_l_ / 6 + 24 * (i >> 1);
            if (mouseX < x || mouseY < y || mouseX >= x + 150 || mouseY >= y + 20) continue;
            return (IToolTip)option;
        }
        return null;
    }

    public class OptionRowItem
    extends ListMenuScreen.Item {
        private final Widget optionOne;
        private final Widget optionTwo;

        public OptionRowItem(@Nullable AbstractOption o1, AbstractOption o2) {
            super(StringTextComponent.field_240750_d_);
            this.optionOne = o1.func_216586_a(((SettingsScreen)SettingsScreen.this).field_230706_i_.field_71474_y, 0, 0, 150);
            this.optionTwo = Optional.ofNullable(o2).map(o -> o.func_216586_a(((SettingsScreen)SettingsScreen.this).field_230706_i_.field_71474_y, 0, 0, 150)).orElse(null);
        }

        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.optionOne.field_230690_l_ = left;
            this.optionOne.field_230691_m_ = top;
            this.optionOne.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.optionTwo != null) {
                this.optionTwo.field_230690_l_ = left + width - 150;
                this.optionTwo.field_230691_m_ = top;
                this.optionTwo.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return this.optionTwo != null ? ImmutableList.of((Object)this.optionOne, (Object)this.optionTwo) : ImmutableList.of((Object)this.optionOne);
        }
    }
}

