/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ButtonBindingData;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.widget.ColorButton;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RadialItemList
extends ExtendedList<ButtonBindingEntry> {
    private List<ButtonBindingData> bindings;
    private ButtonBinding selectedBinding;

    public RadialItemList(Minecraft mc, int width, int height, int top, int bottom, List<ButtonBindingData> bindings) {
        super(mc, width, height, top, bottom, 36);
        this.bindings = bindings;
        this.updateEntries();
    }

    private void updateEntries() {
        this.func_230963_j_();
        this.bindings.forEach(binding -> this.func_230513_b_((AbstractList.AbstractListEntry)new ButtonBindingEntry((ButtonBindingData)binding)));
        ButtonBindingEntry selected = this.func_231039_at__().stream().filter(data -> data.getData().getBinding() == this.selectedBinding).findFirst().orElse(null);
        if (selected == null && this.func_231039_at__().size() > 0) {
            selected = (ButtonBindingEntry)((Object)this.func_231039_at__().get(0));
            this.selectedBinding = selected.getData().getBinding();
        }
        this.func_241215_a_((AbstractList.AbstractListEntry)selected);
    }

    public int func_230949_c_() {
        return 260;
    }

    public int func_230968_n_() {
        return super.func_230968_n_();
    }

    class ButtonBindingEntry
    extends AbstractOptionList.Entry<ButtonBindingEntry> {
        private final ButtonBindingData data;
        private ITextComponent label;
        private ITextComponent description;
        private ColorButton colorButton;
        private Button moveUpButton;
        private Button moveDownButton;

        public ButtonBindingEntry(ButtonBindingData data) {
            this.data = data;
            this.label = new TranslationTextComponent(data.getBinding().getLabelKey()).func_240699_a_(data.getColor());
            this.description = new TranslationTextComponent(data.getBinding().getCategory());
            this.colorButton = new ColorButton(0, 0, button -> {
                data.setColor(this.colorButton.getColor());
                this.label = this.label.func_230531_f_().func_240699_a_(this.colorButton.getColor());
            });
            this.colorButton.setColor(data.getColor());
            this.moveUpButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 98, 35, 10, 10, button -> this.shiftBinding(false));
            this.moveDownButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 88, 35, 10, 10, button -> this.shiftBinding(true));
            this.updateButtons();
        }

        public ButtonBindingData getData() {
            return this.data;
        }

        private void shiftBinding(boolean down) {
            List bindings = RadialItemList.this.bindings;
            int index = bindings.indexOf(this.data);
            bindings.remove(this.data);
            index = MathHelper.func_76125_a((int)(index + (down ? 1 : -1)), (int)0, (int)bindings.size());
            bindings.add(index, this.data);
            this.updateButtons();
            RadialItemList.this.updateEntries();
        }

        private void updateButtons() {
            int index = RadialItemList.this.bindings.indexOf(this.data);
            this.moveUpButton.field_230693_o_ = index > 0;
            this.moveDownButton.field_230693_o_ = index < RadialItemList.this.bindings.size() - 1;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)((Object)this.colorButton), (Object)this.moveUpButton, (Object)this.moveDownButton);
        }

        public void func_230432_a_(MatrixStack matrixStack, int slotIndex, int top, int left, int listWidth, int slotHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            ((RadialItemList)RadialItemList.this).field_230668_b_.field_71466_p.func_243248_b(matrixStack, this.label, (float)(left + 5), (float)(top + 5), 0xFFFFFF);
            ((RadialItemList)RadialItemList.this).field_230668_b_.field_71466_p.func_243248_b(matrixStack, this.description, (float)(left + 5), (float)(top + 18), 0xFFFFFF);
            this.colorButton.field_230694_p_ = RadialItemList.this.func_230958_g_() == this;
            this.colorButton.field_230690_l_ = left + RadialItemList.this.func_230949_c_() - 78;
            this.colorButton.field_230691_m_ = top + 6;
            this.colorButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.moveUpButton.field_230694_p_ = RadialItemList.this.func_230958_g_() == this;
            this.moveUpButton.field_230690_l_ = left + RadialItemList.this.func_230949_c_() - 34;
            this.moveUpButton.field_230691_m_ = top + 6;
            this.moveUpButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.moveDownButton.field_230694_p_ = RadialItemList.this.func_230958_g_() == this;
            this.moveDownButton.field_230690_l_ = left + RadialItemList.this.func_230949_c_() - 56;
            this.moveDownButton.field_230691_m_ = top + 6;
            this.moveDownButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            RadialItemList.this.func_241215_a_((AbstractList.AbstractListEntry)this);
            RadialItemList.this.selectedBinding = this.data.getBinding();
            return super.func_231044_a_(mouseX, mouseY, button);
        }
    }
}

