/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.gui.ControllerButton;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import org.lwjgl.glfw.GLFWGamepadState;

public class ControllerAxis
extends ControllerButton {
    public ControllerAxis(ControllerLayoutScreen screen, int button, int x, int y, int u, int v, int width, int height, int scale) {
        super(screen, button, x, y, u, v, width, height, scale);
    }

    @Override
    public void draw(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, boolean selected) {
        RenderSystem.pushMatrix();
        Controller controller = Controllable.getController();
        if (controller != null) {
            GLFWGamepadState gamepad = controller.getGamepadState();
            switch (this.button) {
                case 7: {
                    float leftX = gamepad.axes(this.screen.getEntry().isThumbsticksSwitched() ? 2 : 0);
                    float leftY = gamepad.axes(this.screen.getEntry().isThumbsticksSwitched() ? 3 : 1);
                    RenderSystem.translatef((float)((leftX *= this.screen.getEntry().isFlipLeftX() ? -1.0f : 1.0f) * 5.0f), (float)((leftY *= this.screen.getEntry().isFlipLeftY() ? -1.0f : 1.0f) * 5.0f), (float)0.0f);
                    break;
                }
                case 8: {
                    float rightX = gamepad.axes(this.screen.getEntry().isThumbsticksSwitched() ? 0 : 2);
                    float rightY = gamepad.axes(this.screen.getEntry().isThumbsticksSwitched() ? 1 : 3);
                    RenderSystem.translatef((float)((rightX *= this.screen.getEntry().isFlipRightX() ? -1.0f : 1.0f) * 5.0f), (float)((rightY *= this.screen.getEntry().isFlipRightY() ? -1.0f : 1.0f) * 5.0f), (float)0.0f);
                }
            }
            if (!this.screen.isButtonPressed(this.button)) {
                RenderSystem.translated((double)0.0, (double)-5.0, (double)0.0);
            }
        }
        super.draw(matrixStack, x, y, mouseX, mouseY, selected);
        RenderSystem.popMatrix();
    }
}

