/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ISearchable;
import com.mrcrayfish.controllable.client.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.gui.ButtonBindingListMenuScreen;
import com.mrcrayfish.controllable.client.gui.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.ListMenuScreen;
import com.mrcrayfish.controllable.client.gui.SelectKeyBindingScreen;
import com.mrcrayfish.controllable.client.gui.widget.ButtonBindingButton;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonBindingScreen
extends ButtonBindingListMenuScreen {
    private Button buttonReset;
    private ButtonBinding selectedBinding = null;

    protected ButtonBindingScreen(Screen parentScreen) {
        super(parentScreen, (ITextComponent)new TranslationTextComponent("controllable.gui.title.button_binding"), 22);
    }

    void setSelectedBinding(ButtonBinding selectedBinding) {
        this.selectedBinding = selectedBinding;
    }

    boolean isWaitingForButtonInput() {
        return this.selectedBinding != null;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.buttonReset = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 32, 100, 20, (ITextComponent)new TranslationTextComponent("controllable.gui.resetBinds"), button -> this.field_230706_i_.func_147108_a((Screen)new ConfirmationScreen(this, (ITextComponent)new TranslationTextComponent("controllable.gui.restore_default_buttons"), result -> {
            if (result.booleanValue()) {
                BindingRegistry registry = BindingRegistry.getInstance();
                registry.getBindings().forEach(ButtonBinding::reset);
                registry.resetBindingHash();
                registry.save();
            }
            return true;
        }))));
        this.buttonReset.field_230693_o_ = BindingRegistry.getInstance().getBindings().stream().noneMatch(ButtonBinding::isDefault);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50, this.field_230709_l_ - 32, 100, 20, (ITextComponent)new TranslationTextComponent("controllable.gui.add_key_bind"), button -> Objects.requireNonNull(this.field_230706_i_).func_147108_a((Screen)new SelectKeyBindingScreen(this))));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 55, this.field_230709_l_ - 32, 100, 20, DialogTexts.field_240632_c_, button -> {
            Objects.requireNonNull(this.field_230706_i_).func_147108_a(this.parent);
            BindingRegistry registry = BindingRegistry.getInstance();
            registry.resetBindingHash();
            registry.save();
        }));
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        this.updateList(entries, false);
    }

    public void func_231023_e_() {
        this.buttonReset.field_230693_o_ = !BindingRegistry.getInstance().getBindings().stream().allMatch(ButtonBinding::isDefault);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, this.selectedBinding == null ? mouseX : -1, this.selectedBinding == null ? mouseY : -1, partialTicks);
        if (this.selectedBinding != null) {
            RenderSystem.disableDepthTest();
            this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
            ButtonBindingScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("controllable.gui.layout.press_button"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)-1);
            RenderSystem.enableDepthTest();
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.selectedBinding != null && this.isWaitingForButtonInput()) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231046_a_(int key, int scanCode, int mods) {
        if (key == 256 && this.selectedBinding != null) {
            this.selectedBinding = null;
            return true;
        }
        return super.func_231046_a_(key, scanCode, mods);
    }

    public boolean processButton(int index) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setButton(index);
            this.selectedBinding = null;
            BindingRegistry registry = BindingRegistry.getInstance();
            registry.resetBindingHash();
            registry.save();
            return true;
        }
        return false;
    }

    @Override
    protected ListMenuScreen.Item createItemFromBinding(ButtonBinding binding) {
        return new ButtonBindingItem(binding);
    }

    public class ButtonBindingItem
    extends ListMenuScreen.Item
    implements ISearchable {
        private final ButtonBinding binding;
        private final Button bindingButton;
        private final Button deleteButton;
        private final Button removeButton;

        protected ButtonBindingItem(ButtonBinding binding) {
            super((ListMenuScreen)ButtonBindingScreen.this, (ITextComponent)new TranslationTextComponent(binding.getLabelKey()));
            this.binding = binding;
            this.bindingButton = new ButtonBindingButton(0, 0, binding, button -> ButtonBindingScreen.this.setSelectedBinding(this.binding));
            this.deleteButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 108, 0, 16, 16, button -> {
                binding.reset();
                BindingRegistry registry = BindingRegistry.getInstance();
                registry.resetBindingHash();
                registry.save();
            });
            this.removeButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 0, 0, 16, 16, button -> {
                if (binding instanceof KeyAdapterBinding) {
                    BindingRegistry.getInstance().removeKeyAdapter((KeyAdapterBinding)binding);
                }
                ButtonBindingScreen.this.list.removeEntry(this);
            });
            this.removeButton.field_230694_p_ = binding instanceof KeyAdapterBinding;
        }

        @Override
        public String getLabel() {
            return this.label.func_230531_f_().getString();
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.bindingButton, (Object)this.deleteButton);
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int y, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            int color = this.binding.isConflictingContext() ? TextFormatting.RED.func_211163_e() : TextFormatting.WHITE.func_211163_e();
            ((ButtonBindingScreen)ButtonBindingScreen.this).field_230706_i_.field_71466_p.func_243246_a(matrixStack, this.label, (float)left, (float)(y + 6), color);
            this.bindingButton.field_230690_l_ = left + width - 42;
            this.bindingButton.field_230691_m_ = y;
            this.bindingButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.deleteButton.field_230690_l_ = left + width - 20;
            this.deleteButton.field_230691_m_ = y;
            this.deleteButton.field_230693_o_ = !this.binding.isDefault();
            this.deleteButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (button == 1 && this.bindingButton.func_230449_g_()) {
                this.binding.setButton(-1);
                this.bindingButton.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
            return super.func_231044_a_(mouseX, mouseY, button);
        }
    }
}

