/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonObject;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.recipe.WrappedShapedRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WrappedShapedRecipeSerializer<RECIPE extends WrappedShapedRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final Function<ShapedRecipe, RECIPE> wrapper;

    public WrappedShapedRecipeSerializer(Function<ShapedRecipe, RECIPE> wrapper) {
        this.wrapper = wrapper;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        return (RECIPE)((WrappedShapedRecipe)this.wrapper.apply((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json)));
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            return (RECIPE)((WrappedShapedRecipe)this.wrapper.apply((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer)));
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading wrapped shaped recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        try {
            IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)((WrappedShapedRecipe)recipe).getInternal());
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing wrapped shaped recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

