/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.List;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateModuleSettings
implements IMekanismPacket {
    private final ModuleData<?> moduleType;
    private final int slotId;
    private final int dataIndex;
    private final ModuleDataType dataType;
    private final Object value;

    public static PacketUpdateModuleSettings create(int slotId, ModuleData<?> moduleType, int dataIndex, ModuleConfigData<?> configData) {
        if (configData instanceof ModuleBooleanData) {
            return new PacketUpdateModuleSettings(slotId, moduleType, dataIndex, ModuleDataType.BOOLEAN, configData.get());
        }
        if (configData instanceof ModuleEnumData) {
            return new PacketUpdateModuleSettings(slotId, moduleType, dataIndex, ModuleDataType.ENUM, ((Enum)((ModuleEnumData)configData).get()).ordinal());
        }
        throw new IllegalArgumentException("Unknown config data type.");
    }

    private PacketUpdateModuleSettings(int slotId, ModuleData<?> moduleType, int dataIndex, ModuleDataType dataType, Object value) {
        this.slotId = slotId;
        this.moduleType = moduleType;
        this.dataIndex = dataIndex;
        this.dataType = dataType;
        this.value = value;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        List<ModuleConfigItem<?>> configItems;
        IModule module;
        ItemStack stack;
        ServerPlayerEntity player = context.getSender();
        if (player != null && this.dataIndex >= 0 && this.value != null && !(stack = player.field_71071_by.func_70301_a(this.slotId)).func_190926_b() && stack.func_77973_b() instanceof IModuleContainerItem && (module = ModuleHelper.INSTANCE.load(stack, (IModuleDataProvider)this.moduleType)) != null && this.dataIndex < (configItems = ((Module)module).getConfigItems()).size()) {
            this.setValue(configItems.get(this.dataIndex));
        }
    }

    private <TYPE> void setValue(ModuleConfigItem<TYPE> moduleConfigItem) {
        ModuleConfigData<TYPE> configData = moduleConfigItem.getData();
        if (configData instanceof ModuleBooleanData && this.dataType == ModuleDataType.BOOLEAN) {
            moduleConfigItem.set((Boolean)this.value);
        } else if (configData instanceof ModuleEnumData && this.dataType == ModuleDataType.ENUM) {
            moduleConfigItem.set((Boolean)MathUtils.getByIndexMod(((ModuleEnumData)configData).getEnums(), (int)((Integer)this.value)));
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.slotId);
        buffer.writeRegistryId(this.moduleType);
        buffer.func_150787_b(this.dataIndex);
        buffer.func_179249_a((Enum)this.dataType);
        switch (this.dataType) {
            case BOOLEAN: {
                buffer.writeBoolean(((Boolean)this.value).booleanValue());
                break;
            }
            case ENUM: {
                buffer.func_150787_b(((Integer)this.value).intValue());
            }
        }
    }

    public static PacketUpdateModuleSettings decode(PacketBuffer buffer) {
        int slotId = buffer.func_150792_a();
        ModuleData moduleType = (ModuleData)buffer.readRegistryId();
        int dataIndex = buffer.func_150792_a();
        ModuleDataType dataType = (ModuleDataType)buffer.func_179257_a(ModuleDataType.class);
        Comparable<Boolean> data = null;
        switch (dataType) {
            case BOOLEAN: {
                data = buffer.readBoolean();
                break;
            }
            case ENUM: {
                data = buffer.func_150792_a();
            }
        }
        return new PacketUpdateModuleSettings(slotId, moduleType, dataIndex, dataType, data);
    }

    private static enum ModuleDataType {
        BOOLEAN,
        ENUM;

    }
}

