/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.container;

import java.util.ArrayList;
import java.util.List;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.to_client.container.property.PropertyData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateContainer
implements IMekanismPacket {
    private final short windowId;
    private final List<PropertyData> data;

    public PacketUpdateContainer(short windowId, List<PropertyData> data) {
        this.windowId = windowId;
        this.data = data;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_71070_bA instanceof MekanismContainer && player.field_71070_bA.field_75152_c == this.windowId) {
            this.data.forEach(data -> data.handleWindowProperty((MekanismContainer)player.field_71070_bA));
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeByte((int)this.windowId);
        buffer.func_150787_b(this.data.size());
        for (PropertyData data : this.data) {
            data.writeToPacket(buffer);
        }
    }

    public static PacketUpdateContainer decode(PacketBuffer buffer) {
        short windowId = buffer.readUnsignedByte();
        int size = buffer.func_150792_a();
        ArrayList<PropertyData> data = new ArrayList<PropertyData>(size);
        for (int i = 0; i < size; ++i) {
            PropertyData propertyData = PropertyData.fromBuffer(buffer);
            if (propertyData == null) continue;
            data.add(propertyData);
        }
        return new PacketUpdateContainer(windowId, data);
    }
}

