/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import mekanism.common.content.network.transmitter.DiversionTransporter;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTransporterUpdate
implements IMekanismPacket {
    private final boolean isDiversion;
    private final boolean isSync;
    private final BlockPos pos;
    private LogisticalTransporterBase transporter;
    private DiversionTransporter.DiversionControl[] modes;
    private int stackId;
    private TransporterStack stack;
    private Int2ObjectMap<TransporterStack> updates;
    private IntSet deletes;

    public PacketTransporterUpdate(LogisticalTransporterBase tile, int stackId, TransporterStack stack) {
        this(tile, true);
        this.stackId = stackId;
        this.stack = stack;
    }

    public PacketTransporterUpdate(LogisticalTransporterBase tile, Int2ObjectMap<TransporterStack> updates, IntSet deletes) {
        this(tile, false);
        this.updates = updates;
        this.deletes = deletes;
    }

    private PacketTransporterUpdate(LogisticalTransporterBase transporter, boolean isSync) {
        this.isSync = isSync;
        this.pos = transporter.getTilePos();
        this.isDiversion = transporter instanceof DiversionTransporter;
        if (this.isDiversion) {
            this.modes = ((DiversionTransporter)transporter).modes;
        }
        this.transporter = transporter;
    }

    private PacketTransporterUpdate(BlockPos pos, boolean isSync, boolean isDiversion) {
        this.pos = pos;
        this.isSync = isSync;
        this.isDiversion = isDiversion;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        TileEntityLogisticalTransporterBase tile = WorldUtils.getTileEntity(TileEntityLogisticalTransporterBase.class, (IBlockReader)Minecraft.func_71410_x().field_71441_e, this.pos);
        if (tile != null) {
            LogisticalTransporterBase transporter = tile.getTransmitter();
            if (this.isSync) {
                transporter.addStack(this.stackId, this.stack);
            } else {
                for (Int2ObjectMap.Entry entry : this.updates.int2ObjectEntrySet()) {
                    transporter.addStack(entry.getIntKey(), (TransporterStack)entry.getValue());
                }
                ObjectIterator objectIterator = this.deletes.iterator();
                while (objectIterator.hasNext()) {
                    int toDelete = (Integer)objectIterator.next();
                    transporter.deleteStack(toDelete);
                }
            }
            if (this.isDiversion && transporter instanceof DiversionTransporter) {
                System.arraycopy(this.modes, 0, ((DiversionTransporter)transporter).modes, 0, this.modes.length);
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeBoolean(this.isSync);
        buffer.writeBoolean(this.isDiversion);
        if (this.isSync) {
            buffer.func_150787_b(this.stackId);
            this.stack.write(this.transporter, buffer);
        } else {
            buffer.func_150787_b(this.updates.size());
            for (Int2ObjectMap.Entry entry : this.updates.int2ObjectEntrySet()) {
                buffer.func_150787_b(entry.getIntKey());
                ((TransporterStack)entry.getValue()).write(this.transporter, buffer);
            }
            buffer.func_150787_b(this.deletes.size());
            IntIterator intIterator = this.deletes.iterator();
            while (intIterator.hasNext()) {
                int toDelete = (Integer)intIterator.next();
                buffer.func_150787_b(toDelete);
            }
        }
        if (this.isDiversion) {
            for (IntIterator mode : this.modes) {
                buffer.func_179249_a((Enum)mode);
            }
        }
    }

    public static PacketTransporterUpdate decode(PacketBuffer buffer) {
        PacketTransporterUpdate packet = new PacketTransporterUpdate(buffer.func_179259_c(), buffer.readBoolean(), buffer.readBoolean());
        if (packet.isSync) {
            packet.stackId = buffer.func_150792_a();
            packet.stack = TransporterStack.readFromPacket(buffer);
        } else {
            int updatesSize = buffer.func_150792_a();
            packet.updates = new Int2ObjectOpenHashMap(updatesSize);
            for (int i = 0; i < updatesSize; ++i) {
                packet.updates.put(buffer.func_150792_a(), (Object)TransporterStack.readFromPacket(buffer));
            }
            int deletesSize = buffer.func_150792_a();
            packet.deletes = new IntOpenHashSet(deletesSize);
            for (int i = 0; i < deletesSize; ++i) {
                packet.deletes.add(buffer.func_150792_a());
            }
        }
        if (packet.isDiversion) {
            packet.modes = new DiversionTransporter.DiversionControl[EnumUtils.DIRECTIONS.length];
            for (int i = 0; i < packet.modes.length; ++i) {
                packet.modes[i] = (DiversionTransporter.DiversionControl)buffer.func_179257_a(DiversionTransporter.DiversionControl.class);
            }
        }
        return packet;
    }
}

