/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mekanism.common.MekanismLang;
import mekanism.common.lib.math.voxel.IShape;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IMultiblockBase;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.IStructureValidator;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.lib.multiblock.StructureHelper;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;

public abstract class CuboidStructureValidator<T extends MultiblockData>
implements IStructureValidator<T> {
    private final VoxelCuboid minBounds;
    private final VoxelCuboid maxBounds;
    protected VoxelCuboid cuboid;
    protected Structure structure;
    protected World world;
    protected MultiblockManager<T> manager;

    public CuboidStructureValidator() {
        this(new VoxelCuboid(3, 3, 3), new VoxelCuboid(18, 18, 18));
    }

    public CuboidStructureValidator(VoxelCuboid minBounds, VoxelCuboid maxBounds) {
        this.minBounds = minBounds;
        this.maxBounds = maxBounds;
    }

    @Override
    public void init(World world, MultiblockManager<T> manager, Structure structure) {
        this.world = world;
        this.manager = manager;
        this.structure = structure;
    }

    @Override
    public FormationProtocol.FormationResult validate(FormationProtocol<T> ctx, Long2ObjectMap<IChunk> chunkMap) {
        BlockPos min = this.cuboid.getMinPos();
        BlockPos max = this.cuboid.getMaxPos();
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    mutablePos.func_181079_c(x, y, z);
                    FormationProtocol.FormationResult ret = this.validateNode(ctx, chunkMap, (BlockPos)mutablePos);
                    if (ret.isFormed()) continue;
                    return ret;
                }
            }
        }
        return FormationProtocol.FormationResult.SUCCESS;
    }

    protected FormationProtocol.FormationResult validateNode(FormationProtocol<T> ctx, Long2ObjectMap<IChunk> chunkMap, BlockPos pos) {
        Optional<BlockState> optionalState = WorldUtils.getBlockState((IWorld)this.world, chunkMap, pos);
        if (!optionalState.isPresent()) {
            return FormationProtocol.FormationResult.FAIL;
        }
        BlockState state = optionalState.get();
        FormationProtocol.StructureRequirement requirement = this.getStructureRequirement(pos);
        if (requirement.isCasing()) {
            FormationProtocol.CasingType type = this.getCasingType(state);
            FormationProtocol.FormationResult ret = this.validateFrame(ctx, pos, state, type, requirement.needsFrame());
            if (requirement != FormationProtocol.StructureRequirement.IGNORED && !ret.isFormed()) {
                return ret;
            }
        } else {
            if (!this.validateInner(state, chunkMap, pos)) {
                return FormationProtocol.FormationResult.fail(MekanismLang.MULTIBLOCK_INVALID_INNER, pos);
            }
            if (!state.isAir((IBlockReader)this.world, pos)) {
                ctx.innerNodes.add(pos.func_185334_h());
            }
        }
        return FormationProtocol.FormationResult.SUCCESS;
    }

    protected boolean validateInner(BlockState state, Long2ObjectMap<IChunk> chunkMap, BlockPos pos) {
        return state.isAir((IBlockReader)this.world, pos);
    }

    protected abstract FormationProtocol.CasingType getCasingType(BlockState var1);

    protected boolean isFrameCompatible(TileEntity tile) {
        if (tile instanceof IStructuralMultiblock && ((IStructuralMultiblock)tile).canInterface(this.manager)) {
            return true;
        }
        return this.manager.isCompatible(tile);
    }

    protected FormationProtocol.FormationResult validateFrame(FormationProtocol<T> ctx, BlockPos pos, BlockState state, FormationProtocol.CasingType type, boolean needsFrame) {
        IMultiblock multiblockTile;
        UUID uuid;
        IMultiblockBase tile = this.structure.getTile(pos);
        if (!this.isFrameCompatible((TileEntity)tile) || needsFrame && !type.isFrame()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.MULTIBLOCK_INVALID_FRAME, pos);
        }
        if (tile instanceof IMultiblock && (uuid = (multiblockTile = (IMultiblock)tile).getCacheID()) != null && multiblockTile.getManager() == this.manager && multiblockTile.hasCache()) {
            this.manager.updateCache(multiblockTile, multiblockTile.getMultiblock());
            ctx.idsFound.add(uuid);
        }
        pos = pos.func_185334_h();
        ctx.locations.add(pos);
        if (type.isValve()) {
            IValveHandler.ValveData data = new IValveHandler.ValveData();
            data.location = pos;
            data.side = this.getSide(data.location);
            ctx.valves.add(data);
        }
        return FormationProtocol.FormationResult.SUCCESS;
    }

    @Override
    public FormationProtocol.FormationResult postcheck(T structure, Set<BlockPos> innerNodes, Long2ObjectMap<IChunk> chunkMap) {
        return FormationProtocol.FormationResult.SUCCESS;
    }

    protected FormationProtocol.StructureRequirement getStructureRequirement(BlockPos pos) {
        VoxelCuboid.WallRelative relative = this.cuboid.getWallRelative(pos);
        if (relative.isOnEdge()) {
            return FormationProtocol.StructureRequirement.FRAME;
        }
        return relative.isWall() ? FormationProtocol.StructureRequirement.OTHER : FormationProtocol.StructureRequirement.INNER;
    }

    protected Direction getSide(BlockPos pos) {
        return this.cuboid.getSide(pos);
    }

    @Override
    public IShape getShape() {
        return this.cuboid;
    }

    @Override
    public boolean precheck() {
        this.cuboid = StructureHelper.fetchCuboid(this.structure, this.minBounds, this.maxBounds);
        return this.cuboid != null;
    }

    public void loadCuboid(VoxelCuboid cuboid) {
        this.cuboid = cuboid;
    }
}

