/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block.machine;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.text.EnumColor;
import mekanism.client.render.item.ISTERProvider;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.basic.BlockFluidTank;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.item.RateLimitFluidHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemBlockFluidTank
extends ItemBlockTooltip<BlockFluidTank>
implements IItemSustainedInventory,
ISecurityItem,
IModeItem {
    public ItemBlockFluidTank(BlockFluidTank block) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().func_200917_a(1).setISTER(ISTERProvider::fluidTank));
    }

    @Override
    @Nonnull
    public FluidTankTier getTier() {
        return Attribute.getTier(this.func_179223_d(), FluidTankTier.class);
    }

    @Override
    public void addStats(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, boolean advanced) {
        FluidTankTier tier = this.getTier();
        FluidStack fluidStack = StorageUtils.getStoredFluidFromNBT(stack);
        if (fluidStack.isEmpty()) {
            tooltip.add((ITextComponent)MekanismLang.EMPTY.translateColored(EnumColor.DARK_RED, new Object[0]));
        } else if (tier == FluidTankTier.CREATIVE) {
            tooltip.add((ITextComponent)MekanismLang.GENERIC_STORED.translateColored(EnumColor.PINK, fluidStack, EnumColor.GRAY, MekanismLang.INFINITE));
        } else {
            tooltip.add((ITextComponent)MekanismLang.GENERIC_STORED_MB.translateColored(EnumColor.PINK, fluidStack, EnumColor.GRAY, TextUtils.format(fluidStack.getAmount())));
        }
        if (tier == FluidTankTier.CREATIVE) {
            tooltip.add((ITextComponent)MekanismLang.CAPACITY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, MekanismLang.INFINITE));
        } else {
            tooltip.add((ITextComponent)MekanismLang.CAPACITY_MB.translateColored(EnumColor.INDIGO, EnumColor.GRAY, TextUtils.format(tier.getStorage())));
        }
    }

    @Override
    public void addDetails(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, boolean advanced) {
        SecurityUtils.addSecurityTooltip(stack, tooltip);
        tooltip.add((ITextComponent)MekanismLang.BUCKET_MODE.translateColored(EnumColor.INDIGO, BooleanStateDisplay.YesNo.of(this.getBucketMode(stack))));
        tooltip.add((ITextComponent)MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))));
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        FluidTankTier tier;
        super.func_150895_a(group, items);
        if (this.func_194125_a(group) && (tier = Attribute.getTier(this.func_179223_d(), FluidTankTier.class)) == FluidTankTier.CREATIVE && MekanismConfig.general.prefilledFluidTanks.get()) {
            int capacity = tier.getStorage();
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                if (!fluid.func_207193_c(fluid.func_207188_f())) continue;
                BasicFluidTank dummyTank = BasicFluidTank.create(capacity, null);
                dummyTank.setStack(new FluidStack(fluid, dummyTank.getCapacity()));
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemDataUtils.setList(stack, "FluidTanks", DataHandlerUtils.writeContainers(Collections.singletonList(dummyTank)));
                items.add((Object)stack);
            }
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        ItemStack stack = context.func_195996_i();
        if (this.getBucketMode(stack)) {
            return ActionResultType.PASS;
        }
        return super.func_195939_a(context);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getBucketMode(stack)) {
            if (this.getOwnerUUID(stack) == null) {
                if (!world.field_72995_K) {
                    SecurityUtils.claimItem(player, stack);
                }
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
            if (SecurityUtils.canAccess(player, stack)) {
                BlockRayTraceResult result = ItemBlockFluidTank.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)(!player.func_225608_bj_() ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
                if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockPos pos = result.func_216350_a();
                    if (!world.func_175660_a(player, pos)) {
                        return new ActionResult(ActionResultType.FAIL, (Object)stack);
                    }
                    IExtendedFluidTank fluidTank = ItemBlockFluidTank.getExtendedFluidTank(stack);
                    if (fluidTank == null) {
                        return new ActionResult(ActionResultType.FAIL, (Object)stack);
                    }
                    if (!player.func_225608_bj_()) {
                        if (!player.func_175151_a(pos, result.func_216354_b(), stack)) {
                            return new ActionResult(ActionResultType.FAIL, (Object)stack);
                        }
                        BlockState blockState = world.func_180495_p(pos);
                        FluidState fluidState = blockState.func_204520_s();
                        if (!fluidState.func_206888_e() && fluidState.func_206889_d()) {
                            Fluid fluid = fluidState.func_206886_c();
                            FluidStack fluidStack = new FluidStack(fluid, 1000);
                            Block block = blockState.func_177230_c();
                            if (block instanceof IFluidBlock) {
                                fluidStack = ((IFluidBlock)block).drain(world, pos, IFluidHandler.FluidAction.SIMULATE);
                                if (!ItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                                    return new ActionResult(ActionResultType.PASS, (Object)stack);
                                }
                                fluidStack = ((IFluidBlock)block).drain(world, pos, IFluidHandler.FluidAction.EXECUTE);
                            } else if (block instanceof IBucketPickupHandler && ItemBlockFluidTank.validFluid(fluidTank, fluidStack) && !ItemBlockFluidTank.validFluid(fluidTank, fluidStack = new FluidStack(fluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)world, pos, blockState), 1000))) {
                                Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", (Object)fluidState.func_206886_c().getRegistryName(), (Object)pos, (Object)world.func_234923_W_().func_240901_a_(), (Object)fluid.getRegistryName());
                                return new ActionResult(ActionResultType.FAIL, (Object)stack);
                            }
                            if (ItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                                if (fluidTank.isEmpty()) {
                                    fluidTank.setStack(fluidStack);
                                } else {
                                    MekanismUtils.logMismatchedStackSize(fluidTank.growStack(fluidStack.getAmount(), Action.EXECUTE), fluidStack.getAmount());
                                }
                                WorldUtils.playFillSound(player, (IWorld)world, pos, fluidStack);
                                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                            }
                            return new ActionResult(ActionResultType.FAIL, (Object)stack);
                        }
                    } else {
                        if (fluidTank.extract(1000, Action.SIMULATE, AutomationType.MANUAL).getAmount() < 1000 || !player.func_175151_a(pos.func_177972_a(result.func_216354_b()), result.func_216354_b(), stack)) {
                            return new ActionResult(ActionResultType.FAIL, (Object)stack);
                        }
                        if (WorldUtils.tryPlaceContainedLiquid(player, world, pos, fluidTank.getFluid(), result.func_216354_b())) {
                            if (!player.func_184812_l_()) {
                                MekanismUtils.logMismatchedStackSize(fluidTank.shrinkStack(1000, Action.EXECUTE), 1000L);
                            }
                            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                        }
                    }
                }
            } else {
                if (!world.field_72995_K) {
                    SecurityUtils.displayNoAccess(player);
                }
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    private static boolean validFluid(@Nonnull IExtendedFluidTank fluidTank, @Nonnull FluidStack fluidStack) {
        return !fluidStack.isEmpty() && fluidTank.insert(fluidStack, Action.SIMULATE, AutomationType.MANUAL).isEmpty();
    }

    private static IExtendedFluidTank getExtendedFluidTank(@Nonnull ItemStack stack) {
        IFluidHandlerItem fluidHandlerItem;
        Optional capability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (capability.isPresent() && (fluidHandlerItem = (IFluidHandlerItem)capability.get()) instanceof IMekanismFluidHandler) {
            return ((IMekanismFluidHandler)fluidHandlerItem).getFluidTank(0, null);
        }
        return null;
    }

    public void setBucketMode(ItemStack itemStack, boolean bucketMode) {
        ItemDataUtils.setBoolean(itemStack, "bucketMode", bucketMode);
    }

    public boolean getBucketMode(ItemStack itemStack) {
        return ItemDataUtils.getBoolean(itemStack, "bucketMode");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, RateLimitFluidHandler.create(this.getTier()));
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        if (Math.abs(shift) % 2 == 1) {
            boolean newState = !this.getBucketMode(stack);
            this.setBucketMode(stack, newState);
            if (displayChangeMessage) {
                player.func_145747_a(MekanismUtils.logFormat(MekanismLang.BUCKET_MODE.translate(BooleanStateDisplay.OnOff.of(newState, true))), Util.field_240973_b_);
            }
        }
    }

    @Override
    @Nonnull
    public ITextComponent getScrollTextComponent(@Nonnull ItemStack stack) {
        return MekanismLang.BUCKET_MODE.translateColored(EnumColor.GRAY, BooleanStateDisplay.OnOff.of(this.getBucketMode(stack), true));
    }

    public static class FluidTankItemDispenseBehavior
    extends DefaultDispenseItemBehavior {
        public static final FluidTankItemDispenseBehavior INSTANCE = new FluidTankItemDispenseBehavior();

        private FluidTankItemDispenseBehavior() {
        }

        @Nonnull
        public ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
            if (stack.func_77973_b() instanceof ItemBlockFluidTank && ((ItemBlockFluidTank)stack.func_77973_b()).getBucketMode(stack)) {
                BlockPos pos;
                IExtendedFluidTank fluidTank = ItemBlockFluidTank.getExtendedFluidTank(stack);
                if (fluidTank == null) {
                    return super.func_82487_b(source, stack);
                }
                ServerWorld world = source.func_197524_h();
                BlockState blockState = world.func_180495_p(pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
                FluidState fluidState = blockState.func_204520_s();
                if (!fluidState.func_206888_e() && fluidState.func_206889_d()) {
                    Fluid fluid = fluidState.func_206886_c();
                    FluidStack fluidStack = new FluidStack(fluid, 1000);
                    Block block = blockState.func_177230_c();
                    if (block instanceof IFluidBlock) {
                        fluidStack = ((IFluidBlock)block).drain((World)world, pos, IFluidHandler.FluidAction.SIMULATE);
                        if (!ItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                            return super.func_82487_b(source, stack);
                        }
                        fluidStack = ((IFluidBlock)block).drain((World)world, pos, IFluidHandler.FluidAction.EXECUTE);
                    } else if (block instanceof IBucketPickupHandler && ItemBlockFluidTank.validFluid(fluidTank, fluidStack) && !ItemBlockFluidTank.validFluid(fluidTank, fluidStack = new FluidStack(fluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)world, pos, blockState), 1000))) {
                        Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", (Object)fluidState.func_206886_c().getRegistryName(), (Object)pos, (Object)world.func_234923_W_().func_240901_a_(), (Object)fluid.getRegistryName());
                        return super.func_82487_b(source, stack);
                    }
                    if (ItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                        if (fluidTank.isEmpty()) {
                            fluidTank.setStack(fluidStack);
                        } else {
                            MekanismUtils.logMismatchedStackSize(fluidTank.growStack(fluidStack.getAmount(), Action.EXECUTE), fluidStack.getAmount());
                        }
                        WorldUtils.playFillSound(null, (IWorld)world, pos, fluidStack);
                        return stack;
                    }
                } else if (fluidTank.extract(1000, Action.SIMULATE, AutomationType.MANUAL).getAmount() >= 1000 && WorldUtils.tryPlaceContainedLiquid(null, (World)world, pos, fluidTank.getFluid(), null)) {
                    MekanismUtils.logMismatchedStackSize(fluidTank.shrinkStack(1000, Action.EXECUTE), 1000L);
                    return stack;
                }
            }
            return super.func_82487_b(source, stack);
        }
    }
}

