/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.item.FrequencyItemContainer;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.StorageUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public class PortableTeleporterContainer
extends FrequencyItemContainer<TeleporterFrequency>
implements IEmptyContainer {
    private byte status;

    public PortableTeleporterContainer(int id, PlayerInventory inv, Hand hand, ItemStack stack) {
        super(MekanismContainerTypes.PORTABLE_TELEPORTER, id, inv, hand, stack);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public FrequencyType<TeleporterFrequency> getFrequencyType() {
        return FrequencyType.TELEPORTER;
    }

    public byte getStatus() {
        return this.status;
    }

    @Override
    protected void addContainerTrackers() {
        super.addContainerTrackers();
        if (this.isRemote()) {
            this.track(SyncableByte.create(() -> this.status, value -> {
                this.status = value;
            }));
        } else {
            this.track(SyncableByte.create(() -> {
                int status = 3;
                TeleporterFrequency freq = (TeleporterFrequency)this.getFrequency();
                if (freq != null && !freq.getActiveCoords().isEmpty()) {
                    status = 1;
                    if (!this.inv.field_70458_d.func_184812_l_()) {
                        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(this.stack, 0);
                        if (energyContainer == null) {
                            status = 4;
                        } else {
                            FloatingLong energyNeeded;
                            Coord4D coords = freq.getClosestCoords(new Coord4D((Entity)this.inv.field_70458_d));
                            if (coords != null && energyContainer.extract(energyNeeded = TileEntityTeleporter.calculateEnergyCost((Entity)this.inv.field_70458_d, coords), Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyNeeded)) {
                                status = 4;
                            }
                        }
                    }
                }
                return (byte)status;
            }, value -> {
                this.status = value;
            }));
        }
    }
}

