/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import java.util.Collections;
import java.util.List;
import mekanism.common.inventory.container.item.MekanismItemContainer;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public abstract class FrequencyItemContainer<FREQ extends Frequency>
extends MekanismItemContainer {
    private List<FREQ> publicCache = Collections.emptyList();
    private List<FREQ> privateCache = Collections.emptyList();
    private FREQ selectedFrequency;

    protected FrequencyItemContainer(ContainerTypeRegistryObject<?> type, int id, PlayerInventory inv, Hand hand, ItemStack stack) {
        super(type, id, inv, hand, stack);
    }

    public abstract FrequencyType<FREQ> getFrequencyType();

    public Hand getHand() {
        return this.hand;
    }

    public FREQ getFrequency() {
        return this.selectedFrequency;
    }

    public List<FREQ> getPublicCache() {
        return this.publicCache;
    }

    public List<FREQ> getPrivateCache() {
        return this.privateCache;
    }

    @Override
    protected void addContainerTrackers() {
        super.addContainerTrackers();
        if (this.isRemote()) {
            this.track(SyncableFrequency.create(this::getFrequency, value -> {
                this.selectedFrequency = value;
            }));
            this.track(SyncableFrequencyList.create(this::getPublicCache, value -> {
                this.publicCache = value;
            }));
            this.track(SyncableFrequencyList.create(this::getPrivateCache, value -> {
                this.privateCache = value;
            }));
        } else {
            this.track(SyncableFrequency.create(() -> {
                IFrequencyItem frequencyItem = (IFrequencyItem)this.stack.func_77973_b();
                if (frequencyItem.hasFrequency(this.stack)) {
                    this.selectedFrequency = frequencyItem.getFrequency(this.stack);
                    if (this.selectedFrequency == null) {
                        frequencyItem.setFrequency(this.stack, null);
                    }
                } else {
                    this.selectedFrequency = null;
                }
                return this.selectedFrequency;
            }, value -> {
                this.selectedFrequency = value;
            }));
            this.track(SyncableFrequencyList.create(() -> this.getFrequencyType().getManager(null).getFrequencies(), value -> {
                this.publicCache = value;
            }));
            this.track(SyncableFrequencyList.create(() -> this.getFrequencyType().getManager(this.getPlayerUUID()).getFrequencies(), value -> {
                this.privateCache = value;
            }));
        }
    }
}

