/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSGas;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;

@RecipeTypeMapper
public class ChemicalDissolutionRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekDissolution";
    }

    public String getDescription() {
        return "Maps Mekanism dissolution recipes.";
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.DISSOLUTION;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe, INSSFakeGroupManager groupManager) {
        if (!(iRecipe instanceof ChemicalDissolutionRecipe)) {
            return false;
        }
        boolean handled = false;
        ChemicalDissolutionRecipe recipe = (ChemicalDissolutionRecipe)iRecipe;
        List<@NonNull TYPE> itemRepresentations = recipe.getItemInput().getRepresentations();
        List<@NonNull TYPE> gasRepresentations = recipe.getGasInput().getRepresentations();
        for (GasStack gasRepresentation : gasRepresentations) {
            NSSGas nssGas = NSSGas.createGas(gasRepresentation);
            long gasAmount = gasRepresentation.getAmount() * 100L;
            for (ItemStack itemRepresentation : itemRepresentations) {
                BoxedChemicalStack output = recipe.getOutput(itemRepresentation, gasRepresentation);
                if (output.isEmpty()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put(itemRepresentation);
                ingredientHelper.put((NormalizedSimpleStack)nssGas, gasAmount);
                if (!ingredientHelper.addAsConversion(output.getChemicalStack())) continue;
                handled = true;
            }
        }
        return handled;
    }
}

