/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.google.gson.JsonSyntaxException;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.recipe.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.EnergyConversionIRecipe;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.ItemStackToEnergy")
public abstract class ItemStackToEnergyRecipeManager
extends MekanismRecipeManager<ItemStackToEnergyRecipe> {
    protected ItemStackToEnergyRecipeManager(MekanismRecipeType<ItemStackToEnergyRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, FloatingLong output) {
        if (output.isZero()) {
            throw new JsonSyntaxException("Output must be greater than zero.");
        }
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, output.copyAsConst()));
    }

    protected abstract ItemStackToEnergyRecipe makeRecipe(ResourceLocation var1, ItemStackIngredient var2, FloatingLong var3);

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(ItemStackToEnergyRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                return ((ItemStackToEnergyRecipe)this.getRecipe()).getOutputDefinition().toString();
            }
        };
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.ItemStackToEnergy.EnergyConversion")
    public static class EnergyConversionRecipeManager
    extends ItemStackToEnergyRecipeManager {
        public static final EnergyConversionRecipeManager INSTANCE = new EnergyConversionRecipeManager();

        private EnergyConversionRecipeManager() {
            super(MekanismRecipeType.ENERGY_CONVERSION);
        }

        @Override
        protected ItemStackToEnergyRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, FloatingLong output) {
            return new EnergyConversionIRecipe(id, input, output);
        }
    }
}

