/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

public abstract class SorterFilter<FILTER extends SorterFilter<FILTER>>
extends BaseFilter<FILTER> {
    public static final int MAX_LENGTH = 48;
    public EnumColor color;
    public boolean allowDefault;
    public boolean sizeMode;
    public int min;
    public int max;

    protected SorterFilter() {
    }

    protected SorterFilter(FILTER filter) {
        this.allowDefault = ((SorterFilter)filter).allowDefault;
        this.color = ((SorterFilter)filter).color;
        this.sizeMode = ((SorterFilter)filter).sizeMode;
        this.min = ((SorterFilter)filter).min;
        this.max = ((SorterFilter)filter).max;
    }

    public abstract Finder getFinder();

    public TransitRequest mapInventory(TileEntity tile, Direction side, boolean singleItem) {
        if (this.sizeMode && !singleItem) {
            return TransitRequest.definedItem(tile, side, this.min, this.max, this.getFinder());
        }
        return TransitRequest.definedItem(tile, side, singleItem ? 1 : 64, this.getFinder());
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74757_a("allowDefault", this.allowDefault);
        nbtTags.func_74768_a("color", TransporterUtils.getColorIndex(this.color));
        nbtTags.func_74757_a("sizeMode", this.sizeMode);
        nbtTags.func_74768_a("min", this.min);
        nbtTags.func_74768_a("max", this.max);
        return nbtTags;
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        NBTUtils.setBooleanIfPresent(nbtTags, "allowDefault", value -> {
            this.allowDefault = value;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "color", TransporterUtils::readColor, color -> {
            this.color = color;
        });
        NBTUtils.setBooleanIfPresent(nbtTags, "sizeMode", value -> {
            this.sizeMode = value;
        });
        NBTUtils.setIntIfPresent(nbtTags, "min", value -> {
            this.min = value;
        });
        NBTUtils.setIntIfPresent(nbtTags, "max", value -> {
            this.max = value;
        });
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.allowDefault);
        buffer.func_150787_b(TransporterUtils.getColorIndex(this.color));
        buffer.writeBoolean(this.sizeMode);
        buffer.func_150787_b(this.min);
        buffer.func_150787_b(this.max);
    }

    @Override
    public void read(PacketBuffer dataStream) {
        this.allowDefault = dataStream.readBoolean();
        this.color = TransporterUtils.readColor(dataStream.func_150792_a());
        this.sizeMode = dataStream.readBoolean();
        this.min = dataStream.func_150792_a();
        this.max = dataStream.func_150792_a();
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + (this.color != null ? this.color.ordinal() : -1);
        code = 31 * code + (this.sizeMode ? 1 : 0);
        code = 31 * code + this.min;
        code = 31 * code + this.max;
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return filter instanceof SorterFilter && ((SorterFilter)filter).color == this.color && ((SorterFilter)filter).sizeMode == this.sizeMode && ((SorterFilter)filter).min == this.min && ((SorterFilter)filter).max == this.max;
    }
}

