/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.to_client.PacketLightningRender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

@ParametersAreNonnullByDefault
public class ModuleMagneticAttractionUnit
implements ICustomModule<ModuleMagneticAttractionUnit> {
    private IModuleConfigItem<Range> range;

    @Override
    public void init(IModule<ModuleMagneticAttractionUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.range = configItemCreator.createConfigItem("range", MekanismLang.MODULE_RANGE, new ModuleEnumData<Range>(Range.class, module.getInstalledCount() + 1, Range.LOW));
    }

    @Override
    public void tickServer(IModule<ModuleMagneticAttractionUnit> module, PlayerEntity player) {
        if (this.range.get() != Range.OFF) {
            IEnergyContainer energyContainer;
            float size = 4.0f + this.range.get().getRange();
            FloatingLong usage = ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageItemAttraction.get()).multiply(this.range.get().getRange());
            boolean free = usage.isZero() || player.func_184812_l_();
            IEnergyContainer iEnergyContainer = energyContainer = free ? null : module.getEnergyContainer();
            if (free || energyContainer != null && energyContainer.getEnergy().greaterOrEqual(usage)) {
                List items = player.field_70170_p.func_175647_a(ItemEntity.class, player.func_174813_aQ().func_72314_b((double)size, (double)size, (double)size), item -> !item.func_174874_s());
                for (ItemEntity item2 : items) {
                    if (!((double)item2.func_70032_d((Entity)player) > 0.001)) continue;
                    if (free) {
                        this.pullItem(player, item2);
                        continue;
                    }
                    if (module.useEnergy((LivingEntity)player, energyContainer, usage, true).isZero()) break;
                    this.pullItem(player, item2);
                    if (!energyContainer.getEnergy().smallerThan(usage)) continue;
                    break;
                }
            }
        }
    }

    private void pullItem(PlayerEntity player, ItemEntity item) {
        Vector3d diff = player.func_213303_ch().func_178788_d(item.func_213303_ch());
        Vector3d motionNeeded = new Vector3d(Math.min(diff.field_72450_a, 1.0), Math.min(diff.field_72448_b, 1.0), Math.min(diff.field_72449_c, 1.0));
        Vector3d motionDiff = motionNeeded.func_178788_d(player.func_213322_ci());
        item.func_213317_d(motionDiff.func_186678_a(0.2));
        Mekanism.packetHandler.sendToAllTrackingAndSelf(new PacketLightningRender(PacketLightningRender.LightningPreset.MAGNETIC_ATTRACTION, Objects.hash(player.func_110124_au(), item), player.func_213303_ch().func_72441_c(0.0, 0.2, 0.0), item.func_213303_ch(), (int)(diff.func_72433_c() * 4.0)), (Entity)player);
    }

    @Override
    public boolean canChangeModeWhenDisabled(IModule<ModuleMagneticAttractionUnit> module) {
        return true;
    }

    @Override
    public void changeMode(IModule<ModuleMagneticAttractionUnit> module, PlayerEntity player, ItemStack stack, int shift, boolean displayChangeMessage) {
        module.toggleEnabled(player, (ITextComponent)MekanismLang.MODULE_MAGNETIC_ATTRACTION.translate(new Object[0]));
    }

    public static enum Range implements IHasTextComponent
    {
        OFF(0.0f),
        LOW(1.0f),
        MED(3.0f),
        HIGH(5.0f),
        ULTRA(10.0f);

        private final float range;
        private final ITextComponent label;

        private Range(float boost) {
            this.range = boost;
            this.label = TextComponentUtil.getString(Float.toString(boost));
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.label;
        }

        public float getRange() {
            return this.range;
        }
    }
}

