/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IItemProvider;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.item.ItemModule;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.InterModComms;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ModuleHelper
implements IModuleHelper {
    public static final ModuleHelper INSTANCE = new ModuleHelper();
    private final Map<String, ModuleData<?>> legacyModuleLookup = new Object2ObjectOpenHashMap();
    private final Map<Item, Set<ModuleData<?>>> supportedModules = new Object2ObjectOpenHashMap(5);
    private final Map<ModuleData<?>, Set<Item>> supportedContainers = new Object2ObjectOpenHashMap();

    @Deprecated
    public void gatherLegacyModules() {
        for (ModuleData moduleData : MekanismAPI.moduleRegistry()) {
            String legacyName = moduleData.getLegacyName();
            if (legacyName == null) continue;
            this.legacyModuleLookup.put(legacyName, moduleData);
        }
    }

    public void processIMC() {
        Object2ObjectOpenHashMap supportedContainersBuilderMap = new Object2ObjectOpenHashMap();
        this.mapSupportedModules("add_meka_tool_modules", MekanismItems.MEKA_TOOL, (Map<ModuleData<?>, ImmutableSet.Builder<Item>>)supportedContainersBuilderMap);
        this.mapSupportedModules("add_meka_suit_helmet_modules", MekanismItems.MEKASUIT_HELMET, (Map<ModuleData<?>, ImmutableSet.Builder<Item>>)supportedContainersBuilderMap);
        this.mapSupportedModules("add_meka_suit_bodyarmor_modules", MekanismItems.MEKASUIT_BODYARMOR, (Map<ModuleData<?>, ImmutableSet.Builder<Item>>)supportedContainersBuilderMap);
        this.mapSupportedModules("add_meka_suit_pants_modules", MekanismItems.MEKASUIT_PANTS, (Map<ModuleData<?>, ImmutableSet.Builder<Item>>)supportedContainersBuilderMap);
        this.mapSupportedModules("add_meka_suit_boots_modules", MekanismItems.MEKASUIT_BOOTS, (Map<ModuleData<?>, ImmutableSet.Builder<Item>>)supportedContainersBuilderMap);
        for (Map.Entry entry : supportedContainersBuilderMap.entrySet()) {
            this.supportedContainers.put((ModuleData<?>)entry.getKey(), (Set<Item>)((ImmutableSet.Builder)entry.getValue()).build());
        }
    }

    private void mapSupportedModules(String imcMethod, IItemProvider moduleContainer, Map<ModuleData<?>, ImmutableSet.Builder<Item>> supportedContainersBuilderMap) {
        ImmutableSet.Builder supportedModulesBuilder = ImmutableSet.builder();
        InterModComms.getMessages((String)"mekanism", imcMethod::equals).forEach(message -> {
            Object body = message.getMessageSupplier().get();
            if (body instanceof IModuleDataProvider) {
                IModuleDataProvider moduleDataProvider = (IModuleDataProvider)body;
                supportedModulesBuilder.add(moduleDataProvider.getModuleData());
                this.logDebugReceivedIMC(imcMethod, message.getSenderModId(), moduleDataProvider);
            } else if (body instanceof IModuleDataProvider[]) {
                for (IModuleDataProvider moduleDataProvider : (IModuleDataProvider[])body) {
                    supportedModulesBuilder.add(moduleDataProvider.getModuleData());
                    this.logDebugReceivedIMC(imcMethod, message.getSenderModId(), moduleDataProvider);
                }
            } else {
                Mekanism.logger.warn("Received IMC message for '{}' from mod '{}' with an invalid body.", (Object)imcMethod, (Object)message.getSenderModId());
            }
        });
        ImmutableSet supported = supportedModulesBuilder.build();
        if (!supported.isEmpty()) {
            Item item = moduleContainer.getItem();
            this.supportedModules.put(item, (Set<ModuleData<?>>)supported);
            for (ModuleData data : supported) {
                supportedContainersBuilderMap.computeIfAbsent(data, d -> ImmutableSet.builder()).add((Object)item);
            }
        }
    }

    private void logDebugReceivedIMC(String imcMethod, String senderModId, IModuleDataProvider<?> moduleDataProvider) {
        Mekanism.logger.debug("Received '{}' IMC message from '{}' for module ''{}.", (Object)imcMethod, (Object)senderModId, (Object)moduleDataProvider.getRegistryName());
    }

    @Override
    public ItemModule createModuleItem(IModuleDataProvider<?> moduleDataProvider, Item.Properties properties) {
        return new ItemModule(moduleDataProvider, properties);
    }

    @Override
    public Set<ModuleData<?>> getSupported(ItemStack container) {
        return this.supportedModules.getOrDefault(container.func_77973_b(), Collections.emptySet());
    }

    @Override
    public Set<Item> getSupported(IModuleDataProvider<?> typeProvider) {
        return this.supportedContainers.getOrDefault(typeProvider.getModuleData(), Collections.emptySet());
    }

    @Override
    public boolean isEnabled(ItemStack container, IModuleDataProvider<?> typeProvider) {
        IModule m = this.load(container, (IModuleDataProvider)typeProvider);
        return m != null && m.isEnabled();
    }

    @Nullable
    public <MODULE extends ICustomModule<MODULE>> Module<MODULE> load(ItemStack container, IModuleDataProvider<MODULE> typeProvider) {
        if (container.func_77973_b() instanceof IModuleContainerItem) {
            CompoundNBT modulesTag = ItemDataUtils.getCompound(container, "modules");
            return this.load(container, typeProvider.getModuleData(), modulesTag, null);
        }
        return null;
    }

    public List<Module<?>> loadAll(ItemStack container) {
        if (container.func_77973_b() instanceof IModuleContainerItem) {
            ArrayList modules = new ArrayList();
            CompoundNBT modulesTag = ItemDataUtils.getCompound(container, "modules");
            for (ModuleData<?> moduleType : this.loadAllTypes(modulesTag)) {
                Module<?> module = this.load(container, moduleType, modulesTag, null);
                if (module == null) continue;
                modules.add(module);
            }
            return modules;
        }
        return Collections.emptyList();
    }

    public <MODULE extends ICustomModule<?>> List<Module<? extends MODULE>> loadAll(ItemStack container, Class<MODULE> moduleClass) {
        if (container.func_77973_b() instanceof IModuleContainerItem) {
            ArrayList<Module<MODULE>> modules = new ArrayList<Module<MODULE>>();
            CompoundNBT modulesTag = ItemDataUtils.getCompound(container, "modules");
            for (ModuleData<?> moduleType : this.loadAllTypes(modulesTag)) {
                Module<?> module = this.load(container, moduleType, modulesTag, moduleClass);
                if (module == null) continue;
                modules.add(module);
            }
            return modules;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ModuleData<?>> loadAllTypes(ItemStack container) {
        if (container.func_77973_b() instanceof IModuleContainerItem) {
            return this.loadAllTypes(ItemDataUtils.getCompound(container, "modules"));
        }
        return Collections.emptyList();
    }

    private Set<ModuleData<?>> loadAllTypes(CompoundNBT modulesTag) {
        HashSet moduleTypes = new HashSet();
        for (String name : modulesTag.func_150296_c()) {
            ModuleData<?> moduleType = this.getModuleTypeFromName(name);
            if (moduleType == null) continue;
            moduleTypes.add(moduleType);
        }
        return moduleTypes;
    }

    @Nullable
    private ModuleData<?> getModuleTypeFromName(String name) {
        ModuleData<?> legacy = this.legacyModuleLookup.get(name);
        if (legacy != null) {
            return legacy;
        }
        ResourceLocation registryName = ResourceLocation.func_208304_a((String)name);
        return registryName == null ? null : (ModuleData)MekanismAPI.moduleRegistry().getValue(registryName);
    }

    @Nullable
    private <MODULE extends ICustomModule<MODULE>> Module<MODULE> load(ItemStack container, ModuleData<MODULE> type, CompoundNBT modulesTag, @Nullable Class<? extends ICustomModule<?>> typeFilter) {
        String registryName = type.getRegistryName().toString();
        if (modulesTag.func_150297_b(registryName, 10)) {
            return this.load(type, container, modulesTag, registryName, typeFilter);
        }
        String legacyName = type.getLegacyName();
        if (legacyName != null && modulesTag.func_150297_b(legacyName, 10)) {
            return this.load(type, container, modulesTag, legacyName, typeFilter);
        }
        return null;
    }

    @Nullable
    private <MODULE extends ICustomModule<MODULE>> Module<MODULE> load(ModuleData<MODULE> type, ItemStack container, CompoundNBT modulesTag, String key, @Nullable Class<? extends ICustomModule<?>> typeFilter) {
        Module<MODULE> module = new Module<MODULE>(type, container);
        if (typeFilter == null || typeFilter.isInstance(module.getCustomInstance())) {
            module.read(modulesTag.func_74775_l(key));
            return module;
        }
        return null;
    }

    @Override
    public IHUDElement hudElementEnabled(ResourceLocation icon, boolean enabled) {
        return this.hudElement(icon, BooleanStateDisplay.OnOff.caps(enabled, false).getTextComponent(), enabled ? IHUDElement.HUDColor.REGULAR : IHUDElement.HUDColor.FADED);
    }

    @Override
    public IHUDElement hudElementPercent(ResourceLocation icon, double ratio) {
        return this.hudElement(icon, TextUtils.getPercent(ratio), ratio > 0.2 ? IHUDElement.HUDColor.REGULAR : (ratio > 0.1 ? IHUDElement.HUDColor.WARNING : IHUDElement.HUDColor.DANGER));
    }

    @Override
    public IHUDElement hudElement(ResourceLocation icon, ITextComponent text, IHUDElement.HUDColor color) {
        return HUDElement.of(icon, text, HUDElement.HUDColor.from(color));
    }
}

