/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.data.ChemicalRenderData;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;

@ParametersAreNonnullByDefault
public class RenderThermoelectricBoiler
extends MekanismTileEntityRenderer<TileEntityBoilerCasing> {
    public RenderThermoelectricBoiler(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityBoilerCasing tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        BoilerMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (BoilerMultiblockData)tile.getMultiblock()).isFormed() && multiblock.renderLocation != null && multiblock.upperRenderLocation != null) {
            int glow;
            RenderData data;
            int height;
            BlockPos pos = tile.func_174877_v();
            IVertexBuilder buffer = null;
            if (!multiblock.waterTank.isEmpty() && (height = multiblock.upperRenderLocation.func_177956_o() - 1 - multiblock.renderLocation.func_177956_o()) >= 1) {
                data = new FluidRenderData(multiblock.waterTank.getFluid());
                ((FluidRenderData)data).location = multiblock.renderLocation;
                ((FluidRenderData)data).height = height;
                ((FluidRenderData)data).length = multiblock.length();
                ((FluidRenderData)data).width = multiblock.width();
                glow = ((FluidRenderData)data).calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(((FluidRenderData)data).location.func_177958_n() - pos.func_177958_n()), (double)(((FluidRenderData)data).location.func_177956_o() - pos.func_177956_o()), (double)(((FluidRenderData)data).location.func_177952_p() - pos.func_177952_p()));
                buffer = renderer.getBuffer(Atlases.func_228785_j_());
                MekanismRenderer.Model3D model = ModelRenderer.getModel(data, multiblock.prevWaterScale);
                MekanismRenderer.renderObject(model, matrix, buffer, ((FluidRenderData)data).getColorARGB(multiblock.prevWaterScale), glow, overlayLight, this.getFaceDisplay(data, model));
                matrix.func_227865_b_();
                MekanismRenderer.renderValves(matrix, buffer, multiblock.valves, (FluidRenderData)data, pos, glow, overlayLight, this.isInsideMultiblock(data));
            }
            if (!multiblock.steamTank.isEmpty() && (height = multiblock.renderLocation.func_177956_o() + multiblock.height() - 2 - multiblock.upperRenderLocation.func_177956_o()) >= 1) {
                data = new ChemicalRenderData.GasRenderData((GasStack)multiblock.steamTank.getStack());
                ((ChemicalRenderData.GasRenderData)data).location = multiblock.upperRenderLocation;
                ((ChemicalRenderData.GasRenderData)data).height = height;
                ((ChemicalRenderData.GasRenderData)data).length = multiblock.length();
                ((ChemicalRenderData.GasRenderData)data).width = multiblock.width();
                if (buffer == null) {
                    buffer = renderer.getBuffer(Atlases.func_228785_j_());
                }
                glow = data.calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(((ChemicalRenderData.GasRenderData)data).location.func_177958_n() - pos.func_177958_n()), (double)(((ChemicalRenderData.GasRenderData)data).location.func_177956_o() - pos.func_177956_o()), (double)(((ChemicalRenderData.GasRenderData)data).location.func_177952_p() - pos.func_177952_p()));
                MekanismRenderer.Model3D gasModel = ModelRenderer.getModel(data, 1.0);
                MekanismRenderer.renderObject(gasModel, matrix, buffer, ((ChemicalRenderData)data).getColorARGB(multiblock.prevSteamScale), glow, overlayLight, this.getFaceDisplay(data, gasModel));
                matrix.func_227865_b_();
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "thermoelectricBoiler";
    }

    public boolean shouldRenderOffScreen(TileEntityBoilerCasing tile) {
        if (tile.isMaster()) {
            BoilerMultiblockData multiblock = (BoilerMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && multiblock.renderLocation != null && multiblock.upperRenderLocation != null;
        }
        return false;
    }
}

