/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiMergedChemicalTankGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSequencedSlotDisplay;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public class GuiChemicalCrystallizer
extends GuiConfigurableTile<TileEntityChemicalCrystallizer, MekanismTileContainer<TileEntityChemicalCrystallizer>> {
    private final List<ItemStack> iterStacks = new ArrayList<ItemStack>();
    private final IOreInfo oreInfo = new OreInfo();
    private GuiSequencedSlotDisplay slotDisplay;
    @Nonnull
    private Slurry prevSlurry = MekanismAPI.EMPTY_SLURRY;

    public GuiChemicalCrystallizer(MekanismTileContainer<TileEntityChemicalCrystallizer> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.field_238743_q_ = 4;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityChemicalCrystallizer)this.tile).getEnergyContainer(), 157, 23));
        this.func_230480_a_(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityChemicalCrystallizer)this.tile).getEnergyContainer(), ((TileEntityChemicalCrystallizer)this.tile)::getActive));
        this.func_230480_a_(new GuiMergedChemicalTankGauge<TileEntityChemicalCrystallizer>(() -> ((TileEntityChemicalCrystallizer)this.tile).inputTank, () -> (TileEntityChemicalCrystallizer)this.tile, GaugeType.STANDARD, this, 7, 4));
        this.func_230480_a_(new GuiProgress(((TileEntityChemicalCrystallizer)this.tile)::getScaledProgress, ProgressType.LARGE_RIGHT, (IGuiWrapper)this, 53, 61).jeiCategory(this.tile));
        this.slotDisplay = new GuiSequencedSlotDisplay(this, 129, 14, (NonNullSupplier<List<ItemStack>>)((NonNullSupplier)() -> this.iterStacks));
        this.updateSlotContents();
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 31, 13, 115, 42, () -> GuiChemicalCrystallizer.getScreenRenderStrings(this.oreInfo)));
        this.func_230480_a_(new GuiSlot(SlotType.ORE, this, 128, 13).setRenderAboveSlots());
        this.func_230480_a_(this.slotDisplay);
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public void func_231023_e_() {
        this.updateSlotContents();
        super.func_231023_e_();
    }

    private void updateSlotContents() {
        BoxedChemicalStack boxedChemical = this.oreInfo.getInputChemical();
        if (!boxedChemical.isEmpty() && boxedChemical.getChemicalType() == ChemicalType.SLURRY) {
            Slurry inputSlurry = (Slurry)boxedChemical.getChemicalStack().getType();
            if (this.prevSlurry != inputSlurry) {
                ITag<Item> oreTag;
                this.prevSlurry = inputSlurry;
                this.iterStacks.clear();
                if (!this.prevSlurry.isEmptyType() && !this.prevSlurry.isIn(MekanismTags.Slurries.DIRTY) && (oreTag = this.prevSlurry.getOreTag()) != null) {
                    for (Item ore : oreTag.func_230236_b_()) {
                        this.iterStacks.add(new ItemStack((IItemProvider)ore));
                    }
                }
                this.slotDisplay.updateStackList();
            }
        } else if (!this.prevSlurry.isEmptyType()) {
            this.prevSlurry = MekanismAPI.EMPTY_SLURRY;
            this.iterStacks.clear();
            this.slotDisplay.updateStackList();
        }
    }

    public static List<ITextComponent> getScreenRenderStrings(IOreInfo oreInfo) {
        BoxedChemicalStack boxedChemical = oreInfo.getInputChemical();
        if (!boxedChemical.isEmpty()) {
            ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
            ret.add(boxedChemical.getTextComponent());
            if (boxedChemical.getChemicalType() == ChemicalType.SLURRY && !oreInfo.getRenderStack().func_190926_b()) {
                ret.add((ITextComponent)MekanismLang.GENERIC_PARENTHESIS.translate(oreInfo.getRenderStack()));
            } else {
                ChemicalCrystallizerRecipe recipe = oreInfo.getRecipe();
                if (recipe == null) {
                    ret.add((ITextComponent)MekanismLang.NO_RECIPE.translate(new Object[0]));
                } else {
                    ret.add((ITextComponent)MekanismLang.GENERIC_PARENTHESIS.translate(recipe.getOutput(boxedChemical)));
                }
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private class OreInfo
    implements IOreInfo {
        private WeakReference<ChemicalCrystallizerRecipe> cachedRecipe;

        private OreInfo() {
        }

        @Override
        @Nonnull
        public BoxedChemicalStack getInputChemical() {
            MergedChemicalTank.Current current = ((TileEntityChemicalCrystallizer)((GuiChemicalCrystallizer)GuiChemicalCrystallizer.this).tile).inputTank.getCurrent();
            return current == MergedChemicalTank.Current.EMPTY ? BoxedChemicalStack.EMPTY : BoxedChemicalStack.box(((TileEntityChemicalCrystallizer)((GuiChemicalCrystallizer)GuiChemicalCrystallizer.this).tile).inputTank.getTankFromCurrent(current).getStack());
        }

        @Override
        @Nullable
        public ChemicalCrystallizerRecipe getRecipe() {
            ChemicalCrystallizerRecipe recipe;
            BoxedChemicalStack input = this.getInputChemical();
            if (input.isEmpty()) {
                return null;
            }
            if (this.cachedRecipe == null) {
                recipe = this.getRecipeAndCache();
            } else {
                recipe = (ChemicalCrystallizerRecipe)this.cachedRecipe.get();
                if (recipe == null || !recipe.testType(input)) {
                    recipe = this.getRecipeAndCache();
                }
            }
            return recipe;
        }

        @Override
        @Nonnull
        public ItemStack getRenderStack() {
            return GuiChemicalCrystallizer.this.slotDisplay == null ? ItemStack.field_190927_a : GuiChemicalCrystallizer.this.slotDisplay.getRenderStack();
        }

        private ChemicalCrystallizerRecipe getRecipeAndCache() {
            ChemicalCrystallizerRecipe recipe = ((TileEntityChemicalCrystallizer)GuiChemicalCrystallizer.this.tile).getRecipe(0);
            this.cachedRecipe = recipe == null ? null : new WeakReference<ChemicalCrystallizerRecipe>(recipe);
            return recipe;
        }
    }

    public static interface IOreInfo {
        @Nonnull
        public BoxedChemicalStack getInputChemical();

        @Nullable
        public ChemicalCrystallizerRecipe getRecipe();

        @Nonnull
        public ItemStack getRenderStack();
    }
}

