/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.SideDataButton;
import mekanism.client.gui.element.tab.GuiConfigTypeTab;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.to_server.PacketConfigurationUpdate;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiSideConfiguration<TILE extends TileEntityMekanism>
extends GuiWindow {
    private final List<GuiConfigTypeTab> configTabs = new ArrayList<GuiConfigTypeTab>();
    private final Map<RelativeSide, SideDataButton> sideConfigButtons = new EnumMap<RelativeSide, SideDataButton>(RelativeSide.class);
    private final MekanismButton ejectButton;
    private final TILE tile;
    private TransmissionType currentType;

    public GuiSideConfiguration(IGuiWrapper gui, int x, int y, TILE tile) {
        super(gui, x, y, 156, 115, SelectedWindowData.WindowType.SIDE_CONFIG);
        this.tile = tile;
        this.interactionStrategy = GuiWindow.InteractionStrategy.ALL;
        this.currentType = this.getTopTransmission();
        this.addChild(new GuiInnerScreen(gui, this.relativeX + 41, this.relativeY + 25, 74, 12, () -> {
            ConfigInfo config = ((ISideConfiguration)this.tile).getConfig().getConfig(this.currentType);
            if (config == null || !config.canEject()) {
                return Collections.singletonList(MekanismLang.NO_EJECT.translate(new Object[0]));
            }
            return Collections.singletonList(MekanismLang.EJECT.translate(BooleanStateDisplay.OnOff.of(config.isEjecting())));
        }).tooltip(() -> {
            ConfigInfo config = ((ISideConfiguration)this.tile).getConfig().getConfig(this.currentType);
            if (config == null || !config.canEject()) {
                return Collections.singletonList(MekanismLang.CANT_EJECT_TOOLTIP.translate(new Object[0]));
            }
            return Collections.emptyList();
        }));
        List<TransmissionType> transmissions = ((ISideConfiguration)this.tile).getConfig().getTransmissions();
        for (int i = 0; i < transmissions.size(); ++i) {
            GuiConfigTypeTab tab = new GuiConfigTypeTab(gui, transmissions.get(i), this.relativeX + (i < 4 ? -26 : this.field_230688_j_), this.relativeY + (2 + 28 * (i % 4)), this, i < 4);
            this.addChild(tab);
            this.configTabs.add(tab);
        }
        this.ejectButton = this.addChild(new MekanismImageButton(gui, this.relativeX + 136, this.relativeY + 6, 14, this.getButtonLocation("auto_eject"), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(PacketConfigurationUpdate.ConfigurationPacket.EJECT, this.tile.func_174877_v(), this.currentType)), this.getOnHover(MekanismLang.AUTO_EJECT)));
        this.addChild(new MekanismImageButton(gui, this.relativeX + 136, this.relativeY + 95, 14, this.getButtonLocation("clear_sides"), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(PacketConfigurationUpdate.ConfigurationPacket.CLEAR_ALL, this.tile.func_174877_v(), this.currentType)), this.getOnHover(MekanismLang.SIDE_CONFIG_CLEAR)));
        this.addSideDataButton(RelativeSide.BOTTOM, 71, 74);
        this.addSideDataButton(RelativeSide.TOP, 71, 44);
        this.addSideDataButton(RelativeSide.FRONT, 71, 59);
        this.addSideDataButton(RelativeSide.BACK, 56, 74);
        this.addSideDataButton(RelativeSide.LEFT, 56, 59);
        this.addSideDataButton(RelativeSide.RIGHT, 86, 59);
        this.updateTabs();
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_TRACK_SIDE_CONFIG, (TileEntity)tile, 1));
        ((MekanismContainer)((GuiMekanism)this.gui()).func_212873_a_()).startTracking(1, ((ISideConfiguration)this.tile).getConfig());
    }

    private void addSideDataButton(RelativeSide side, int xPos, int yPos) {
        this.sideConfigButtons.put(side, this.addChild(new SideDataButton(this.gui(), this.relativeX + xPos, this.relativeY + yPos, side, () -> ((ISideConfiguration)this.tile).getConfig().getDataType(this.currentType, side), () -> {
            DataType dataType = ((ISideConfiguration)this.tile).getConfig().getDataType(this.currentType, side);
            return dataType == null ? EnumColor.GRAY : dataType.getColor();
        }, (TileEntity)this.tile, () -> this.currentType, PacketConfigurationUpdate.ConfigurationPacket.SIDE_DATA, this.getOnHover(side))));
    }

    @Override
    public void close() {
        super.close();
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_STOP_TRACKING, (TileEntity)this.tile, 1));
        ((MekanismContainer)((GuiMekanism)this.gui()).func_212873_a_()).stopTracking(1);
    }

    private GuiElement.IHoverable getOnHover(RelativeSide side) {
        return (onHover, matrix, xAxis, yAxis) -> {
            DataType dataType;
            if (onHover instanceof SideDataButton && (dataType = ((SideDataButton)onHover).getDataType()) != null) {
                this.displayTooltip(matrix, (ITextComponent)MekanismLang.GENERIC_WITH_TWO_PARENTHESIS.translateColored(dataType.getColor(), dataType, dataType.getColor().getName(), side), xAxis, yAxis);
            }
        };
    }

    private TransmissionType getTopTransmission() {
        return ((ISideConfiguration)this.tile).getConfig().getTransmissions().get(0);
    }

    public void setCurrentType(TransmissionType type) {
        this.currentType = type;
    }

    public void updateTabs() {
        for (GuiConfigTypeTab tab : this.configTabs) {
            tab.field_230694_p_ = this.currentType != tab.getTransmissionType();
        }
        ConfigInfo config = ((ISideConfiguration)this.tile).getConfig().getConfig(this.currentType);
        if (config == null) {
            this.ejectButton.field_230693_o_ = false;
            for (SideDataButton sideDataButton : this.sideConfigButtons.values()) {
                sideDataButton.field_230693_o_ = false;
            }
        } else {
            this.ejectButton.field_230693_o_ = config.canEject();
            for (Map.Entry entry : this.sideConfigButtons.entrySet()) {
                ((SideDataButton)entry.getValue()).field_230693_o_ = config.isSideEnabled((RelativeSide)entry.getKey());
            }
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawTitleText(matrix, (ITextComponent)MekanismLang.CONFIG_TYPE.translate(this.currentType), 5.0f);
        this.drawCenteredText(matrix, (ITextComponent)MekanismLang.SLOTS.translate(new Object[0]), this.relativeX + 80, this.relativeY + 96, this.subheadingTextColor());
    }

    @Override
    protected int getTitlePadEnd() {
        return super.getTitlePadEnd() + 15;
    }
}

