/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.text;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import mekanism.api.functions.CharPredicate;
import mekanism.api.functions.CharUnaryOperator;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.ButtonType;
import mekanism.client.gui.element.text.IconType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.lib.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.StringTextComponent;

public class GuiTextField
extends GuiElement {
    public static final int DEFAULT_BORDER_COLOR = -6250336;
    public static final int DEFAULT_BACKGROUND_COLOR = -16777216;
    public static final IntSupplier SCREEN_COLOR = SpecialColors.TEXT_SCREEN::argb;
    public static final IntSupplier DARK_SCREEN_COLOR = () -> Color.argb(SCREEN_COLOR.getAsInt()).darken(0.4).argb();
    private final TextFieldWidget textField;
    private Runnable enterHandler;
    private CharPredicate inputValidator;
    private CharUnaryOperator inputTransformer;
    private Consumer<String> responder;
    private BackgroundType backgroundType = BackgroundType.DEFAULT;
    private IconType iconType;
    private int textOffsetX;
    private int textOffsetY;
    private float textScale = 1.0f;
    private MekanismImageButton checkmarkButton;

    public GuiTextField(IGuiWrapper gui, int x, int y, int width, int height) {
        super(gui, x, y, width, height);
        this.textField = new TextFieldWidget(this.getFont(), this.field_230690_l_, this.field_230691_m_, width, height, StringTextComponent.field_240750_d_);
        this.textField.func_146185_a(false);
        this.textField.func_212954_a(s -> {
            if (this.responder != null) {
                this.responder.accept((String)s);
            }
            if (this.checkmarkButton != null) {
                this.checkmarkButton.field_230693_o_ = !this.textField.func_146179_b().isEmpty();
            }
        });
        this.gui().addFocusListener(this);
        this.updateTextField();
    }

    @Override
    public void resize(int prevLeft, int prevTop, int left, int top) {
        super.resize(prevLeft, prevTop, left, top);
        this.textField.field_230690_l_ = this.textField.field_230690_l_ - prevLeft + left;
        this.textField.field_230691_m_ = this.textField.field_230691_m_ - prevTop + top;
    }

    public GuiTextField setScale(float textScale) {
        this.textScale = textScale;
        return this;
    }

    public GuiTextField setOffset(int offsetX, int offsetY) {
        this.textOffsetX = offsetX;
        this.textOffsetY = offsetY;
        this.updateTextField();
        return this;
    }

    public GuiTextField configureDigitalInput(Runnable enterHandler) {
        this.setBackground(BackgroundType.NONE);
        this.setIcon(IconType.DIGITAL);
        this.setTextColor(this.screenTextColor());
        this.setEnterHandler(enterHandler);
        this.addCheckmarkButton(ButtonType.DIGITAL, enterHandler);
        this.setScale(0.8f);
        return this;
    }

    public GuiTextField configureDigitalBorderInput(Runnable enterHandler) {
        this.setBackground(BackgroundType.DIGITAL);
        this.setTextColor(this.screenTextColor());
        this.setEnterHandler(enterHandler);
        this.addCheckmarkButton(ButtonType.DIGITAL, enterHandler);
        this.setScale(0.8f);
        return this;
    }

    public GuiTextField setEnterHandler(Runnable enterHandler) {
        this.enterHandler = enterHandler;
        return this;
    }

    public GuiTextField setInputValidator(CharPredicate inputValidator) {
        this.inputValidator = inputValidator;
        return this;
    }

    public GuiTextField setInputTransformer(CharUnaryOperator inputTransformer) {
        this.inputTransformer = inputTransformer;
        return this;
    }

    public GuiTextField setBackground(BackgroundType backgroundType) {
        this.backgroundType = backgroundType;
        return this;
    }

    public GuiTextField setIcon(IconType iconType) {
        this.iconType = iconType;
        this.updateTextField();
        return this;
    }

    public GuiTextField addCheckmarkButton(Runnable callback) {
        return this.addCheckmarkButton(ButtonType.NORMAL, callback);
    }

    public GuiTextField addCheckmarkButton(ButtonType type, Runnable callback) {
        this.checkmarkButton = this.addChild(type.getButton(this, () -> {
            callback.run();
            this.func_230996_d_(true);
        }));
        this.checkmarkButton.field_230693_o_ = false;
        this.updateTextField();
        return this;
    }

    private void updateTextField() {
        int iconOffsetX = this.iconType != null ? this.iconType.getOffsetX() : 0;
        this.textField.func_230991_b_(Math.round((float)(this.field_230688_j_ - (this.checkmarkButton != null ? this.textField.func_238483_d_() + 2 : 0) - iconOffsetX) * (1.0f / this.textScale)));
        this.textField.func_212952_l(this.field_230690_l_ + this.textOffsetX + 2 + iconOffsetX);
        this.textField.field_230691_m_ = this.field_230691_m_ + this.textOffsetY + 1 + (int)((float)this.field_230689_k_ / 2.0f - 4.0f);
    }

    public boolean isTextFieldFocused() {
        return this.textField.func_230999_j_();
    }

    @Override
    public void onWindowClose() {
        super.onWindowClose();
        this.gui().removeFocusListener(this);
    }

    @Override
    public void move(int changeX, int changeY) {
        super.move(changeX, changeY);
        this.updateTextField();
    }

    @Override
    public void tick() {
        super.tick();
        this.textField.func_146178_a();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean prevFocus = this.isTextFieldFocused();
        double scaledX = mouseX;
        if (this.textScale != 1.0f && scaledX > (double)this.textField.field_230690_l_) {
            scaledX = Math.min(scaledX, (double)this.textField.field_230690_l_) + (scaledX - (double)this.textField.field_230690_l_) * (double)(1.0f / this.textScale);
        }
        boolean ret = this.textField.func_231044_a_(scaledX, mouseY, button);
        if (!prevFocus && this.isTextFieldFocused()) {
            this.gui().focusChange(this);
        }
        return ret || super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        this.backgroundType.render(this, matrix);
        if (this.textScale == 1.0f) {
            this.renderTextField(matrix, mouseX, mouseY, partialTicks);
        } else {
            float reverse = 1.0f / this.textScale - 1.0f;
            float yAdd = 4.0f - this.textScale * 8.0f / 2.0f;
            matrix.func_227860_a_();
            matrix.func_227862_a_(this.textScale, this.textScale, this.textScale);
            matrix.func_227861_a_((double)((float)this.textField.field_230690_l_ * reverse), (double)((float)this.textField.field_230691_m_ * reverse + yAdd * (1.0f / this.textScale)), 0.0);
            this.renderTextField(matrix, mouseX, mouseY, partialTicks);
            matrix.func_227865_b_();
        }
        MekanismRenderer.resetColor();
        if (this.iconType != null) {
            GuiTextField.minecraft.field_71446_o.func_110577_a(this.iconType.getIcon());
            GuiTextField.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 2), (int)(this.field_230691_m_ + this.field_230689_k_ / 2 - (int)Math.ceil((float)this.iconType.getHeight() / 2.0f)), (float)0.0f, (float)0.0f, (int)this.iconType.getWidth(), (int)this.iconType.getHeight(), (int)this.iconType.getWidth(), (int)this.iconType.getHeight());
        }
    }

    private void renderTextField(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrix.func_227866_c_().func_227870_a_());
        this.textField.func_230430_a_(new MatrixStack(), mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
    }

    @Override
    public boolean hasPersistentData() {
        return true;
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        this.textField.func_146180_a(((GuiTextField)element).getText());
        this.func_230996_d_(element.func_230999_j_());
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.canWrite()) {
            if (keyCode == 256) {
                return false;
            }
            if (keyCode == 257 || keyCode == 335) {
                if (this.enterHandler != null) {
                    this.enterHandler.run();
                }
                return true;
            }
            if (keyCode == 258) {
                this.gui().incrementFocus(this);
                return true;
            }
            if (Screen.func_231168_h_((int)keyCode)) {
                String text = Minecraft.func_71410_x().field_195559_v.func_197965_a();
                if (this.inputTransformer != null || this.inputValidator != null) {
                    boolean transformed = false;
                    char[] charArray = text.toCharArray();
                    for (int i = 0; i < charArray.length; ++i) {
                        char c = charArray[i];
                        if (this.inputTransformer != null) {
                            charArray[i] = c = this.inputTransformer.applyAsChar(c);
                            transformed = true;
                        }
                        if (this.inputValidator == null || this.inputValidator.test(c)) continue;
                        return false;
                    }
                    if (transformed) {
                        text = String.copyValueOf(charArray);
                    }
                }
                this.textField.func_146191_b(text);
            } else {
                this.textField.func_231046_a_(keyCode, scanCode, modifiers);
            }
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean func_231042_a_(char c, int keyCode) {
        if (this.canWrite()) {
            if (this.inputTransformer != null) {
                c = this.inputTransformer.applyAsChar(c);
            }
            if (this.inputValidator == null || this.inputValidator.test(c)) {
                return this.textField.func_231042_a_(c, keyCode);
            }
            return false;
        }
        return super.func_231042_a_(c, keyCode);
    }

    public String getText() {
        return this.textField.func_146179_b();
    }

    public void setVisible(boolean visible) {
        this.textField.func_146189_e(visible);
    }

    public void setMaxStringLength(int length) {
        this.textField.func_146203_f(length);
    }

    public void setTextColor(int color) {
        this.textField.func_146193_g(color);
    }

    public void setEnabled(boolean enabled) {
        this.textField.func_146184_c(enabled);
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.textField.func_146205_d(canLoseFocus);
    }

    @Override
    public void func_230996_d_(boolean focused) {
        super.func_230996_d_(focused);
        this.textField.func_146195_b(focused);
        if (focused) {
            this.gui().focusChange(this);
        }
    }

    public boolean canWrite() {
        return this.textField.func_212955_f();
    }

    public void setText(String text) {
        this.textField.func_146180_a(text);
    }

    public void setResponder(Consumer<String> responder) {
        this.responder = responder;
    }
}

