/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.scroll.GuiScrollableElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;

public abstract class GuiScrollList
extends GuiScrollableElement {
    protected static final ResourceLocation SCROLL_LIST = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "scroll_list.png");
    protected static final int TEXTURE_WIDTH = 6;
    protected static final int TEXTURE_HEIGHT = 6;
    private final ResourceLocation background;
    private final int backgroundSideSize;
    protected final int elementHeight;

    protected GuiScrollList(IGuiWrapper gui, int x, int y, int width, int height, int elementHeight, ResourceLocation background, int backgroundSideSize) {
        super(SCROLL_LIST, gui, x, y, width, height, width - 6, 2, 4, 4, height - 4);
        this.elementHeight = elementHeight;
        this.background = background;
        this.backgroundSideSize = backgroundSideSize;
    }

    @Override
    protected int getFocusedElements() {
        return (this.field_230689_k_ - 2) / this.elementHeight;
    }

    public abstract boolean hasSelection();

    protected abstract void setSelected(int var1);

    public abstract void clearSelection();

    protected abstract void renderElements(MatrixStack var1, int var2, int var3, float var4);

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        this.renderBackgroundTexture(matrix, this.background, this.backgroundSideSize, this.backgroundSideSize);
        GuiElement.minecraft.field_71446_o.func_110577_a(this.getResource());
        GuiScrollList.func_238463_a_((MatrixStack)matrix, (int)(this.barX - 1), (int)(this.barY - 1), (float)0.0f, (float)0.0f, (int)6, (int)1, (int)6, (int)6);
        GuiScrollList.func_238466_a_((MatrixStack)matrix, (int)(this.barX - 1), (int)this.barY, (int)6, (int)this.maxBarHeight, (float)0.0f, (float)1.0f, (int)6, (int)1, (int)6, (int)6);
        GuiScrollList.func_238463_a_((MatrixStack)matrix, (int)(this.barX - 1), (int)(this.field_230691_m_ + this.maxBarHeight + 2), (float)0.0f, (float)0.0f, (int)6, (int)1, (int)6, (int)6);
        GuiScrollList.func_238463_a_((MatrixStack)matrix, (int)this.barX, (int)(this.barY + this.getScroll()), (float)0.0f, (float)2.0f, (int)this.barWidth, (int)this.barHeight, (int)6, (int)6);
        this.renderElements(matrix, mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_230982_a_(double mouseX, double mouseY) {
        super.func_230982_a_(mouseX, mouseY);
        if (mouseX >= (double)(this.field_230690_l_ + 1) && mouseX < (double)(this.barX - 1) && mouseY >= (double)(this.field_230691_m_ + 1) && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_ - 1)) {
            int index = this.getCurrentSelection();
            this.clearSelection();
            for (int i = 0; i < this.getFocusedElements(); ++i) {
                int shiftedY;
                if (index + i >= this.getMaxElements() || !(mouseY >= (double)(shiftedY = this.field_230691_m_ + 1 + this.elementHeight * i)) || !(mouseY <= (double)(shiftedY + this.elementHeight))) continue;
                this.setSelected(index + i);
                break;
            }
        }
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return this.func_231047_b_(mouseX, mouseY) && this.adjustScroll(delta) || super.func_231043_a_(mouseX, mouseY, delta);
    }
}

