/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs.chemical;

import com.google.gson.JsonElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.providers.IPigmentProvider;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientDeserializer;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientInfo;
import mekanism.api.recipes.inputs.chemical.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;

public interface PigmentStackIngredient
extends IChemicalStackIngredient<Pigment, PigmentStack> {
    public static PigmentStackIngredient from(@Nonnull PigmentStack instance) {
        return PigmentStackIngredient.from((IPigmentProvider)instance.getType(), instance.getAmount());
    }

    public static PigmentStackIngredient from(@Nonnull IPigmentProvider pigment, long amount) {
        return new Single(pigment.getStack(amount));
    }

    public static PigmentStackIngredient from(@Nonnull ITag<Pigment> tag, long amount) {
        return new Tagged(tag, amount);
    }

    public static PigmentStackIngredient read(PacketBuffer buffer) {
        return ChemicalIngredientDeserializer.PIGMENT.read(buffer);
    }

    public static PigmentStackIngredient deserialize(@Nullable JsonElement json) {
        return ChemicalIngredientDeserializer.PIGMENT.deserialize(json);
    }

    public static PigmentStackIngredient createMulti(PigmentStackIngredient ... ingredients) {
        return (PigmentStackIngredient)ChemicalIngredientDeserializer.PIGMENT.createMulti(ingredients);
    }

    @Override
    default public ChemicalIngredientInfo<Pigment, PigmentStack> getIngredientInfo() {
        return ChemicalIngredientInfo.PIGMENT;
    }

    public static class Multi
    extends ChemicalStackIngredient.MultiIngredient<Pigment, PigmentStack, PigmentStackIngredient>
    implements PigmentStackIngredient {
        Multi(PigmentStackIngredient ... ingredients) {
            super((IChemicalStackIngredient[])ingredients);
        }
    }

    public static class Tagged
    extends ChemicalStackIngredient.TaggedIngredient<Pigment, PigmentStack>
    implements PigmentStackIngredient {
        private Tagged(@Nonnull ITag<Pigment> tag, long amount) {
            super(tag, amount);
        }
    }

    public static class Single
    extends ChemicalStackIngredient.SingleIngredient<Pigment, PigmentStack>
    implements PigmentStackIngredient {
        private Single(@Nonnull PigmentStack stack) {
            super(stack);
        }
    }
}

