/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs.chemical;

import com.google.gson.JsonElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientDeserializer;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientInfo;
import mekanism.api.recipes.inputs.chemical.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;

public interface InfusionStackIngredient
extends IChemicalStackIngredient<InfuseType, InfusionStack> {
    public static InfusionStackIngredient from(@Nonnull InfusionStack instance) {
        return InfusionStackIngredient.from((IInfuseTypeProvider)instance.getType(), instance.getAmount());
    }

    public static InfusionStackIngredient from(@Nonnull IInfuseTypeProvider infuseType, long amount) {
        return new Single(infuseType.getStack(amount));
    }

    public static InfusionStackIngredient from(@Nonnull ITag<InfuseType> tag, long amount) {
        return new Tagged(tag, amount);
    }

    public static InfusionStackIngredient read(PacketBuffer buffer) {
        return ChemicalIngredientDeserializer.INFUSION.read(buffer);
    }

    public static InfusionStackIngredient deserialize(@Nullable JsonElement json) {
        return ChemicalIngredientDeserializer.INFUSION.deserialize(json);
    }

    public static InfusionStackIngredient createMulti(InfusionStackIngredient ... ingredients) {
        return (InfusionStackIngredient)ChemicalIngredientDeserializer.INFUSION.createMulti(ingredients);
    }

    @Override
    default public ChemicalIngredientInfo<InfuseType, InfusionStack> getIngredientInfo() {
        return ChemicalIngredientInfo.INFUSION;
    }

    public static class Multi
    extends ChemicalStackIngredient.MultiIngredient<InfuseType, InfusionStack, InfusionStackIngredient>
    implements InfusionStackIngredient {
        Multi(InfusionStackIngredient ... ingredients) {
            super((IChemicalStackIngredient[])ingredients);
        }
    }

    public static class Tagged
    extends ChemicalStackIngredient.TaggedIngredient<InfuseType, InfusionStack>
    implements InfusionStackIngredient {
        private Tagged(@Nonnull ITag<InfuseType> tag, long amount) {
            super(tag, amount);
        }
    }

    public static class Single
    extends ChemicalStackIngredient.SingleIngredient<InfuseType, InfusionStack>
    implements InfusionStackIngredient {
        private Single(@Nonnull InfusionStack stack) {
            super(stack);
        }
    }
}

