/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache.chemical;

import java.util.Objects;
import java.util.function.LongConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemStackConstantChemicalToItemStackCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NonNull STACK> chemicalInputHandler;
    private final ChemicalUsageMultiplier chemicalUsage;
    private final LongConsumer chemicalUsedSoFarChanged;
    private long chemicalUsageMultiplier;
    private long chemicalUsedSoFar;
    private ItemStack recipeItem = ItemStack.field_190927_a;
    @Nullable
    private STACK recipeChemical;

    public ItemStackConstantChemicalToItemStackCachedRecipe(RECIPE recipe, IInputHandler<@NonNull ItemStack> itemInputHandler, ILongInputHandler<@NonNull STACK> chemicalInputHandler, ChemicalUsageMultiplier chemicalUsage, LongConsumer chemicalUsedSoFarChanged, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.chemicalInputHandler = Objects.requireNonNull(chemicalInputHandler, "Chemical input handler cannot be null.");
        this.chemicalUsage = Objects.requireNonNull(chemicalUsage, "Chemical usage cannot be null.");
        this.chemicalUsedSoFarChanged = Objects.requireNonNull(chemicalUsedSoFarChanged, "Chemical used so far changed handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    public void loadSavedUsageSoFar(long chemicalUsedSoFar) {
        if (chemicalUsedSoFar > 0L) {
            this.chemicalUsedSoFar = chemicalUsedSoFar;
        }
    }

    @Override
    protected void setupVariableValues() {
        this.chemicalUsageMultiplier = Math.max(this.chemicalUsage.getToUse(this.chemicalUsedSoFar, this.getOperatingTicks()), 0L);
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        this.recipeItem = this.itemInputHandler.getRecipeInput(((ItemStackChemicalToItemStackRecipe)this.recipe).getItemInput());
        if (this.recipeItem.func_190926_b()) {
            return -1;
        }
        this.recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient<STACK>)((ItemStackChemicalToItemStackRecipe)this.recipe).getChemicalInput());
        if (((ChemicalStack)this.recipeChemical).isEmpty()) {
            return 0;
        }
        if ((currentMax = this.itemInputHandler.operationsCanSupport(this.recipeItem, currentMax)) <= 0) {
            return -1;
        }
        currentMax = this.chemicalInputHandler.operationsCanSupport(this.recipeChemical, currentMax, this.chemicalUsageMultiplier);
        return this.outputHandler.operationsRoomFor(((ItemStackChemicalToItemStackRecipe)this.recipe).getOutput(this.recipeItem, this.recipeChemical), currentMax);
    }

    @Override
    public boolean isInputValid() {
        ChemicalStack chemicalStack = (ChemicalStack)this.chemicalInputHandler.getInput();
        if (!chemicalStack.isEmpty() && ((ItemStackChemicalToItemStackRecipe)this.recipe).test(this.itemInputHandler.getInput(), chemicalStack)) {
            ChemicalStack recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient<STACK>)((ItemStackChemicalToItemStackRecipe)this.recipe).getChemicalInput());
            return !recipeChemical.isEmpty() && chemicalStack.getAmount() >= recipeChemical.getAmount();
        }
        return false;
    }

    @Override
    protected void useResources(int operations) {
        super.useResources(operations);
        if (this.chemicalUsageMultiplier <= 0L) {
            return;
        }
        if (this.recipeChemical == null || ((ChemicalStack)this.recipeChemical).isEmpty()) {
            return;
        }
        long toUse = (long)operations * this.chemicalUsageMultiplier;
        this.chemicalInputHandler.use(this.recipeChemical, toUse);
        this.chemicalUsedSoFar += toUse;
        this.chemicalUsedSoFarChanged.accept(this.chemicalUsedSoFar);
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.chemicalUsedSoFar = 0L;
        this.chemicalUsedSoFarChanged.accept(this.chemicalUsedSoFar);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.recipeItem.func_190926_b() || this.recipeChemical == null || ((ChemicalStack)this.recipeChemical).isEmpty()) {
            return;
        }
        this.itemInputHandler.use(this.recipeItem, operations);
        if (this.chemicalUsageMultiplier > 0L) {
            this.chemicalInputHandler.use(this.recipeChemical, (long)operations * this.chemicalUsageMultiplier);
        }
        this.outputHandler.handleOutput(((ItemStackChemicalToItemStackRecipe)this.recipe).getOutput(this.recipeItem, this.recipeChemical), operations);
    }

    @FunctionalInterface
    public static interface ChemicalUsageMultiplier {
        public long getToUse(long var1, int var3);
    }
}

