/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache.chemical;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import org.apache.commons.lang3.tuple.Pair;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ChemicalChemicalToChemicalCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NonNull STACK> outputHandler;
    private final IInputHandler<@NonNull STACK> leftInputHandler;
    private final IInputHandler<@NonNull STACK> rightInputHandler;
    @Nullable
    private STACK leftRecipeInput;
    @Nullable
    private STACK rightRecipeInput;

    public ChemicalChemicalToChemicalCachedRecipe(RECIPE recipe, IInputHandler<@NonNull STACK> leftInputHandler, IInputHandler<@NonNull STACK> rightInputHandler, IOutputHandler<@NonNull STACK> outputHandler) {
        super(recipe);
        this.leftInputHandler = Objects.requireNonNull(leftInputHandler, "Left input handler cannot be null.");
        this.rightInputHandler = Objects.requireNonNull(rightInputHandler, "Right input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Nullable
    protected Pair<INGREDIENT, INGREDIENT> getIngredients() {
        ChemicalStack leftInputChemical = (ChemicalStack)this.leftInputHandler.getInput();
        if (leftInputChemical.isEmpty()) {
            return null;
        }
        ChemicalStack rightInputChemical = (ChemicalStack)this.rightInputHandler.getInput();
        if (rightInputChemical.isEmpty()) {
            return null;
        }
        Object leftInput = ((ChemicalChemicalToChemicalRecipe)this.recipe).getLeftInput();
        Object rightInput = ((ChemicalChemicalToChemicalRecipe)this.recipe).getRightInput();
        if (!leftInput.test((ChemicalStack)leftInputChemical) || !rightInput.test((ChemicalStack)rightInputChemical)) {
            return Pair.of(rightInput, leftInput);
        }
        return Pair.of(leftInput, rightInput);
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        Pair<INGREDIENT, INGREDIENT> ingredients = this.getIngredients();
        if (ingredients == null) {
            return -1;
        }
        this.leftRecipeInput = (ChemicalStack)this.leftInputHandler.getRecipeInput((InputIngredient)ingredients.getLeft());
        if (((ChemicalStack)this.leftRecipeInput).isEmpty()) {
            return -1;
        }
        this.rightRecipeInput = (ChemicalStack)this.rightInputHandler.getRecipeInput((InputIngredient)ingredients.getRight());
        if (((ChemicalStack)this.rightRecipeInput).isEmpty()) {
            return -1;
        }
        currentMax = this.leftInputHandler.operationsCanSupport(this.leftRecipeInput, currentMax);
        if ((currentMax = this.rightInputHandler.operationsCanSupport(this.rightRecipeInput, currentMax)) <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ChemicalChemicalToChemicalRecipe)this.recipe).getOutput(this.leftRecipeInput, this.rightRecipeInput), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ChemicalChemicalToChemicalRecipe)this.recipe).test((ChemicalStack)this.leftInputHandler.getInput(), (ChemicalStack)this.rightInputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.leftRecipeInput == null || this.rightRecipeInput == null || ((ChemicalStack)this.leftRecipeInput).isEmpty() || ((ChemicalStack)this.rightRecipeInput).isEmpty()) {
            return;
        }
        this.leftInputHandler.use(this.leftRecipeInput, operations);
        this.rightInputHandler.use(this.rightRecipeInput, operations);
        this.outputHandler.handleOutput(((ChemicalChemicalToChemicalRecipe)this.recipe).getOutput(this.leftRecipeInput, this.rightRecipeInput), operations);
    }
}

