/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.watut.ParticleRegistry;
import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.config.ConfigClient;
import com.corosus.watut.math.Lerpables;
import com.corosus.watut.particle.ParticleAnimated;
import com.corosus.watut.particle.ParticleRotating;
import com.corosus.watut.particle.ParticleStatic;
import com.corosus.watut.particle.ParticleStaticLoD;
import com.ibm.icu.impl.Pair;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.overlay.PlayerTabOverlayGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.inventory.CraftingScreen;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class PlayerStatusManagerClient
extends PlayerStatusManager {
    private PlayerStatus selfPlayerStatus = new PlayerStatus(PlayerStatus.PlayerGuiState.NONE);
    private PlayerStatus selfPlayerStatusPrev = new PlayerStatus(PlayerStatus.PlayerGuiState.NONE);
    public HashMap<UUID, PlayerStatus> lookupPlayerToStatusPrev = new HashMap();
    private long typingIdleTimeout = 60L;
    private int armMouseTickRate = 5;
    private int typeRatePollCounter = 0;
    private int steadyTickCounter = 0;
    private int forcedSyncRate = 40;
    private World lastLevel;
    private boolean wasMousePressed = false;
    private int mousePressedCountdown = 0;
    ResourceLocation IDLE_TEXTURE = new ResourceLocation("watut", "textures/particles/idle.png");

    public void tickGame() {
        ++this.steadyTickCounter;
        if (this.steadyTickCounter == Integer.MAX_VALUE) {
            this.steadyTickCounter = 0;
        }
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (Minecraft.func_71410_x().func_147114_u() != null) {
            Iterator it = this.lookupPlayerToStatus.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                NetworkPlayerInfo playerInfo = Minecraft.func_71410_x().func_147114_u().func_175102_a((UUID)entry.getKey());
                PlayerStatus playerStatus = (PlayerStatus)entry.getValue();
                if (playerInfo == null) {
                    WatutMod.dbg("remove playerstatus for no longer existing player: " + entry.getKey());
                    playerStatus.reset();
                    it.remove();
                }
                if (level.func_217371_b((UUID)entry.getKey()) != null || playerStatus.getParticle() == null && playerStatus.getParticleIdle() == null) continue;
                WatutMod.dbg("remove player particles for player outside dimension: " + entry.getKey());
                playerStatus.resetParticles();
            }
        }
        if (this.lastLevel != level) {
            WatutMod.dbg("resetting player status");
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("reset player particles for " + entry.getKey() + " hash: " + entry.getValue());
                ((PlayerStatus)entry.getValue()).resetParticles();
            }
            this.selfPlayerStatus.reset();
            this.selfPlayerStatusPrev.reset();
        }
        this.lastLevel = level;
    }

    @Override
    public void tickPlayerClient(PlayerEntity player) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g.func_110124_au().equals(player.func_110124_au())) {
            this.tickLocalPlayerClient(player);
        }
        this.tickOtherPlayerClient(player);
        this.getStatus(player.func_110124_au()).tick();
        PlayerStatus status = this.getStatus(player);
        float adjRateTyping = 0.1f;
        if (status.getTypingAmplifierSmooth() < status.getTypingAmplifier() - adjRateTyping) {
            status.setTypingAmplifierSmooth(status.getTypingAmplifierSmooth() + adjRateTyping);
        } else if (status.getTypingAmplifierSmooth() > status.getTypingAmplifier() + adjRateTyping) {
            status.setTypingAmplifierSmooth(status.getTypingAmplifierSmooth() - adjRateTyping);
        }
    }

    public void tickLocalPlayerClient(PlayerEntity player) {
        PlayerStatus.PlayerGuiState playerGuiState;
        Minecraft mc = Minecraft.func_71410_x();
        PlayerStatus statusLocal = this.getStatusLocal();
        PlayerStatus statusPrevLocal = this.getStatusPrevLocal();
        if (ConfigClient.sendActiveGui && !statusLocal.isIdle()) {
            if (mc.field_71462_r instanceof ChatScreen) {
                ChatScreen chat = (ChatScreen)mc.field_71462_r;
                if (this.checkIfTyping(chat.field_146415_a.func_146179_b(), player)) {
                    this.sendStatus(PlayerStatus.PlayerGuiState.CHAT_TYPING);
                } else {
                    if (this.singleplayerTesting) {
                        // empty if block
                    }
                    this.sendStatus(PlayerStatus.PlayerGuiState.CHAT_OPEN);
                }
            } else if (mc.field_71462_r instanceof DisplayEffectsScreen) {
                this.sendStatus(PlayerStatus.PlayerGuiState.INVENTORY);
            } else if (mc.field_71462_r instanceof CraftingScreen) {
                this.sendStatus(PlayerStatus.PlayerGuiState.CRAFTING);
            } else if (mc.field_71462_r instanceof IngameMenuScreen) {
                this.sendStatus(PlayerStatus.PlayerGuiState.ESCAPE);
            } else if (mc.field_71462_r != null) {
                this.sendStatus(PlayerStatus.PlayerGuiState.MISC);
            } else if (mc.field_71462_r == null) {
                this.sendStatus(PlayerStatus.PlayerGuiState.NONE);
            }
        } else {
            this.sendStatus(PlayerStatus.PlayerGuiState.NONE);
        }
        if (ConfigClient.sendMouseInfo && mc.field_71462_r != null && mc.field_71441_e.func_82737_E() % (long)this.armMouseTickRate == 0L && ((playerGuiState = statusLocal.getPlayerGuiState()) == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiState == PlayerStatus.PlayerGuiState.CRAFTING || playerGuiState == PlayerStatus.PlayerGuiState.MISC || playerGuiState == PlayerStatus.PlayerGuiState.ESCAPE)) {
            Pair<Float, Float> pos = this.getMousePos();
            if (((Float)pos.first).floatValue() != statusLocal.getScreenPosPercentX() || ((Float)pos.second).floatValue() != statusLocal.getScreenPosPercentY()) {
                this.onAction();
            }
            this.sendMouse(this.getMousePos(), statusLocal.isPressing());
        }
        if (statusPrevLocal.getTicksSinceLastAction() != statusLocal.getTicksSinceLastAction()) {
            statusPrevLocal.setTicksSinceLastAction(statusLocal.getTicksSinceLastAction());
        }
        if (ConfigClient.sendIdleState) {
            statusLocal.setTicksSinceLastAction(statusLocal.getTicksSinceLastAction() + 1);
            if (statusLocal.getTicksSinceLastAction() > statusLocal.getTicksToMarkPlayerIdleSyncedForClient() && statusLocal.isIdle() != statusPrevLocal.isIdle()) {
                WatutMod.dbg("send idle getTicksSinceLastAction: " + statusLocal.getTicksSinceLastAction() + " - " + statusPrevLocal.getTicksSinceLastAction());
                this.sendIdle(statusLocal);
            }
        } else {
            statusLocal.setTicksSinceLastAction(0);
        }
        if (!this.wasMousePressed && this.mousePressedCountdown > 0) {
            --this.mousePressedCountdown;
            if (this.mousePressedCountdown == 0) {
                this.sendMouse(this.getMousePos(), false);
            }
        }
        this.tickSyncing(player);
    }

    public void tickSyncing(PlayerEntity player) {
        if (this.steadyTickCounter % this.forcedSyncRate == 0) {
            PlayerStatus playerStatusLocal = this.getStatusLocal();
            this.sendIdle(playerStatusLocal);
            this.sendStatus(playerStatusLocal.getPlayerGuiState(), true);
            this.sendTyping(playerStatusLocal);
        }
    }

    public void onMouse(boolean pressedAnything) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null && mc.field_71439_g.field_70170_p != null) {
            PlayerStatus.PlayerGuiState playerGuiState = this.getStatus((PlayerEntity)mc.field_71439_g).getPlayerGuiState();
            if (ConfigClient.sendMouseInfo && (playerGuiState == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiState == PlayerStatus.PlayerGuiState.CRAFTING || playerGuiState == PlayerStatus.PlayerGuiState.MISC)) {
                if (pressedAnything) {
                    this.mousePressedCountdown = 3;
                    this.wasMousePressed = true;
                } else {
                    this.wasMousePressed = false;
                }
                this.sendMouse(this.getMousePos(), this.mousePressedCountdown > 0);
            }
            if (mc.field_71462_r == null || pressedAnything && (playerGuiState == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiState == PlayerStatus.PlayerGuiState.CRAFTING)) {
                this.onAction();
            }
        }
    }

    public void onKey() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null && mc.field_71439_g.field_70170_p != null && (mc.field_71462_r == null || mc.field_71462_r instanceof ChatScreen)) {
            this.onAction();
        }
    }

    public void onAction() {
        if (!ConfigClient.sendIdleState) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null && mc.field_71439_g.field_70170_p != null) {
            PlayerStatus statusLocal = this.getStatusLocal();
            if (statusLocal.isIdle()) {
                statusLocal.setTicksSinceLastAction(0);
                WatutMod.dbg("send idle: 0");
                this.sendIdle(statusLocal);
            } else {
                statusLocal.setTicksSinceLastAction(0);
            }
        }
    }

    public Pair<Float, Float> getMousePos() {
        Minecraft mc = Minecraft.func_71410_x();
        double xPercent = mc.field_71417_B.func_198024_e() / (double)mc.func_228018_at_().func_198105_m() - 0.5;
        double yPercent = mc.field_71417_B.func_198026_f() / (double)mc.func_228018_at_().func_198083_n() - 0.5;
        double emphasis = 1.5;
        double edgeLimit = 0.5;
        double edgeLimitYLower = 0.2;
        xPercent *= emphasis;
        yPercent *= emphasis;
        xPercent = Math.max(Math.min(xPercent, edgeLimit), -edgeLimit);
        yPercent = Math.min(yPercent, edgeLimitYLower);
        return Pair.of((Object)Float.valueOf((float)xPercent), (Object)Float.valueOf((float)yPercent));
    }

    public boolean checkIfTyping(String input, PlayerEntity player) {
        PlayerStatus statusLocal = this.getStatusLocal();
        ++this.typeRatePollCounter;
        if (input.length() > 0) {
            if (!input.startsWith("/")) {
                if (!input.equals(statusLocal.getLastTypeString())) {
                    statusLocal.setLastTypeString(input);
                    statusLocal.setLastTypeTime(player.field_70170_p.func_82737_E());
                }
                if (this.typeRatePollCounter >= 10) {
                    this.typeRatePollCounter = 0;
                    int lengthPrev = statusLocal.getLastTypeStringForAmp().length();
                    if (!input.equals(statusLocal.getLastTypeStringForAmp())) {
                        statusLocal.setLastTypeStringForAmp(input);
                        statusLocal.setLastTypeTimeForAmp(player.field_70170_p.func_82737_E());
                        int length = input.length();
                        int newDiff = length - lengthPrev;
                        float amp = Math.max(0.0f, Math.min(8.0f, (float)newDiff / 6.0f * 2.0f));
                        if (ConfigClient.sendTypingSpeed) {
                            statusLocal.setTypingAmplifier(amp);
                        } else {
                            statusLocal.setTypingAmplifier(1.0f);
                        }
                        this.sendTyping(statusLocal);
                    } else if (ConfigClient.sendTypingSpeed) {
                        statusLocal.setTypingAmplifier(0.0f);
                    }
                }
            }
        } else {
            statusLocal.setLastTypeString(input);
            statusLocal.setLastTypeDiff(0);
            return false;
        }
        return statusLocal.getLastTypeTime() + this.typingIdleTimeout >= player.field_70170_p.func_82737_E();
    }

    public void onGuiRender() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof ChatScreen && mc.func_147114_u() != null) {
            ChatScreen chat = (ChatScreen)mc.field_71462_r;
            int height = chat.field_230709_l_ + 26;
            AbstractGui.func_238476_c_((MatrixStack)new MatrixStack(), (FontRenderer)mc.field_71466_p, (String)WatutMod.getPlayerStatusManagerClient().getTypingPlayers(), (int)2, (int)(height - 50), (int)0xFFFFFF);
        }
    }

    public String getTypingPlayers() {
        Minecraft mc = Minecraft.func_71410_x();
        String str = "";
        for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
            GameProfile profile;
            NetworkPlayerInfo info;
            if (((PlayerStatus)entry.getValue()).getPlayerGuiState() != PlayerStatus.PlayerGuiState.CHAT_TYPING || (info = mc.func_147114_u().func_175102_a((UUID)entry.getKey())) == null || (profile = info.func_178845_a()) == null) continue;
            str = str + profile.getName() + ", ";
        }
        int playersLengthStr = str.length();
        String anim = "";
        int animRate = 6;
        for (long time = mc.field_71441_e.func_82737_E() % (long)(animRate * 4); time > (long)animRate; time -= (long)animRate) {
            anim = anim + ".";
        }
        if (playersLengthStr > 50) {
            str = "Several people are typing" + anim;
        } else if (str.length() > 2) {
            str = str.substring(0, str.length() - 2) + " is typing" + anim;
        }
        return str;
    }

    public boolean shouldAnimate(PlayerEntity player) {
        Minecraft mc = Minecraft.func_71410_x();
        return player != mc.field_71439_g || !mc.field_71474_y.func_243230_g().func_243192_a();
    }

    public void tickOtherPlayerClient(PlayerEntity player) {
        Vector3d posParticle;
        ParticleRotating particle;
        boolean statusParticleChangeOrGone;
        PlayerStatus playerStatus = this.getStatus(player);
        PlayerStatus playerStatusPrev = this.getStatusPrev(player);
        long stableTime = this.steadyTickCounter;
        float sin = (float)Math.sin((float)stableTime / 30.0f % 360.0f);
        float cos = (float)Math.cos((float)stableTime / 30.0f % 360.0f);
        float idleY = (float)(2.6 + (double)(cos * 0.03f));
        boolean idleParticleChangeOrGone = playerStatus.isIdle() != playerStatusPrev.isIdle() || playerStatus.getParticleIdle() == null;
        boolean bl = statusParticleChangeOrGone = playerStatus.getPlayerGuiState() != playerStatusPrev.getPlayerGuiState() || playerStatus.getParticle() == null;
        if ((idleParticleChangeOrGone || !playerStatus.isIdle()) && playerStatus.getParticleIdle() != null) {
            playerStatus.getParticleIdle().func_187112_i();
            playerStatus.setParticleIdle(null);
        }
        if ((statusParticleChangeOrGone || playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) && playerStatus.getParticle() != null) {
            playerStatus.getParticle().func_187112_i();
            playerStatus.setParticle(null);
        }
        if (playerStatus.getParticle() != null && !playerStatus.getParticle().func_187113_k()) {
            playerStatus.getParticle().func_187112_i();
            playerStatus.setParticle(null);
        }
        if (playerStatus.getParticleIdle() != null && !playerStatus.getParticleIdle().func_187113_k()) {
            playerStatus.getParticleIdle().func_187112_i();
            playerStatus.setParticleIdle(null);
        }
        double quadSize = (double)0.3f + Math.sin((float)stableTime / 10.0f % 360.0f) * (double)0.01f;
        if (this.shouldAnimate(player)) {
            if (idleParticleChangeOrGone && ConfigClient.showIdleStatesInPlayerAboveHead && playerStatus.isIdle() && (particle = new ParticleStatic((ClientWorld)player.field_70170_p, player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b + (double)idleY, player.func_213303_ch().field_72449_c, ParticleRegistry.idle.getSprite())) != null) {
                playerStatus.setParticleIdle((Particle)particle);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                particle.setQuadSize((float)quadSize);
                WatutMod.dbg("spawning idle particle for " + player.func_110124_au());
            }
            if (statusParticleChangeOrGone) {
                particle = null;
                posParticle = this.getParticlePosition(player);
                if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHAT_OPEN) {
                    particle = new ParticleAnimated((ClientWorld)player.field_70170_p, posParticle.field_72450_a, posParticle.field_72448_b, posParticle.field_72449_c, ParticleRegistry.chat_idle.getSpriteSet());
                } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHAT_TYPING) {
                    particle = new ParticleAnimated((ClientWorld)player.field_70170_p, posParticle.field_72450_a, posParticle.field_72448_b, posParticle.field_72449_c, ParticleRegistry.chat_typing.getSpriteSet());
                } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.INVENTORY) {
                    particle = new ParticleStaticLoD((ClientWorld)player.field_70170_p, posParticle.field_72450_a, posParticle.field_72448_b, posParticle.field_72449_c, ParticleRegistry.inventory.getSpriteSet());
                } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.CRAFTING) {
                    particle = new ParticleStaticLoD((ClientWorld)player.field_70170_p, posParticle.field_72450_a, posParticle.field_72448_b, posParticle.field_72449_c, ParticleRegistry.crafting.getSpriteSet());
                } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.ESCAPE) {
                    particle = new ParticleStaticLoD((ClientWorld)player.field_70170_p, posParticle.field_72450_a, posParticle.field_72448_b, posParticle.field_72449_c, ParticleRegistry.escape.getSpriteSet());
                } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.MISC) {
                    particle = new ParticleStaticLoD((ClientWorld)player.field_70170_p, posParticle.field_72450_a, posParticle.field_72448_b, posParticle.field_72449_c, ParticleRegistry.chest.getSpriteSet());
                }
                if (particle != null) {
                    playerStatus.setParticle((Particle)particle);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                }
            }
        }
        if (playerStatus.getParticleIdle() != null && (particle = (ParticleStatic)playerStatus.getParticleIdle()).func_187113_k()) {
            particle.keepAlive();
            particle.func_187109_b(player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b + (double)idleY, player.func_213303_ch().field_72449_c);
            particle.setPosPrev(player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b + (double)idleY, player.func_213303_ch().field_72449_c);
            ((ParticleStatic)particle).field_187129_i = 0.0;
            ((ParticleStatic)particle).field_187130_j = 0.0;
            ((ParticleStatic)particle).field_187131_k = 0.0;
            ((ParticleStatic)particle).prevRotationYaw = ((ParticleStatic)particle).rotationYaw = -player.field_70761_aq + 180.0f;
            ((ParticleStatic)particle).prevRotationRoll = ((ParticleStatic)particle).rotationRoll = cos * 5.0f;
            particle.setQuadSize(0.15f + sin * 0.03f);
            particle.func_82338_g(0.5f);
        }
        if (playerStatus.getParticle() != null && playerStatus.getParticle() instanceof ParticleRotating && (particle = (ParticleRotating)playerStatus.getParticle()).func_187113_k()) {
            particle.keepAlive();
            posParticle = this.getParticlePosition(player);
            particle.func_187109_b(posParticle.field_72450_a, posParticle.field_72448_b, posParticle.field_72449_c);
            particle.field_187129_i = 0.0;
            particle.field_187130_j = 0.0;
            particle.field_187131_k = 0.0;
            if (particle instanceof ParticleStaticLoD) {
                particle.setQuadSize((float)quadSize);
                if (Minecraft.func_71410_x().field_175622_Z != null) {
                    double distToCamera = Minecraft.func_71410_x().field_175622_Z.func_70032_d((Entity)player);
                    double distToCameraCapped = Math.max(3.0, Math.min(10.0, distToCamera));
                    float alpha = (float)Math.max((double)0.35f, 1.0 - distToCameraCapped / 10.0);
                    particle.func_82338_g(alpha);
                    ((ParticleStaticLoD)particle).setParticleFromDistanceToCamera((float)distToCamera);
                } else {
                    particle.func_82338_g(0.5f);
                }
            }
            particle.prevRotationYaw = particle.rotationYaw = -player.field_70761_aq;
            particle.prevRotationPitch = particle.rotationPitch = 20.0f;
        }
        playerStatusPrev.setPlayerGuiState(playerStatus.getPlayerGuiState());
        if (playerStatusPrev.getTicksSinceLastAction() != playerStatus.getTicksSinceLastAction()) {
            playerStatusPrev.setTicksSinceLastAction(playerStatus.getTicksSinceLastAction());
        }
    }

    public boolean renderPingIconHook(PlayerTabOverlayGui playerTabOverlay, MatrixStack poseStack, int p_281809_, int p_282801_, int pY, NetworkPlayerInfo pPlayerInfo) {
        if (Minecraft.func_71410_x().field_71452_i == null || pPlayerInfo == null || pPlayerInfo.func_178845_a() == null || !ConfigClient.showIdleStatesInPlayerList) {
            return false;
        }
        PlayerStatus playerStatus = this.getStatus(pPlayerInfo.func_178845_a().getId());
        if (playerStatus.isIdle()) {
            poseStack.func_227860_a_();
            poseStack.func_227861_a_(0.0, 0.0, 101.0);
            TextureAtlasSprite sprite = ParticleRegistry.idle.getSprite();
            boolean x = false;
            boolean y = false;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.IDLE_TEXTURE);
            AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)(p_282801_ + p_281809_ - 11), (int)pY, (float)((float)x), (float)((float)y), (int)10, (int)8, (int)sprite.func_94211_a(), (int)sprite.func_94216_b());
            poseStack.func_227865_b_();
            return true;
        }
        return false;
    }

    public void setupRotationsHook(EntityModel model, Entity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!ConfigClient.showPlayerAnimations) {
            return;
        }
        if (model instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)model;
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean inOwnInventory = pEntity == mc.field_71439_g && mc.field_71462_r instanceof DisplayEffectsScreen && pEntity.func_70089_S();
        boolean isRealPlayer = pEntity.field_70170_p.func_217369_A().contains(pEntity);
        if (model instanceof PlayerModel && pEntity instanceof PlayerEntity && isRealPlayer && (!inOwnInventory && this.shouldAnimate((PlayerEntity)pEntity) || this.singleplayerTesting)) {
            boolean contextIsInventoryPaperDoll;
            PlayerModel playerModel = (PlayerModel)model;
            PlayerEntity player = (PlayerEntity)pEntity;
            PlayerStatus playerStatus = this.getStatus(player);
            boolean bl = contextIsInventoryPaperDoll = (double)playerModel.field_78116_c.field_78796_g > Math.PI;
            if (!contextIsInventoryPaperDoll) {
                if (playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) {
                    playerStatus.yRotHeadBeforeOverriding = playerModel.field_78116_c.field_78796_g;
                    playerStatus.xRotHeadBeforeOverriding = playerModel.field_78116_c.field_78795_f;
                    if (player.field_70170_p.func_82737_E() % 5L == 0L) {
                        // empty if block
                    }
                } else if ((double)playerModel.field_78116_c.field_78796_g <= Math.PI) {
                    playerStatus.yRotHeadWhileOverriding = playerModel.field_78116_c.field_78796_g;
                    playerStatus.xRotHeadWhileOverriding = playerModel.field_78116_c.field_78795_f;
                }
            }
            if (playerStatus.isLerping() || playerStatus.getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE || playerStatus.isIdle()) {
                float partialTick;
                playerStatus.lastPartialTick = partialTick = pAgeInTicks - (float)((int)pAgeInTicks);
                playerModel.field_178723_h.field_78796_g += MathHelper.func_219799_g((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.yRot, (float)playerStatus.getLerpTarget().rightArm.yRot);
                playerModel.field_178723_h.field_78795_f += MathHelper.func_219799_g((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.xRot, (float)playerStatus.getLerpTarget().rightArm.xRot);
                playerModel.field_178723_h.field_78800_c += MathHelper.func_219799_g((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.x, (float)playerStatus.getLerpTarget().rightArm.x);
                playerModel.field_178723_h.field_78797_d += MathHelper.func_219799_g((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.y, (float)playerStatus.getLerpTarget().rightArm.y);
                playerModel.field_178723_h.field_78798_e += MathHelper.func_219799_g((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.z, (float)playerStatus.getLerpTarget().rightArm.z);
                playerModel.field_178724_i.field_78796_g += MathHelper.func_219799_g((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().leftArm.yRot, (float)playerStatus.getLerpTarget().leftArm.yRot);
                playerModel.field_178724_i.field_78795_f += MathHelper.func_219799_g((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().leftArm.xRot, (float)playerStatus.getLerpTarget().leftArm.xRot);
                float yRotDiff = playerStatus.getLerpTarget().head.yRot - playerStatus.getLerpPrev().head.yRot;
                if ((double)Math.abs(yRotDiff) < 1.5707963267948966) {
                    playerModel.field_78116_c.field_78796_g = MathHelper.func_219799_g((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.yRot, (float)playerStatus.getLerpTarget().head.yRot);
                    if (player.field_70170_p.func_82737_E() % 5L == 0L) {
                        // empty if block
                    }
                }
                playerModel.field_78116_c.field_78795_f = MathHelper.func_219799_g((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.xRot, (float)playerStatus.getLerpTarget().head.xRot);
                playerModel.field_78116_c.field_78808_h = MathHelper.func_219799_g((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.zRot, (float)playerStatus.getLerpTarget().head.zRot);
                playerModel.field_178732_b.field_78796_g = playerModel.field_178723_h.field_78796_g;
                playerModel.field_178732_b.field_78795_f = playerModel.field_178723_h.field_78795_f;
                playerModel.field_178732_b.field_78800_c = playerModel.field_178723_h.field_78800_c;
                playerModel.field_178732_b.field_78797_d = playerModel.field_178723_h.field_78797_d;
                playerModel.field_178732_b.field_78798_e = playerModel.field_178723_h.field_78798_e;
                playerModel.field_178734_a.field_78796_g = playerModel.field_178724_i.field_78796_g;
                playerModel.field_178734_a.field_78795_f = playerModel.field_178724_i.field_78795_f;
                if (playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHAT_TYPING) {
                    float amp = playerStatus.getTypingAmplifierSmooth();
                    float typeAngle = (float)Math.toRadians(Math.sin(pAgeInTicks * 1.0f % 360.0f) * 15.0 * (double)amp);
                    float typeAngle2 = (float)Math.toRadians(-Math.sin(pAgeInTicks * 1.0f % 360.0f) * 15.0 * (double)amp);
                    playerModel.field_178723_h.field_78795_f -= typeAngle;
                    playerModel.field_178732_b.field_78795_f -= typeAngle;
                    playerModel.field_178724_i.field_78795_f -= typeAngle2;
                    playerModel.field_178734_a.field_78795_f -= typeAngle2;
                }
                if (playerStatus.isIdle()) {
                    float angle = (float)Math.toRadians(Math.sin(pAgeInTicks * 0.05f % 360.0f) * 15.0);
                    float angle2 = (float)Math.toRadians(Math.cos(pAgeInTicks * 0.05f % 360.0f) * 7.0);
                    playerModel.field_78116_c.field_78795_f += angle2;
                    playerModel.field_78116_c.field_78808_h += angle;
                }
                playerModel.field_178720_f.field_78795_f = playerModel.field_78116_c.field_78795_f;
                playerModel.field_178720_f.field_78796_g = playerModel.field_78116_c.field_78796_g;
                playerModel.field_178720_f.field_78808_h = playerModel.field_78116_c.field_78808_h;
            }
        }
    }

    public void setPoseTarget(UUID uuid, boolean becauseMousePress) {
        boolean typing;
        PlayerStatus playerStatus = this.getStatus(uuid);
        playerStatus.getLerpPrev().rightArm = playerStatus.getLerpTarget().rightArm.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().rightArm, playerStatus.lastPartialTick);
        playerStatus.getLerpPrev().leftArm = playerStatus.getLerpTarget().leftArm.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().leftArm, playerStatus.lastPartialTick);
        playerStatus.getLerpPrev().head = playerStatus.getLerpTarget().head.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().head, playerStatus.lastPartialTick);
        if (Float.isNaN(playerStatus.getLerpPrev().rightArm.yRot)) {
            playerStatus.getLerpPrev().rightArm.yRot = 0.0f;
        }
        if (Float.isNaN(playerStatus.getLerpPrev().rightArm.xRot)) {
            playerStatus.getLerpPrev().rightArm.xRot = 0.0f;
        }
        boolean pointing = playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.INVENTORY || playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.CRAFTING || playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.MISC || playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.ESCAPE;
        boolean bl = typing = playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHAT_TYPING;
        if (becauseMousePress) {
            playerStatus.setNewLerp((float)this.armMouseTickRate * 0.5f);
        } else {
            playerStatus.setNewLerp((float)this.armMouseTickRate * 1.0f);
        }
        if (pointing || typing) {
            playerStatus.getLerpTarget().head.xRot = (float)Math.toRadians(15.0);
            playerStatus.getLerpTarget().head.yRot = 0.0f;
        }
        if (pointing) {
            double xPercent = playerStatus.getScreenPosPercentX();
            double yPercent = playerStatus.getScreenPosPercentY();
            double x = Math.toRadians(90.0) - Math.toRadians(22.5) - yPercent;
            double y = -Math.toRadians(15.0) + xPercent;
            playerStatus.getLerpTarget().rightArm.yRot = (float)y;
            playerStatus.getLerpTarget().rightArm.xRot = (float)(-x);
            if (playerStatus.isPressing()) {
                Vector3d vec = this.calculateViewVector((float)Math.toDegrees(y), (float)Math.toDegrees(x));
                float press = 1.0f;
                playerStatus.getLerpTarget().rightArm.x = (float)((double)press * vec.field_72448_b);
                playerStatus.getLerpTarget().rightArm.y = (float)((double)press * vec.field_72449_c);
                playerStatus.getLerpTarget().rightArm.z = (float)((double)press * vec.field_72450_a);
            } else {
                playerStatus.getLerpTarget().rightArm.x = 0.0f;
                playerStatus.getLerpTarget().rightArm.z = 0.0f;
                playerStatus.getLerpTarget().rightArm.y = 0.0f;
            }
            playerStatus.getLerpTarget().leftArm.xRot = (float)(-Math.toRadians(70.0));
            playerStatus.getLerpTarget().leftArm.yRot = (float)Math.toRadians(25.0);
        } else if (typing) {
            double x = Math.toRadians(90.0) - Math.toRadians(22.5);
            playerStatus.getLerpTarget().rightArm.xRot = (float)(-x);
            playerStatus.getLerpTarget().leftArm.xRot = (float)(-x);
            double tiltIn = Math.toRadians(20.0);
            playerStatus.getLerpTarget().rightArm.yRot = (float)(-tiltIn);
            playerStatus.getLerpTarget().leftArm.yRot = (float)tiltIn;
        }
        if (!(pointing || typing || playerStatus.isIdle())) {
            playerStatus.setLerpTarget(new Lerpables());
            playerStatus.getLerpTarget().head.xRot = playerStatus.xRotHeadBeforeOverriding;
            playerStatus.getLerpTarget().head.yRot = playerStatus.yRotHeadBeforeOverriding;
        }
        if (playerStatus.isIdle()) {
            playerStatus.getLerpTarget().head.xRot = (float)Math.toRadians(70.0);
            playerStatus.setNewLerp(40.0f);
        }
        if (this.getStatusPrev(uuid).getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE && this.getStatus(uuid).getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE) {
            playerStatus.getLerpPrev().head.xRot = playerStatus.xRotHeadBeforeOverriding;
            playerStatus.getLerpPrev().head.yRot = playerStatus.yRotHeadBeforeOverriding;
        }
    }

    public Vector3d getParticlePosition(PlayerEntity player) {
        Vector3d pos = player.func_213303_ch();
        float distFromFace = 0.75f;
        Vector3d lookVec = this.getBodyAngle(player).func_186678_a((double)distFromFace);
        return new Vector3d(pos.field_72450_a + lookVec.field_72450_a, pos.field_72448_b + 1.2, pos.field_72449_c + lookVec.field_72449_c);
    }

    public Vector3d getBodyAngle(PlayerEntity player) {
        return this.calculateViewVector(player.field_70125_A, player.field_70761_aq);
    }

    public Vector3d calculateViewVector(float pXRot, float pYRot) {
        float f = pXRot * ((float)Math.PI / 180);
        float f1 = -pYRot * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vector3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    @Override
    public PlayerStatus getStatusLocal() {
        return this.selfPlayerStatus;
    }

    public PlayerStatus getStatusPrevLocal() {
        return this.selfPlayerStatusPrev;
    }

    public PlayerStatus getStatusPrev(PlayerEntity player) {
        return this.getStatusPrev(player.func_110124_au());
    }

    public PlayerStatus getStatusPrev(UUID uuid) {
        return this.getStatusPrev(uuid, false);
    }

    public PlayerStatus getStatusPrev(UUID uuid, boolean local) {
        if (local) {
            return this.getStatusPrevLocal();
        }
        this.checkPrev(uuid);
        return this.lookupPlayerToStatusPrev.get(uuid);
    }

    public void checkPrev(UUID uuid) {
        if (!this.lookupPlayerToStatusPrev.containsKey(uuid)) {
            this.lookupPlayerToStatusPrev.put(uuid, new PlayerStatus(PlayerStatus.PlayerGuiState.NONE));
        }
    }

    public void sendStatus(PlayerStatus.PlayerGuiState playerStatus) {
        this.sendStatus(playerStatus, false);
    }

    public void sendStatus(PlayerStatus.PlayerGuiState playerStatus, boolean force) {
        if (this.getStatusLocal().getPlayerGuiState() != playerStatus || force) {
            CompoundNBT data = new CompoundNBT();
            data.func_74768_a(WatutNetworking.NBTDataPlayerStatus, playerStatus.ordinal());
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setPlayerGuiState(playerStatus);
    }

    public void sendMouse(Pair<Float, Float> pos, boolean pressed) {
        Minecraft mc = Minecraft.func_71410_x();
        float x = ((Float)pos.first).floatValue();
        float y = ((Float)pos.second).floatValue();
        if (mc.field_71441_e.func_190525_a(mc.field_71439_g.func_226277_ct_(), mc.field_71439_g.func_226278_cu_(), mc.field_71439_g.func_226281_cx_(), (double)this.nearbyPlayerDataSendDist, entity -> entity != mc.field_71439_g) != null && (this.getStatusLocal().getScreenPosPercentX() != x || this.getStatusLocal().getScreenPosPercentY() != y || this.getStatusLocal().isPressing() != pressed)) {
            CompoundNBT data = new CompoundNBT();
            data.func_74776_a(WatutNetworking.NBTDataPlayerMouseX, x);
            data.func_74776_a(WatutNetworking.NBTDataPlayerMouseY, y);
            data.func_74757_a(WatutNetworking.NBTDataPlayerMousePressed, pressed);
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setScreenPosPercentX(x);
        this.getStatusLocal().setScreenPosPercentY(y);
        this.getStatusLocal().setPressing(pressed);
    }

    public void sendTyping(PlayerStatus status) {
        CompoundNBT data = new CompoundNBT();
        data.func_74776_a(WatutNetworking.NBTDataPlayerTypingAmp, status.getTypingAmplifier());
        WatutNetworking.instance().clientSendToServer(data);
    }

    public void sendIdle(PlayerStatus status) {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a(WatutNetworking.NBTDataPlayerIdleTicks, status.getTicksSinceLastAction());
        WatutNetworking.instance().clientSendToServer(data);
    }

    public void receiveAny(UUID uuid, CompoundNBT data) {
        PlayerStatus status = this.getStatus(uuid);
        PlayerStatus statusPrev = this.getStatusPrev(uuid);
        if (data.func_74764_b(WatutNetworking.NBTDataPlayerTypingAmp)) {
            status.setTypingAmplifier(data.func_74760_g(WatutNetworking.NBTDataPlayerTypingAmp));
        }
        if (data.func_74764_b(WatutNetworking.NBTDataPlayerMouseX)) {
            PlayerEntity player;
            float x = data.func_74760_g(WatutNetworking.NBTDataPlayerMouseX);
            float y = data.func_74760_g(WatutNetworking.NBTDataPlayerMouseY);
            boolean pressed = data.func_74767_n(WatutNetworking.NBTDataPlayerMousePressed);
            boolean differentPress = status.isPressing() != pressed;
            this.setMouse(uuid, x, y, pressed);
            this.setPoseTarget(uuid, differentPress);
            if (pressed && differentPress && (player = Minecraft.func_71410_x().field_71441_e.func_217371_b(uuid)) != null && ConfigClient.playMouseClickSounds && player != Minecraft.func_71410_x().field_71439_g) {
                WatutMod.dbg("play sound for " + uuid + " name " + player.func_145748_c_().getString());
                player.field_70170_p.func_184134_a(player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c, SoundEvents.field_187665_Y, SoundCategory.PLAYERS, 0.05f, 0.1f, false);
            }
        }
        if (data.func_74764_b(WatutNetworking.NBTDataPlayerStatus)) {
            PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.func_74762_e(WatutNetworking.NBTDataPlayerStatus));
            status.setPlayerGuiState(playerGuiState);
            if (status.getPlayerGuiState() != statusPrev.getPlayerGuiState()) {
                WatutMod.dbg("New gui player state and new pose target set relating to: " + (Object)((Object)status.getPlayerGuiState()) + " for " + uuid);
                if (statusPrev.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) {
                    status.setLerpTarget(new Lerpables());
                }
                if (status.getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHAT_OPEN) {
                    status.setTypingAmplifier(1.0f);
                    status.setTypingAmplifierSmooth(1.0f);
                }
                this.setPoseTarget(uuid, false);
                PlayerEntity player = Minecraft.func_71410_x().field_71441_e.func_217371_b(uuid);
                if (player != null && ConfigClient.playScreenOpenSounds && player != Minecraft.func_71410_x().field_71439_g) {
                    PlayerStatus.PlayerGuiState playerGuiStatePrev = statusPrev.getPlayerGuiState();
                    if (playerGuiState == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiState == PlayerStatus.PlayerGuiState.CRAFTING || playerGuiState == PlayerStatus.PlayerGuiState.MISC || playerGuiStatePrev == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiStatePrev == PlayerStatus.PlayerGuiState.CRAFTING || playerGuiStatePrev == PlayerStatus.PlayerGuiState.MISC) {
                        player.field_70170_p.func_184134_a(player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c, SoundEvents.field_187713_n, SoundCategory.PLAYERS, 0.9f, 1.0f, false);
                    }
                }
            }
        }
        if (data.func_74764_b(WatutNetworking.NBTDataPlayerIdleTicks)) {
            status.setTicksSinceLastAction(data.func_74762_e(WatutNetworking.NBTDataPlayerIdleTicks));
            status.setTicksToMarkPlayerIdleSyncedForClient(data.func_74762_e(WatutNetworking.NBTDataPlayerTicksToGoIdle));
            statusPrev.setTicksToMarkPlayerIdleSyncedForClient(data.func_74762_e(WatutNetworking.NBTDataPlayerTicksToGoIdle));
            this.getStatusLocal().setTicksToMarkPlayerIdleSyncedForClient(data.func_74762_e(WatutNetworking.NBTDataPlayerTicksToGoIdle));
            this.getStatusPrevLocal().setTicksToMarkPlayerIdleSyncedForClient(data.func_74762_e(WatutNetworking.NBTDataPlayerTicksToGoIdle));
            if (statusPrev.isIdle() != status.isIdle()) {
                WatutMod.dbg("New idle player state and new pose target set relating to idle state: " + status.isIdle() + " for " + uuid);
                this.setPoseTarget(uuid, false);
            }
        }
    }
}

