/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.MinimapLogs;

public class WaypointsManager {
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private Minecraft mc;
    private HashMap<String, WaypointWorldContainer> waypointMap = new HashMap();
    private WaypointSet waypoints = null;
    private List<Waypoint> serverWaypoints = null;
    public static final Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = new Hashtable();
    private String mainContainerID;
    private String containerID = null;
    private String containerIDIgnoreCaseCache;
    private String customContainerID = null;
    private String worldID = null;
    private String customWorldID = null;
    private BlockPos currentSpawn;
    public long setChanged;
    public static final String TELEPORT_ANYWAY_COMMAND = "/xaero_tp_anyway";
    private Waypoint teleportAnywayWP;
    private WaypointWorld teleportAnywayWorld;

    public WaypointsManager(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.mc = Minecraft.func_71410_x();
    }

    public void onLoad() throws IOException {
        this.mainContainerID = this.getMainContainer(false);
        this.fixIPv6Folder();
    }

    @Deprecated
    public double getDimensionDivision(String worldContainerID) {
        if (worldContainerID == null) {
            return 1.0;
        }
        WaypointWorldContainer container = this.getWorldContainerNullable(worldContainerID);
        if (container == null) {
            return 1.0;
        }
        return this.getDimensionDivision(container.getFirstWorld());
    }

    public double getDimensionDivision(WaypointWorld waypointWorld) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return 1.0;
        }
        double selectedDimDiv = this.getDimCoordinateScale(waypointWorld);
        return Minecraft.func_71410_x().field_71441_e.func_230315_m_().func_242724_f() / selectedDimDiv;
    }

    public double getDimCoordinateScale(WaypointWorld waypointWorld) {
        if (waypointWorld == null) {
            return 1.0;
        }
        WaypointWorldRootContainer rootContainer = waypointWorld.getContainer().getRootContainer();
        RegistryKey<World> dimKey = waypointWorld.getDimId();
        if (dimKey == null) {
            return 1.0;
        }
        return rootContainer.getDimensionScale(dimKey);
    }

    public String getDimensionDirectoryName(RegistryKey<World> dimKey) {
        if (dimKey == World.field_234918_g_) {
            return "dim%0";
        }
        if (dimKey == World.field_234919_h_) {
            return "dim%-1";
        }
        if (dimKey == World.field_234920_i_) {
            return "dim%1";
        }
        ResourceLocation identifier = dimKey.func_240901_a_();
        return "dim%" + identifier.func_110624_b() + "$" + identifier.func_110623_a().replace('/', '%');
    }

    public RegistryKey<World> findDimensionKey(String validatedName) {
        Set allDimensions = this.mc.field_71439_g.field_71174_a.func_239164_m_();
        for (RegistryKey dk : allDimensions) {
            if (!validatedName.equals(dk.func_240901_a_().func_110623_a().replaceAll("[^a-zA-Z0-9_]+", ""))) continue;
            return dk;
        }
        return null;
    }

    public RegistryKey<World> getDimensionKeyForDirectoryName(String dirName) {
        String dimIdPart = dirName.substring(4);
        if (dimIdPart.equals("0")) {
            return World.field_234918_g_;
        }
        if (dimIdPart.equals("1")) {
            return World.field_234920_i_;
        }
        if (dimIdPart.equals("-1")) {
            return World.field_234919_h_;
        }
        String[] idArgs = dimIdPart.split("\\$");
        if (idArgs.length < 2) {
            return null;
        }
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(idArgs[0], idArgs[1].replace('%', '/')));
    }

    private String getMainContainer(boolean preIP6Fix) {
        String potentialContainerID;
        if (this.mc.func_71401_C() != null) {
            potentialContainerID = this.mc.func_71401_C().func_240776_a_(FolderName.field_237253_i_).getParent().getFileName().toString().replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else if (this.mc.func_181540_al() && this.modMain.getEvents().latestRealm != null) {
            potentialContainerID = "Realms_" + this.modMain.getEvents().latestRealm.field_230588_g_ + "." + this.modMain.getEvents().latestRealm.field_230582_a_;
        } else if (this.mc.func_147104_D() != null) {
            String serverIP = this.modMain.getSettings().differentiateByServerAddress ? this.mc.func_147104_D().field_78845_b : "Any Address";
            int portDivider = !preIP6Fix && serverIP.indexOf(":") != serverIP.lastIndexOf(":") ? serverIP.lastIndexOf("]:") + 1 : serverIP.indexOf(":");
            if (portDivider > 0) {
                serverIP = serverIP.substring(0, portDivider);
            }
            while (serverIP.endsWith(".")) {
                serverIP = serverIP.substring(0, serverIP.length() - 1);
            }
            potentialContainerID = "Multiplayer_" + serverIP.replace(":", "\u00a7").replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else {
            potentialContainerID = "Unknown";
        }
        potentialContainerID = this.ignoreContainerCase(potentialContainerID, null);
        return potentialContainerID;
    }

    public String ignoreContainerCase(String potentialContainerID, String current) {
        if (potentialContainerID.equalsIgnoreCase(current)) {
            return current;
        }
        Set<Map.Entry<String, WaypointWorldContainer>> entries = this.waypointMap.entrySet();
        for (Map.Entry<String, WaypointWorldContainer> e : entries) {
            String containerSearch = e.getValue().getEqualIgnoreCaseSub(potentialContainerID);
            if (containerSearch == null) continue;
            return containerSearch;
        }
        return potentialContainerID;
    }

    public String getNewAutoWorldID(RegistryKey<World> dimId, boolean useWorldmap) {
        String worldmapMultiworldId;
        if (this.mc.func_71401_C() != null) {
            return "waypoints";
        }
        WaypointWorldRootContainer rootContainer = (WaypointWorldRootContainer)this.getWorldContainer(this.mainContainerID);
        Object autoIdBase = this.getAutoIdBase(rootContainer);
        String string = worldmapMultiworldId = useWorldmap ? this.modMain.getSupportMods().worldmapSupport.tryToGetMultiworldId(dimId) : null;
        if (!(autoIdBase == null || useWorldmap && worldmapMultiworldId == null)) {
            String actualMultiworldId;
            if (autoIdBase instanceof BlockPos) {
                BlockPos pos = (BlockPos)autoIdBase;
                actualMultiworldId = "mw" + (pos.func_177958_n() >> 6) + "," + (pos.func_177956_o() >> 6) + "," + (pos.func_177952_p() >> 6);
                if (!rootContainer.isUsingMultiworldDetection()) {
                    String defaultMultiworldId = rootContainer.getDefaultMultiworldId();
                    if (defaultMultiworldId == null) {
                        rootContainer.setDefaultMultiworldId(actualMultiworldId);
                        rootContainer.saveConfig();
                    } else {
                        actualMultiworldId = defaultMultiworldId;
                    }
                }
            } else {
                actualMultiworldId = "mw$" + autoIdBase;
            }
            if (useWorldmap && worldmapMultiworldId != "minimap") {
                actualMultiworldId = worldmapMultiworldId;
            }
            return actualMultiworldId;
        }
        return null;
    }

    public String getCurrentContainerAndWorldID() {
        return this.getCurrentContainerAndWorldID(this.containerID, this.worldID);
    }

    public String getCurrentContainerID() {
        return this.getCurrentContainerID(this.containerID);
    }

    public String getCurrentWorldID() {
        return this.getCurrentWorldID(this.worldID);
    }

    public WaypointWorld getCurrentWorld() {
        return this.getCurrentWorld(this.containerID, this.worldID);
    }

    public String getCurrentOriginContainerID() {
        return this.getCurrentOriginContainerID(this.containerID);
    }

    public String getCurrentContainerAndWorldID(String autoContainer, String autoWorldID) {
        return this.getCurrentContainerID(autoContainer) + "_" + this.getCurrentWorldID(autoWorldID);
    }

    public String getCurrentContainerID(String autoContainer) {
        if (this.customContainerID == null) {
            return autoContainer;
        }
        return this.customContainerID;
    }

    public String getCurrentWorldID(String autoWorldID) {
        if (this.customWorldID == null) {
            return autoWorldID;
        }
        return this.customWorldID;
    }

    public WaypointWorld getCurrentWorld(String autoContainer, String autoWorldID) {
        return this.getWorld(this.getCurrentContainerID(autoContainer), this.getCurrentWorldID(autoWorldID));
    }

    public String getCurrentOriginContainerID(String autoContainer) {
        if (this.getCurrentContainerID(autoContainer) == null) {
            return null;
        }
        return this.getCurrentContainerID(autoContainer).split("/")[0];
    }

    public WaypointWorld getAutoWorld() {
        return this.getWorld(this.getAutoContainerID(), this.getAutoWorldID());
    }

    public String getAutoRootContainerID() {
        return this.mainContainerID;
    }

    public String getAutoContainerID() {
        return this.containerID;
    }

    public String getAutoWorldID() {
        return this.worldID;
    }

    public WaypointWorld getWorld(String container, String world) {
        return this.addWorld(container, world);
    }

    public WaypointWorld addWorld(String container, String world) {
        if (container == null) {
            return null;
        }
        WaypointWorldContainer wc = this.addWorldContainer(container);
        return wc.addWorld(world);
    }

    public WaypointWorldContainer getWorldContainer(String id) {
        return this.addWorldContainer(id);
    }

    public WaypointWorldContainer addWorldContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container != null) continue;
                container = new WaypointWorldRootContainer(this.modMain, this.minimapSession, subs[i]);
                this.waypointMap.put(subs[i], container);
                WaypointWorldRootContainer rootContainer = (WaypointWorldRootContainer)container;
                if (rootContainer.configLoaded) continue;
                rootContainer.loadConfig();
                continue;
            }
            container = container.addSubContainer(subs[i]);
        }
        return container;
    }

    public WaypointWorldContainer getWorldContainerNullable(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            container = i == 0 ? this.waypointMap.get(subs[i]) : container.subContainers.get(subs[i]);
            if (container != null) continue;
            return null;
        }
        return container;
    }

    public void removeContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container == null) {
                    return;
                }
                if (i != subs.length - 1) continue;
                this.waypointMap.remove(subs[i]);
                return;
            }
            if (container.containsSub(subs[i])) {
                if (i == subs.length - 1) {
                    container.deleteSubContainer(subs[i]);
                    return;
                }
                container = container.addSubContainer(subs[i]);
                continue;
            }
            return;
        }
    }

    public boolean containerExists(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container == null) {
                    return false;
                }
                if (i != subs.length - 1) continue;
                return true;
            }
            if (container.containsSub(subs[i])) {
                if (i == subs.length - 1) {
                    return true;
                }
                container = container.addSubContainer(subs[i]);
                continue;
            }
            return false;
        }
        return false;
    }

    public void updateWorldIds() {
        String oldContainerID = this.containerID;
        String oldWorldID = this.worldID;
        this.containerIDIgnoreCaseCache = this.containerID = this.getPotentialContainerID();
        String potentialWorldID = this.getNewAutoWorldID((RegistryKey<World>)this.mc.field_71441_e.func_234923_W_(), this.modMain.getSupportMods().worldmap());
        if (potentialWorldID == null) {
            this.containerID = oldContainerID;
            this.worldID = oldWorldID;
        } else {
            this.worldID = potentialWorldID;
            if (this.containerID != null && !this.containerID.equals(oldContainerID)) {
                if (oldWorldID != null && oldWorldID.startsWith("plugin")) {
                    WaypointWorldContainer oldContainer = this.getWorldContainer(oldContainerID);
                    ArrayList<WaypointWorld> worlds = new ArrayList<WaypointWorld>(oldContainer.worlds.values());
                    for (int i = 0; i < worlds.size(); ++i) {
                        worlds.get(i).getServerWaypoints().clear();
                    }
                }
                WaypointWorldContainer rootContainer = this.getWorldContainer(this.mainContainerID);
                rootContainer.renameOldContainer(this.containerID);
                ((WaypointWorldRootContainer)rootContainer).updateDimensionType(this.mc.field_71441_e);
            }
        }
    }

    private String getPotentialContainerID() {
        return this.ignoreContainerCase(this.mainContainerID + "/" + this.getDimensionDirectoryName((RegistryKey<World>)this.mc.field_71441_e.func_234923_W_()), this.containerIDIgnoreCaseCache);
    }

    public void updateWaypoints() {
        if (this.containerID != null && this.worldID != null) {
            this.addWorld(this.containerID, this.worldID);
            WaypointWorld world = this.getCurrentWorld();
            this.waypoints = world.getCurrentSet();
            this.serverWaypoints = !world.getServerWaypoints().isEmpty() ? new ArrayList<Waypoint>(world.getServerWaypoints().values()) : null;
        }
    }

    public void createDeathpoint(PlayerEntity p) {
        WaypointWorld autoWorld;
        boolean shouldAddToAuto;
        this.updateWorldIds();
        if (this.modMain.getSettings().switchToAutoOnDeath) {
            this.setCustomContainerID(null);
            this.setCustomWorldID(null);
        }
        boolean bl = shouldAddToAuto = (autoWorld = this.getAutoWorld()) != null;
        if (this.modMain.getSupportMods().worldmap()) {
            String realCurrentDimContainerKey = this.getPotentialContainerID();
            boolean containerIsSynced = realCurrentDimContainerKey.equals(this.containerID);
            List<String> allPotentialMWIds = this.modMain.getSupportMods().worldmapSupport.getPotentialMultiworldIds((RegistryKey<World>)this.mc.field_71441_e.func_234923_W_());
            if (allPotentialMWIds != null && !allPotentialMWIds.isEmpty()) {
                for (String mwId : allPotentialMWIds) {
                    WaypointWorld potentialWorld = this.getWorld(realCurrentDimContainerKey, mwId);
                    if (containerIsSynced && potentialWorld == autoWorld) continue;
                    this.createDeathpoint(p, potentialWorld, false);
                }
                boolean bl2 = shouldAddToAuto = shouldAddToAuto && containerIsSynced;
            }
        }
        if (shouldAddToAuto) {
            this.createDeathpoint(p, autoWorld, false);
        }
    }

    private void createDeathpoint(PlayerEntity p, WaypointWorld wpw, boolean temp) {
        boolean disabled = false;
        WaypointSet waypoints = wpw.getCurrentSet();
        if (waypoints == null) {
            return;
        }
        block2: for (WaypointSet set : wpw.getSets().values()) {
            for (int i = 0; i < set.getList().size(); ++i) {
                Waypoint w = set.getList().get(i);
                if (w.getWaypointType() != 1) continue;
                if (set == waypoints) {
                    disabled = w.isDisabled();
                }
                if (!this.modMain.getSettings().getOldDeathpoints()) {
                    set.getList().remove(i);
                    --i;
                    continue block2;
                }
                w.setType(2);
                w.setName("gui.xaero_deathpoint_old");
                continue block2;
            }
        }
        ArrayList<Waypoint> list = waypoints.getList();
        double dimDiv = this.getDimensionDivision(wpw);
        if (this.modMain.getSettings().getDeathpoints()) {
            Waypoint deathpoint = new Waypoint(OptimizedMath.myFloor((double)OptimizedMath.myFloor(p.func_226277_ct_()) * dimDiv), OptimizedMath.myFloor(p.func_226278_cu_()), OptimizedMath.myFloor((double)OptimizedMath.myFloor(p.func_226281_cx_()) * dimDiv), "gui.xaero_deathpoint", "D", 0, 1);
            deathpoint.setDisabled(disabled);
            deathpoint.setTemporary(temp);
            list.add(0, deathpoint);
        }
        try {
            this.modMain.getSettings().saveWaypoints(wpw);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public void createTemporaryWaypoints(WaypointWorld waypointWorld, int x, int y, int z) {
        this.createTemporaryWaypoints(waypointWorld, x, y, z, true);
    }

    public void createTemporaryWaypoints(WaypointWorld waypointWorld, int x, int y, int z, boolean yIncluded, double dimScale) {
        if (this.modMain.getSettings().waypointsGUI(this) && waypointWorld != null) {
            double waypointDestDimScale = this.getDimCoordinateScale(waypointWorld);
            double dimDiv = dimScale / waypointDestDimScale;
            x = OptimizedMath.myFloor((double)x * dimDiv);
            z = OptimizedMath.myFloor((double)z * dimDiv);
            Waypoint instant = new Waypoint(x, y, z, "Waypoint", "X", (int)(Math.random() * (double)ModSettings.ENCHANT_COLORS.length), 0, true, yIncluded);
            if (!this.modMain.getSettings().waypointsBottom) {
                waypointWorld.getCurrentSet().getList().add(0, instant);
            } else {
                waypointWorld.getCurrentSet().getList().add(instant);
            }
        }
    }

    public void createTemporaryWaypoints(WaypointWorld waypointWorld, int x, int y, int z, boolean yIncluded) {
        this.createTemporaryWaypoints(waypointWorld, x, y, z, yIncluded, Minecraft.func_71410_x().field_71441_e.func_230315_m_().func_242724_f());
    }

    public boolean canTeleport(boolean displayingTeleportableWorld, WaypointWorld displayedWorld) {
        return (this.modMain.getSettings().allowWrongWorldTeleportation || displayingTeleportableWorld) && displayedWorld.getContainer().getRootContainer().isTeleportationEnabled();
    }

    public void teleportAnyway() {
        if (this.teleportAnywayWP != null) {
            Screen dummyScreen = new Screen((ITextComponent)new StringTextComponent("")){};
            Minecraft minecraft = Minecraft.func_71410_x();
            dummyScreen.func_231158_b_(minecraft, minecraft.func_228018_at_().func_198107_o(), minecraft.func_228018_at_().func_198087_p());
            this.teleportToWaypoint(this.teleportAnywayWP, this.teleportAnywayWorld, dummyScreen, false);
        }
    }

    public void teleportToWaypoint(Waypoint selected, WaypointWorld displayedWorld, Screen screen) {
        this.teleportToWaypoint(selected, displayedWorld, screen, true);
    }

    public void teleportToWaypoint(Waypoint selected, WaypointWorld displayedWorld, Screen screen, boolean respectHiddenCoords) {
        this.updateWorldIds();
        boolean displayingTeleportableWorld = this.isWorldTeleportable(displayedWorld);
        if (selected != null && this.canTeleport(displayingTeleportableWorld, displayedWorld)) {
            this.mc.func_147108_a(null);
            if (!selected.isYIncluded() && this.mc.field_71442_b.func_78755_b()) {
                StringTextComponent messageComponent = new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_teleport_y_unknown", (Object[])new Object[0]));
                messageComponent.func_230530_a_(messageComponent.func_150256_b().func_240712_a_(TextFormatting.RED));
                this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
                return;
            }
            String tpCommand = "";
            boolean reachableDimension = true;
            boolean crossDimension = false;
            WaypointWorldRootContainer rootContainer = displayedWorld.getContainer().getRootContainer();
            WaypointWorld autoWorld = this.getAutoWorld();
            if (displayingTeleportableWorld && displayedWorld != autoWorld) {
                if (!this.isTeleportationSafe(displayedWorld)) {
                    StringTextComponent messageComponent = new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_teleport_not_connected", (Object[])new Object[0]));
                    messageComponent.func_230530_a_(messageComponent.func_150256_b().func_240712_a_(TextFormatting.RED));
                    this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
                    return;
                }
                if (autoWorld == null || autoWorld.getContainer() != displayedWorld.getContainer()) {
                    crossDimension = true;
                    String[] containerKeySplit = displayedWorld.getContainer().getKey().split("/");
                    if (containerKeySplit.length > 1) {
                        String dimensionKey = containerKeySplit[1];
                        if (!dimensionKey.startsWith("dim%")) {
                            this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("gui.xaero_visit_needed"));
                            return;
                        }
                        RegistryKey<World> dimensionId = this.getDimensionKeyForDirectoryName(dimensionKey);
                        if (dimensionId != null) {
                            this.setCustomContainerID(null);
                            this.setCustomWorldID(null);
                            this.updateWaypoints();
                            tpCommand = "/execute in " + dimensionId.func_240901_a_().toString() + " run ";
                        } else {
                            reachableDimension = false;
                        }
                    } else {
                        reachableDimension = false;
                    }
                }
            }
            if (reachableDimension) {
                if (respectHiddenCoords && this.modMain.getSettings().hideWaypointCoordinates && this.mc.field_71474_y.field_74343_n != ChatVisibility.HIDDEN) {
                    StringTextComponent messageComponent = new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_teleport_coordinates_hidden", (Object[])new Object[0]));
                    messageComponent.func_230530_a_(messageComponent.func_150256_b().func_240712_a_(TextFormatting.AQUA));
                    this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
                    StringTextComponent clickableQuestion = new StringTextComponent("\u00a7e[" + I18n.func_135052_a((String)"gui.xaero_teleport_anyway", (Object[])new Object[0]) + "]");
                    clickableQuestion.func_230530_a_(clickableQuestion.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, TELEPORT_ANYWAY_COMMAND)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("\u00a7c" + I18n.func_135052_a((String)"gui.xaero_teleport_shows_coordinates", (Object[])new Object[0])))));
                    this.teleportAnywayWP = selected;
                    this.teleportAnywayWorld = displayedWorld;
                    this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)clickableQuestion);
                } else {
                    String tpCommandPrefix;
                    int x = selected.getX();
                    int z = selected.getZ();
                    double dimDiv = this.getDimensionDivision(displayedWorld);
                    if (!crossDimension && dimDiv != 1.0) {
                        x = (int)Math.floor((double)x / dimDiv);
                        z = (int)Math.floor((double)z / dimDiv);
                    }
                    String serverTpCommand = selected.isRotation() ? rootContainer.getServerTeleportCommandRotationFormat() : rootContainer.getServerTeleportCommandFormat();
                    String defaultTpCommand = selected.isRotation() ? this.modMain.getSettings().defaultWaypointTPCommandRotationFormat : this.modMain.getSettings().defaultWaypointTPCommandFormat;
                    String string = tpCommandPrefix = rootContainer.isUsingDefaultTeleportCommand() || serverTpCommand == null ? defaultTpCommand : serverTpCommand;
                    if (tpCommand.length() > 0) {
                        if (tpCommandPrefix.startsWith("/")) {
                            tpCommandPrefix = tpCommandPrefix.substring(1);
                        }
                        if (tpCommandPrefix.startsWith("minecraft:")) {
                            tpCommandPrefix = tpCommandPrefix.substring(10);
                        }
                    }
                    String yString = !selected.isYIncluded() ? "~" : (this.modMain.getSettings().getPartialYTeleportation() ? (double)selected.getY() + 0.5 + "" : selected.getY() + "");
                    tpCommandPrefix = tpCommandPrefix.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z).replace("{name}", selected.getLocalizedName());
                    if (selected.isRotation()) {
                        tpCommandPrefix = tpCommandPrefix.replace("{yaw}", "" + selected.getYaw());
                    }
                    tpCommand = tpCommand + tpCommandPrefix;
                    screen.func_231159_b_(tpCommand, false);
                }
            } else {
                this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent("\u00a7c" + I18n.func_135052_a((String)"gui.xaero_unreachable_dimension", (Object[])new Object[0])));
            }
        }
    }

    public boolean isWorldTeleportable(WaypointWorld displayedWorld) {
        WaypointWorld autoWorld = this.getAutoWorld();
        WaypointWorldRootContainer rootContainer = displayedWorld.getContainer().getRootContainer();
        return rootContainer.getKey().equals(this.getAutoRootContainerID()) && (autoWorld == displayedWorld || autoWorld != null && (autoWorld.getContainer() == displayedWorld.getContainer() || this.modMain.getSettings().crossDimensionalTp && autoWorld.getContainer() != displayedWorld.getContainer()));
    }

    public boolean isTeleportationSafe(WaypointWorld displayedWorld) {
        if (!Minecraft.func_71410_x().field_71442_b.func_78755_b()) {
            return true;
        }
        WaypointWorld autoWorld = this.getAutoWorld();
        WaypointWorldRootContainer rootContainer = displayedWorld.getContainer().getRootContainer();
        return rootContainer.getSubWorldConnections().isConnected(autoWorld, displayedWorld);
    }

    public WaypointSet getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(WaypointSet waypoints) {
        this.waypoints = waypoints;
    }

    public List<Waypoint> getServerWaypoints() {
        return this.serverWaypoints;
    }

    public HashMap<String, WaypointWorldContainer> getWaypointMap() {
        return this.waypointMap;
    }

    public void setCurrentSpawn(BlockPos currentSpawn, ClientWorld clientWorld) {
        this.currentSpawn = currentSpawn;
    }

    public String getCustomContainerID() {
        return this.customContainerID;
    }

    public void setCustomContainerID(String customContainerID) {
        this.customContainerID = customContainerID;
    }

    public String getCustomWorldID() {
        return this.customWorldID;
    }

    public void setCustomWorldID(String customWorldID) {
        this.customWorldID = customWorldID;
    }

    public static Hashtable<Integer, Waypoint> getCustomWaypoints(String modName) {
        Hashtable<Integer, Waypoint> wps = customWaypoints.get(modName);
        if (wps == null) {
            wps = new Hashtable();
            customWaypoints.put(modName, wps);
        }
        return wps;
    }

    public boolean isMultiplayer(String containerId) {
        return containerId.startsWith("Multiplayer_") || containerId.startsWith("Realms_");
    }

    private boolean hasServerLevelId(WaypointWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData.serverLevelId != null && !rootContainer.isIgnoreServerLevelId();
    }

    private Object getAutoIdBase(WaypointWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return this.hasServerLevelId(rootContainer) ? worldData.serverLevelId : this.currentSpawn;
    }

    public void onServerLevelId(int id) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        worldData.serverLevelId = id;
        MinimapLogs.LOGGER.info("Minimap updated server level id: " + id + " for world " + Minecraft.func_71410_x().field_71441_e.func_234923_W_());
    }

    @Deprecated
    public boolean divideBy8(String key) {
        return false;
    }

    private void fixIPv6Folder() throws IOException {
        Path fixedFolder;
        Path preFixFolder;
        String preIP6FixMainContainerID;
        if (this.mainContainerID.startsWith("Multiplayer_") && !this.mainContainerID.equals(preIP6FixMainContainerID = this.getMainContainer(true)) && Files.exists(preFixFolder = new File(this.modMain.getWaypointsFolder(), preIP6FixMainContainerID).toPath(), new LinkOption[0]) && !Files.exists(fixedFolder = new File(this.modMain.getWaypointsFolder(), this.mainContainerID).toPath(), new LinkOption[0])) {
            Files.move(preFixFolder, fixedFolder, new CopyOption[0]);
        }
    }
}

