/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.minimap.render.radar.ModelPartRenderDetectionInfo;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;

public class EntityIconModelPartsRenderer {
    public Method ageableModelHeadPartsMethod;
    public Method ageableModelBodyPartsMethod;
    public Method segmentedModelPartsMethod;
    private Field cubeListField;
    private Field childModelsField;
    private VertexConsumerWrapper vertexConsumerWrapper;
    private boolean testedRenderEngineWrapperCompatibility;
    private boolean renderEngineIsWrapperCompatible;
    private IXaeroMinimap modMain;

    public EntityIconModelPartsRenderer(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.ageableModelHeadPartsMethod = Misc.getMethodReflection(AgeableModel.class, "headParts", "method_22946", "()Ljava/lang/Iterable;", "func_225602_a_", new Class[0]);
        this.ageableModelBodyPartsMethod = Misc.getMethodReflection(AgeableModel.class, "bodyParts", "method_22948", "()Ljava/lang/Iterable;", "func_225600_b_", new Class[0]);
        this.segmentedModelPartsMethod = Misc.getMethodReflection(SegmentedModel.class, "parts", "method_22960", "()Ljava/lang/Iterable;", "func_225601_a_", new Class[0]);
        this.cubeListField = Misc.getFieldReflection(ModelRenderer.class, "cubes", "field_3663", "Lit/unimi/dsi/fastutil/objects/ObjectList;", "field_78804_l");
        this.childModelsField = Misc.getFieldReflection(ModelRenderer.class, "children", "field_3661", "Lit/unimi/dsi/fastutil/objects/ObjectList;", "field_78805_m");
        this.vertexConsumerWrapper = new VertexConsumerWrapper();
    }

    private ObjectList<ModelRenderer.ModelBox> getCubeList(ModelRenderer modelRenderer) {
        return (ObjectList)Misc.getReflectFieldValue(modelRenderer, this.cubeListField);
    }

    private ObjectList<ModelRenderer> getChildModels(ModelRenderer modelRenderer) {
        return (ObjectList)Misc.getReflectFieldValue(modelRenderer, this.childModelsField);
    }

    public boolean hasDirectCubes(ModelRenderer mr) {
        ObjectList<ModelRenderer.ModelBox> mrCubeList = this.getCubeList(mr);
        return mrCubeList != null && !mrCubeList.isEmpty();
    }

    public boolean hasCubes(ModelRenderer mr) {
        if (this.hasDirectCubes(mr)) {
            return true;
        }
        ObjectList<ModelRenderer> mrChildren = this.getChildModels(mr);
        for (ModelRenderer child : mrChildren) {
            if (!this.hasCubes(child)) continue;
            return true;
        }
        return false;
    }

    public void renderPart(MatrixStack matrixStack, IVertexBuilder vertexBuilder, ModelRenderer mr, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainModelPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (mr == null) {
            return;
        }
        if (renderedModels.contains(mr)) {
            return;
        }
        ModelPartRenderDetectionInfo renderInfo = mrde.getModelPartRenderInfo(mr);
        if (renderInfo == null) {
            return;
        }
        if (!this.hasCubes(mr)) {
            return;
        }
        boolean showModelBU = mr.field_78806_j;
        if (!this.testedRenderEngineWrapperCompatibility) {
            boolean normalWorks;
            block17: {
                normalWorks = false;
                try {
                    MatrixStack testMatrix = new MatrixStack();
                    testMatrix.func_227861_a_(0.0, 0.0, -2500.0);
                    IVertexBuilder actualVertexConsumer = this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers().getBuffer(CustomRenderTypes.entityIconRenderType(mrde.renderTexture, mrde.layerPhases));
                    mr.func_228309_a_(testMatrix, actualVertexConsumer, 0xF000F0, OverlayTexture.field_229196_a_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
                    normalWorks = true;
                    testMatrix = new MatrixStack();
                    testMatrix.func_227861_a_(0.0, 0.0, -2500.0);
                    this.vertexConsumerWrapper.prepareDetection(actualVertexConsumer, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                    mr.field_78806_j = true;
                    mr.func_228309_a_(testMatrix, (IVertexBuilder)this.vertexConsumerWrapper, 0xF000F0, OverlayTexture.field_229196_a_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
                    this.renderEngineIsWrapperCompatible = this.vertexConsumerWrapper.detectedVertex;
                    if (!this.renderEngineIsWrapperCompatible) {
                        throw new Exception("can't detect vertices");
                    }
                }
                catch (Throwable t) {
                    if (!normalWorks) break block17;
                    MinimapLogs.LOGGER.warn("Render engine used for entities is not fully compatible with the minimap entity icons. Using fallback. " + t.getMessage());
                }
            }
            if (normalWorks) {
                this.testedRenderEngineWrapperCompatibility = true;
            }
        }
        float rotationPointBUX = mr.field_78800_c;
        float rotationPointBUY = mr.field_78797_d;
        float rotationPointBUZ = mr.field_78798_e;
        float rotateAngleBUX = mr.field_78795_f;
        float rotateAngleBUY = mr.field_78796_g;
        float rotateAngleBUZ = mr.field_78808_h;
        float centerPointX = mainModelPart.field_78800_c;
        float centerPointY = mainModelPart.field_78797_d;
        float centerPointZ = mainModelPart.field_78798_e;
        ObjectList<ModelRenderer.ModelBox> mainCubeList = this.getCubeList(mainModelPart);
        if (mainCubeList != null && !mainCubeList.isEmpty()) {
            float biggestSize = 0.0f;
            ModelRenderer.ModelBox biggestCuboid = null;
            for (ModelRenderer.ModelBox cuboid : mainCubeList) {
                float size = Math.abs((cuboid.field_78248_d - cuboid.field_78252_a) * (cuboid.field_78249_e - cuboid.field_78250_b) * (cuboid.field_78246_f - cuboid.field_78251_c));
                if (!(size >= biggestSize)) continue;
                biggestCuboid = cuboid;
                biggestSize = size;
            }
            centerPointY += (biggestCuboid.field_78249_e + biggestCuboid.field_78250_b) / 2.0f;
            centerPointZ += (biggestCuboid.field_78246_f + biggestCuboid.field_78251_c) / 2.0f;
        }
        if (zeroRotation) {
            mr.field_78795_f = 0.0f;
            mr.field_78796_g = 0.0f;
            mr.field_78808_h = 0.0f;
        }
        mr.field_78806_j = true;
        mr.func_78793_a(mr.field_78800_c - centerPointX, mr.field_78797_d - centerPointY, mr.field_78798_e - centerPointZ);
        try {
            IVertexBuilder vertexConsumer = !this.renderEngineIsWrapperCompatible ? vertexBuilder : this.vertexConsumerWrapper.prepareDetection(vertexBuilder, 3.0, 61.0, 3.0, 61.0, -497.0, -2.0);
            mr.func_228309_a_(matrixStack, vertexConsumer, 0xF000F0, OverlayTexture.field_229196_a_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            if ((!this.renderEngineIsWrapperCompatible || this.vertexConsumerWrapper.hasDetectedVertex()) && renderInfo.alpha > 0.0f) {
                renderedModels.add(mr);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.info("Exception when rendering entity part. " + mr + " " + t.getMessage());
        }
        while (GL11.glGetError() != 0) {
        }
        mr.field_78800_c = rotationPointBUX;
        mr.field_78797_d = rotationPointBUY;
        mr.field_78798_e = rotationPointBUZ;
        if (zeroRotation) {
            mr.field_78795_f = rotateAngleBUX;
            mr.field_78796_g = rotateAngleBUY;
            mr.field_78808_h = rotateAngleBUZ;
        }
        mr.field_78806_j = showModelBU;
    }

    public ModelRenderer renderDeclaredMethod(MatrixStack matrixStack, IVertexBuilder vertexBuilder, Method m, EntityModel entityModel, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Iterable<ModelRenderer> renderers = this.handleDeclaredMethod(m, entityModel);
        return this.renderPartsIterable(renderers, matrixStack, vertexBuilder, renderedModels, mainPart, zeroRotation, mrde);
    }

    public Iterable<ModelRenderer> handleDeclaredMethod(Method m, EntityModel entityModel) {
        if (m != null) {
            return (Iterable)Misc.getReflectMethodValue(entityModel, m, new Object[0]);
        }
        return null;
    }

    public ModelRenderer renderPartsIterable(Iterable<ModelRenderer> parts, MatrixStack matrixStack, IVertexBuilder vertexBuilder, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<ModelRenderer> partsIterator = parts.iterator();
        if (partsIterator.hasNext()) {
            if (mainPart == null) {
                mainPart = partsIterator.next();
                this.renderPart(matrixStack, vertexBuilder, mainPart, renderedModels, mainPart, zeroRotation, mrde);
            }
            while (partsIterator.hasNext()) {
                this.renderPart(matrixStack, vertexBuilder, partsIterator.next(), renderedModels, mainPart, zeroRotation, mrde);
            }
        }
        return mainPart;
    }

    public static class VertexConsumerWrapper
    implements IVertexBuilder {
        private IVertexBuilder consumer;
        private boolean detectedVertex;
        private double detectionMinX;
        private double detectionMaxX;
        private double detectionMinY;
        private double detectionMaxY;
        private double detectionMinZ;
        private double detectionMaxZ;

        public VertexConsumerWrapper prepareDetection(IVertexBuilder consumer, double detectionMinX, double detectionMaxX, double detectionMinY, double detectionMaxY, double detectionMinZ, double detectionMaxZ) {
            this.consumer = consumer;
            this.detectionMinX = detectionMinX;
            this.detectionMaxX = detectionMaxX;
            this.detectionMinY = detectionMinY;
            this.detectionMaxY = detectionMaxY;
            this.detectionMinZ = detectionMinZ;
            this.detectionMaxZ = detectionMaxZ;
            this.detectedVertex = false;
            return this;
        }

        public IVertexBuilder func_225582_a_(double d, double e, double f) {
            if (d >= this.detectionMinX && d <= this.detectionMaxX && e >= this.detectionMinY && e <= this.detectionMaxY && f >= this.detectionMinZ && f <= this.detectionMaxZ) {
                this.detectedVertex = true;
            }
            return this.consumer.func_225582_a_(d, e, f);
        }

        public IVertexBuilder func_225586_a_(int i, int j, int k, int l) {
            return this.consumer.func_225586_a_(i, j, k, l);
        }

        public IVertexBuilder func_225583_a_(float f, float g) {
            return this.consumer.func_225583_a_(f, g);
        }

        public IVertexBuilder func_225585_a_(int i, int j) {
            return this.consumer.func_225585_a_(i, j);
        }

        public IVertexBuilder func_225587_b_(int i, int j) {
            return this.consumer.func_225587_b_(i, j);
        }

        public IVertexBuilder func_225584_a_(float f, float g, float h) {
            return this.consumer.func_225584_a_(f, g, h);
        }

        public void func_181675_d() {
            this.consumer.func_181675_d();
        }

        public boolean hasDetectedVertex() {
            return this.detectedVertex;
        }
    }
}

