/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.CrashHandler;
import xaero.map.MapLimiter;
import xaero.map.MapRunner;
import xaero.map.WorldMapClient;
import xaero.map.cache.UnknownBlockStateCache;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.common.config.CommonConfig;
import xaero.map.common.config.CommonConfigIO;
import xaero.map.common.config.CommonConfigInit;
import xaero.map.controls.ControlsRegister;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.events.ClientEvents;
import xaero.map.events.CommonEvents;
import xaero.map.events.ModClientEvents;
import xaero.map.events.ModCommonEvents;
import xaero.map.file.OldFormatSupport;
import xaero.map.file.export.PNGExporter;
import xaero.map.graphics.GLObjectDeleter;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.WorldMapMessageHandler;
import xaero.map.message.WorldMapMessageHandlerForge;
import xaero.map.message.WorldMapMessageRegister;
import xaero.map.misc.Internet;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointSymbolCreator;
import xaero.map.patreon.Patreon;
import xaero.map.pool.MapTilePool;
import xaero.map.pool.TextureUploadPool;
import xaero.map.pool.buffer.TextureDirectBufferPool;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderer;
import xaero.map.radar.tracker.PlayerTrackerMenuRenderer;
import xaero.map.radar.tracker.system.PlayerTrackerSystemManager;
import xaero.map.radar.tracker.system.impl.SyncedPlayerTrackerSystem;
import xaero.map.region.OverlayManager;
import xaero.map.server.WorldMapServer;
import xaero.map.server.mods.SupportServerMods;
import xaero.map.server.player.ServerPlayerTickHandler;
import xaero.map.settings.ModOptions;
import xaero.map.settings.ModSettings;

@Mod(value="xaeroworldmap")
public class WorldMap {
    public static int MINIMAP_COMPATIBILITY_VERSION = 26;
    public static Logger LOGGER = LogManager.getLogger();
    private static final String versionID_minecraft = "1.16.5";
    private static final String versionID_mod = "1.38.8";
    public static final String versionID = "1.16.5_1.38.8";
    public static int newestUpdateID;
    public static boolean isOutdated;
    public static String fileLayout;
    public static String fileLayoutID;
    public static String latestVersion;
    public static String latestVersionMD5;
    public static boolean loaded;
    public static ClientEvents events;
    public static ControlsRegister controlsRegister;
    public static WaypointSymbolCreator waypointSymbolCreator;
    public static ByteBufferDeallocator bufferDeallocator;
    public static TextureUploadBenchmark textureUploadBenchmark;
    public static OverlayManager overlayManager;
    public static OldFormatSupport oldFormatSupport;
    public static PNGExporter pngExporter;
    public static TextureUploadPool.Normal normalTextureUploadPool;
    public static TextureUploadPool.Compressed compressedTextureUploadPool;
    public static TextureUploadPool.BranchUpdate branchUpdatePool;
    public static TextureUploadPool.BranchUpdate branchUpdateAllocatePool;
    public static TextureUploadPool.BranchDownload branchDownloadPool;
    public static TextureUploadPool.SubsequentNormal subsequentNormalTextureUploadPool;
    public static TextureDirectBufferPool textureDirectBufferPool;
    public static MapTilePool tilePool;
    public static MapLimiter mapLimiter;
    public static UnknownBlockStateCache unknownBlockStateCache;
    public static GLObjectDeleter glObjectDeleter;
    public static MapRunner mapRunner;
    public static Thread mapRunnerThread;
    public static CrashHandler crashHandler;
    public static final ResourceLocation guiTextures;
    public static ModSettings settings;
    public static int globalVersion;
    public static WorldMapClient worldMapClient;
    public static MapElementRenderHandler mapElementRenderHandler;
    public static ServerPlayerTickHandler serverPlayerTickHandler;
    public static PlayerTrackerSystemManager playerTrackerSystemManager;
    public static PlayerTrackerMapElementRenderer trackedPlayerRenderer;
    public static PlayerTrackerMenuRenderer trackedPlayerMenuRenderer;
    public static WorldMapMessageHandler messageHandler;
    public static CommonEvents commonEvents;
    public static final SimpleChannel network;
    public static File modJAR;
    public static File configFolder;
    public static File optionsFile;
    public static File saveFolder;
    public static CommonConfigIO commonConfigIO;
    public static CommonConfig commonConfig;

    public WorldMap() {
        new CommonConfigInit().init("xaeroworldmap-common.txt");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadCommon);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadServer);
        commonEvents = new CommonEvents();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)commonEvents);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModCommonEvents());
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.registerClientEvents();
        }
    }

    private void registerClientEvents() {
        events = new ClientEvents();
        ModClientEvents modEvents = new ModClientEvents();
        MinecraftForge.EVENT_BUS.register((Object)events);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)modEvents);
    }

    private void loadClient(FMLClientSetupEvent event) {
        LOGGER.info("Loading Xaero's World Map - Stage 1/2");
        try {
            Object patreonEntry;
            trackedPlayerRenderer = PlayerTrackerMapElementRenderer.Builder.begin().build();
            trackedPlayerMenuRenderer = PlayerTrackerMenuRenderer.Builder.begin().setRenderer(trackedPlayerRenderer).build();
            ModOptions.init();
            String modId = this.getClass().getAnnotation(Mod.class).value();
            ModFile modFile = FMLLoader.getLoadingModList().getModFileById(modId).getFile();
            worldMapClient = new WorldMapClient();
            worldMapClient.preInit(event, modId);
            String fileName = modFile.getFileName();
            if (fileName.endsWith(".jar")) {
                modJAR = modFile.getFilePath().toFile();
            }
            Path gameDir = WorldMap.getGameDir();
            configFolder = FMLPaths.CONFIGDIR.get().toFile();
            optionsFile = configFolder.toPath().resolve("xaeroworldmap.txt").toFile();
            saveFolder = gameDir.resolve("XaeroWorldMap").toFile();
            Path oldSaveFolder3 = configFolder.toPath().getParent().resolve("XaeroWorldMap");
            File oldOptionsFile = gameDir.resolve("xaeroworldmap.txt").toFile();
            File oldSaveFolder = gameDir.resolve("mods").resolve("XaeroWorldMap").toFile();
            File oldSaveFolder2 = gameDir.resolve("config").resolve("XaeroWorldMap").toFile();
            if (oldOptionsFile.exists() && !optionsFile.exists()) {
                Files.move(oldOptionsFile.toPath(), optionsFile.toPath(), new CopyOption[0]);
            }
            if (oldSaveFolder.exists() && !saveFolder.exists()) {
                Files.move(oldSaveFolder.toPath(), saveFolder.toPath(), new CopyOption[0]);
            }
            if (oldSaveFolder2.exists() && !saveFolder.exists()) {
                Files.move(oldSaveFolder2.toPath(), saveFolder.toPath(), new CopyOption[0]);
            }
            if (oldSaveFolder3.toFile().exists() && !saveFolder.exists()) {
                Files.move(oldSaveFolder3, saveFolder.toPath(), new CopyOption[0]);
            }
            if (!saveFolder.exists()) {
                Files.createDirectories(saveFolder.toPath(), new FileAttribute[0]);
            }
            settings = new ModSettings();
            settings.loadSettings();
            Patreon.checkPatreon();
            Internet.checkModVersion();
            if (isOutdated && (patreonEntry = Patreon.getMods().get(fileLayoutID)) != null) {
                Patreon.setModInfo(patreonEntry, modJAR, versionID, latestVersion, latestVersionMD5, () -> {
                    ModSettings.ignoreUpdate = newestUpdateID;
                    try {
                        settings.saveSettings();
                    }
                    catch (IOException e) {
                        LOGGER.error("suppressed exception", (Throwable)e);
                    }
                });
                Patreon.addOutdatedMod(patreonEntry);
            }
            waypointSymbolCreator = new WaypointSymbolCreator();
            controlsRegister = new ControlsRegister();
            ServerWorldCapabilities.registerCapabilities();
            bufferDeallocator = new ByteBufferDeallocator();
            tilePool = new MapTilePool();
            overlayManager = new OverlayManager();
            oldFormatSupport = new OldFormatSupport();
            pngExporter = new PNGExporter(configFolder.toPath().getParent().resolve("map exports"));
            mapLimiter = new MapLimiter();
            normalTextureUploadPool = new TextureUploadPool.Normal(256);
            compressedTextureUploadPool = new TextureUploadPool.Compressed(256);
            branchUpdatePool = new TextureUploadPool.BranchUpdate(256, false);
            branchUpdateAllocatePool = new TextureUploadPool.BranchUpdate(256, true);
            branchDownloadPool = new TextureUploadPool.BranchDownload(256);
            textureDirectBufferPool = new TextureDirectBufferPool();
            subsequentNormalTextureUploadPool = new TextureUploadPool.SubsequentNormal(256);
            textureUploadBenchmark = new TextureUploadBenchmark(512, 512, 512, 256, 256, 256, 256);
            unknownBlockStateCache = new UnknownBlockStateCache();
            glObjectDeleter = new GLObjectDeleter();
            crashHandler = new CrashHandler();
            mapRunner = new MapRunner();
            mapRunnerThread = new Thread(mapRunner);
            mapRunnerThread.start();
            DeferredWorkQueue.runLater(this::loadLater);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    private void loadLater() {
        LOGGER.info("Loading Xaero's World Map - Stage 2/2");
        try {
            settings.findMapItem();
            worldMapClient.postInit();
            settings.updateRegionCacheHashCode();
            playerTrackerSystemManager.register("map_synced", new SyncedPlayerTrackerSystem());
            SupportMods.load();
            mapElementRenderHandler = MapElementRenderHandler.Builder.begin().build();
            oldFormatSupport.loadStates();
            loaded = true;
        }
        catch (Throwable e) {
            LOGGER.error("error", e);
            crashHandler.setCrashedBy(e);
        }
    }

    private void loadCommon(FMLCommonSetupEvent event) {
        messageHandler = new WorldMapMessageHandlerForge();
        new WorldMapMessageRegister().register(messageHandler);
        serverPlayerTickHandler = new ServerPlayerTickHandler();
        SupportServerMods.check();
    }

    private void loadServer(FMLDedicatedServerSetupEvent event) {
        WorldMapServer worldmapServer = new WorldMapServer();
        worldmapServer.load(event);
        DeferredWorkQueue.runLater(() -> {
            worldmapServer.loadLater();
            loaded = true;
        });
    }

    public static void onSessionFinalized() {
        mapLimiter.onSessionFinalized();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.onSessionFinalized();
        }
    }

    static {
        fileLayout = "XaerosWorldMap_&mod_Forge_&mc.jar";
        fileLayoutID = "worldmap";
        guiTextures = new ResourceLocation("xaeroworldmap", "gui/gui.png");
        globalVersion = 1;
        playerTrackerSystemManager = new PlayerTrackerSystemManager();
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)WorldMapMessage.MAIN_CHANNEL, () -> "1.0", s -> true, s -> true);
        modJAR = null;
    }
}

