/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue;

import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueUpdatePacket;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;

public class ScrollValueBehaviour
extends TileEntityBehaviour {
    public static BehaviourType<ScrollValueBehaviour> TYPE = new BehaviourType();
    ValueBoxTransform slotPositioning;
    Vector3d textShift;
    int min = 0;
    int max = 1;
    public int value;
    public int scrollableValue;
    int ticksUntilScrollPacket;
    boolean forceClientState;
    ITextComponent label;
    Consumer<Integer> callback;
    Consumer<Integer> clientCallback;
    Function<Integer, String> formatter;
    Function<Integer, ITextComponent> unit;
    Function<StepContext, Integer> step;
    private Supplier<Boolean> isActive;
    boolean needsWrench;

    public ScrollValueBehaviour(ITextComponent label, SmartTileEntity te, ValueBoxTransform slot) {
        super(te);
        this.setLabel(label);
        this.slotPositioning = slot;
        this.callback = i -> {};
        this.clientCallback = i -> {};
        this.textShift = Vector3d.field_186680_a;
        this.formatter = i -> Integer.toString(i);
        this.step = c -> 1;
        this.value = 0;
        this.isActive = () -> true;
        this.ticksUntilScrollPacket = -1;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(CompoundNBT nbt, boolean clientPacket) {
        nbt.func_74768_a("ScrollValue", this.value);
        if (clientPacket && this.forceClientState) {
            nbt.func_74757_a("ForceScrollable", true);
            this.forceClientState = false;
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundNBT nbt, boolean clientPacket) {
        this.value = nbt.func_74762_e("ScrollValue");
        if (nbt.func_74764_b("ForceScrollable")) {
            this.ticksUntilScrollPacket = -1;
            this.scrollableValue = this.value;
        }
        super.read(nbt, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.getWorld().field_72995_K) {
            return;
        }
        if (this.ticksUntilScrollPacket == -1) {
            return;
        }
        if (this.ticksUntilScrollPacket > 0) {
            --this.ticksUntilScrollPacket;
            return;
        }
        AllPackets.channel.sendToServer((Object)new ScrollValueUpdatePacket(this.getPos(), this.scrollableValue));
        this.ticksUntilScrollPacket = -1;
    }

    public ScrollValueBehaviour withClientCallback(Consumer<Integer> valueCallback) {
        this.clientCallback = valueCallback;
        return this;
    }

    public ScrollValueBehaviour withCallback(Consumer<Integer> valueCallback) {
        this.callback = valueCallback;
        return this;
    }

    public ScrollValueBehaviour between(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollValueBehaviour moveText(Vector3d shift) {
        this.textShift = shift;
        return this;
    }

    public ScrollValueBehaviour requiresWrench() {
        this.needsWrench = true;
        return this;
    }

    public ScrollValueBehaviour withFormatter(Function<Integer, String> formatter) {
        this.formatter = formatter;
        return this;
    }

    public ScrollValueBehaviour withUnit(Function<Integer, ITextComponent> unit) {
        this.unit = unit;
        return this;
    }

    public ScrollValueBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public ScrollValueBehaviour withStepFunction(Function<StepContext, Integer> step) {
        this.step = step;
        return this;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setValue(this.value);
        this.scrollableValue = this.value;
    }

    public void setValue(int value) {
        if ((value = MathHelper.func_76125_a((int)value, (int)this.min, (int)this.max)) == this.value) {
            return;
        }
        this.value = value;
        this.forceClientState = true;
        this.callback.accept(value);
        this.tileEntity.func_70296_d();
        this.tileEntity.sendData();
        this.scrollableValue = value;
    }

    public int getValue() {
        return this.value;
    }

    public String formatValue() {
        return this.formatter.apply(this.scrollableValue);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public boolean testHit(Vector3d hit) {
        BlockState state = this.tileEntity.func_195044_w();
        Vector3d localHit = hit.func_178788_d(Vector3d.func_237491_b_((Vector3i)this.tileEntity.func_174877_v()));
        return this.slotPositioning.testHit(state, localHit);
    }

    public void setLabel(ITextComponent label) {
        this.label = label;
    }

    public static class StepContext {
        public int currentValue;
        public boolean forward;
        public boolean shift;
        public boolean control;
    }
}

