/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper.terrainzapper;

import com.simibubi.create.content.curiosities.zapper.ZapperItem;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.FlattenTool;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum TerrainTools {
    Fill(AllIcons.I_FILL),
    Place(AllIcons.I_PLACE),
    Replace(AllIcons.I_REPLACE),
    Clear(AllIcons.I_CLEAR),
    Overlay(AllIcons.I_OVERLAY),
    Flatten(AllIcons.I_FLATTEN);

    public String translationKey = Lang.asId(this.name());
    public AllIcons icon;

    private TerrainTools(AllIcons icon) {
        this.icon = icon;
    }

    public boolean requiresSelectedBlock() {
        return this != Clear && this != Flatten;
    }

    public void run(World world, List<BlockPos> targetPositions, Direction facing, @Nullable BlockState paintedState, @Nullable CompoundNBT data, PlayerEntity player) {
        switch (this) {
            case Clear: {
                targetPositions.forEach(p -> world.func_175656_a(p, Blocks.field_150350_a.func_176223_P()));
                break;
            }
            case Fill: {
                targetPositions.forEach(p -> {
                    BlockState toReplace = world.func_180495_p(p);
                    if (!TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.func_175656_a(p, paintedState);
                    ZapperItem.setTileData(world, p, paintedState, data, player);
                });
                break;
            }
            case Flatten: {
                FlattenTool.apply(world, targetPositions, facing);
                break;
            }
            case Overlay: {
                targetPositions.forEach(p -> {
                    BlockState toOverlay = world.func_180495_p(p);
                    if (TerrainTools.isReplaceable(toOverlay)) {
                        return;
                    }
                    if (toOverlay == paintedState) {
                        return;
                    }
                    BlockState toReplace = world.func_180495_p(p = p.func_177984_a());
                    if (!TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.func_175656_a(p, paintedState);
                    ZapperItem.setTileData(world, p, paintedState, data, player);
                });
                break;
            }
            case Place: {
                targetPositions.forEach(p -> {
                    world.func_175656_a(p, paintedState);
                    ZapperItem.setTileData(world, p, paintedState, data, player);
                });
                break;
            }
            case Replace: {
                targetPositions.forEach(p -> {
                    BlockState toReplace = world.func_180495_p(p);
                    if (TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.func_175656_a(p, paintedState);
                    ZapperItem.setTileData(world, p, paintedState, data, player);
                });
            }
        }
    }

    public static boolean isReplaceable(BlockState toReplace) {
        return toReplace.func_185904_a().func_76222_j();
    }
}

