/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.api;

import com.kotakotik.createautomated.api.INode;
import com.kotakotik.createautomated.content.processing.oreExtractor.OreExtractorTile;
import com.kotakotik.createautomated.content.processing.oreExtractor.recipe.ExtractingRecipe;
import com.kotakotik.createautomated.register.ModRecipeTypes;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public interface IExtractable
extends IForgeBlock,
INode {
    public void extractTick(OreExtractorTile var1);

    public static void tryExtract(OreExtractorTile tile) {
        if (IExtractable.getRecipe(Objects.requireNonNull(tile.func_145831_w()), tile.getBreakingPos()).isPresent()) {
            if (tile.getBlockToMine() instanceof IExtractable) {
                ((IExtractable)tile.getBlockToMine()).extractTick(tile);
            } else {
                IExtractable.extractFromRecipe(tile);
            }
        }
    }

    public static boolean isExtractable(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof IExtractable;
    }

    public static Optional<ExtractingRecipe> getRecipe(final World world, final BlockPos pos) {
        return world.func_199532_z().func_215371_a((IRecipeType)ModRecipeTypes.EXTRACTING, (IInventory)new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1)){

            public ItemStack func_70301_a(int slot) {
                return new ItemStack((IItemProvider)world.func_180495_p(pos).func_177230_c());
            }
        }, world);
    }

    public static void extractFromRecipe(OreExtractorTile tile) {
        Block below = tile.getBlockToMine();
        BlockPos belowBlock = tile.getBreakingPos();
        Optional<ExtractingRecipe> recipe = IExtractable.getRecipe(Objects.requireNonNull(tile.func_145831_w()), belowBlock);
        ExtractingRecipe r = recipe.get();
        int progress = (int)((float)tile.extractProgress + Math.abs(tile.getSpeed()));
        if (progress >= r.requiredProgress) {
            progress = 0;
            tile.takeDamage(r.drillDamage);
            ItemStack stack = tile.inventory.getStackInSlot(0);
            ItemStack toAdd = r.getCraftingResult();
            if (below instanceof INode) {
                INode node = (INode)below;
                node.takeCount(tile, belowBlock, toAdd.func_190916_E());
            }
            if (stack.func_77973_b().getRegistryName().equals((Object)toAdd.func_77973_b().getRegistryName())) {
                stack.func_190920_e(Math.min(stack.func_77976_d(), stack.func_190916_E() + toAdd.func_190916_E()));
            } else if (stack.func_190926_b()) {
                tile.inventory.setStackInSlot(0, toAdd);
            }
        }
        tile.extractProgress = progress;
        tile.notifyUpdate();
    }

    @Override
    default public void takeCount(OreExtractorTile tile, BlockPos pos, int oreAdded) {
    }
}

