/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.usercontent.factory;

import com.google.common.base.Predicates;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.widget.button.GuiButtonIcon;
import exopandora.worldhandler.gui.widget.button.GuiButtonItem;
import exopandora.worldhandler.gui.widget.button.GuiButtonList;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiSlider;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.widget.button.LogicSliderSimple;
import exopandora.worldhandler.usercontent.UsercontentAPI;
import exopandora.worldhandler.usercontent.factory.AbstractWidgetFactory;
import exopandora.worldhandler.usercontent.factory.ActionHandlerFactory;
import exopandora.worldhandler.usercontent.model.JsonItem;
import exopandora.worldhandler.usercontent.model.JsonWidget;
import exopandora.worldhandler.util.TextUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class WidgetFactory
extends AbstractWidgetFactory {
    public WidgetFactory(UsercontentAPI api, ActionHandlerFactory actionHandlerFactory) {
        super(api, actionHandlerFactory);
    }

    @Nullable
    public Widget createWidget(JsonWidget widget, Content content, Container container, int x, int y) {
        if (JsonWidget.Type.BUTTON.equals((Object)widget.getType())) {
            return new GuiButtonTooltip(widget.getLayout().getX() + x, widget.getLayout().getY() + y, widget.getLayout().getWidth(), widget.getLayout().getHeight(), (ITextComponent)TextUtils.formatNonnull(widget.getText(), new Object[0]), (ITextComponent)TextUtils.formatNonnull(widget.getAttributes() != null ? widget.getAttributes().getTooltip() : null, new Object[0]), this.getActionHandlerFactory().createActionHandler(content, widget.getAction(), container::getPlayer));
        }
        if (JsonWidget.Type.ITEM_BUTTON.equals((Object)widget.getType())) {
            return new GuiButtonItem(widget.getLayout().getX() + x, widget.getLayout().getY() + y, widget.getLayout().getWidth(), widget.getLayout().getHeight(), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(widget.getAttributes().getItem())), this.getActionHandlerFactory().createActionHandler(content, widget.getAction(), container::getPlayer));
        }
        if (JsonWidget.Type.ICON_BUTTON.equals((Object)widget.getType())) {
            return new GuiButtonIcon(widget.getLayout().getX() + x, widget.getLayout().getY() + y, widget.getLayout().getWidth(), widget.getLayout().getHeight(), widget.getAttributes().getIcon(), (ITextComponent)TextUtils.formatNonnull(widget.getAttributes().getTooltip(), new Object[0]), this.getActionHandlerFactory().createActionHandler(content, widget.getAction(), container::getPlayer));
        }
        if (JsonWidget.Type.LIST_BUTTON.equals((Object)widget.getType())) {
            return new GuiButtonList<JsonItem>(widget.getLayout().getX() + x, widget.getLayout().getY() + y, widget.getAttributes().getItems(), widget.getLayout().getWidth(), widget.getLayout().getHeight(), container, new AbstractWidgetFactory.UsercontentLogicMapped<JsonWidget.Type>(this.getApi(), this.getActionHandlerFactory(), content, widget, container::getPlayer));
        }
        if (JsonWidget.Type.SLIDER.equals((Object)widget.getType())) {
            Consumer<Integer> responder = this.getActionHandlerFactory().createResponder(integer -> integer.toString(), widget.getAttributes().getId(), widget.getAction());
            return new GuiSlider(widget.getLayout().getX() + x, widget.getLayout().getY() + y, widget.getLayout().getWidth(), widget.getLayout().getHeight(), widget.getAttributes().getMin(), widget.getAttributes().getMax(), widget.getAttributes().getStart(), container, new LogicSliderSimple(widget.getAttributes().getId(), TextUtils.formatNonnull(widget.getText(), new Object[0]), responder));
        }
        if (JsonWidget.Type.TEXTFIELD.equals((Object)widget.getType())) {
            GuiTextFieldTooltip textfield = new GuiTextFieldTooltip(widget.getLayout().getX() + x, widget.getLayout().getY() + y, widget.getLayout().getWidth(), widget.getLayout().getHeight(), (ITextComponent)TextUtils.formatNonnull(widget.getText(), new Object[0]));
            textfield.func_200675_a((Predicate)Predicates.notNull());
            textfield.func_146180_a(this.getApi().getValue(widget.getAttributes().getId()));
            textfield.func_212954_a(this.getActionHandlerFactory().createResponder(string -> textfield.func_146179_b(), widget.getAttributes().getId(), widget.getAction()));
            return textfield;
        }
        return null;
    }
}

