/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.installer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class InstallListener
implements ActionListener {
    private final JFrame parent;
    private final JTextField textField;

    public InstallListener(JFrame parent, JTextField textField) {
        this.parent = parent;
        this.textField = textField;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        File directory = new File(this.textField.getText());
        if (directory.isDirectory()) {
            File mods = new File(directory, "mods");
            File versions = new File(directory, "versions");
            if (!this.isPartialFileNameInFolder(versions, "1.16.5", "forge")) {
                JOptionPane.showMessageDialog(null, "Please install Mineceaft Forge", null, 0);
            } else {
                for (File file : mods.listFiles()) {
                    if (!this.containsIgnoreCase(file.getName(), "world") || !this.containsIgnoreCase(file.getName(), "handler")) continue;
                    file.delete();
                }
                try {
                    Path path = new File(InstallListener.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).toPath();
                    Files.copy(path, new File(mods, "WorldHandler-1.16.5-2.12.6-Universal.jar").toPath(), StandardCopyOption.REPLACE_EXISTING);
                    JOptionPane.showMessageDialog(null, "World Handler 1.16.5-2.12.6 has been successfully installed", null, 1);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error:\n" + e.getMessage(), null, 0);
                }
            }
            this.parent.dispose();
        } else {
            JOptionPane.showMessageDialog(null, "Invalid directory", null, 0);
        }
    }

    private boolean containsIgnoreCase(String string, String sequence) {
        return string.toLowerCase().contains(sequence.toLowerCase());
    }

    private boolean isPartialFileNameInFolder(File path, String ... parts) {
        if (path.exists() && path.isDirectory()) {
            for (File folder : path.listFiles()) {
                if (!folder.isDirectory() || !this.containsAll(folder.getName(), parts)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsAll(String string, String ... parts) {
        for (String part : parts) {
            if (this.containsIgnoreCase(string, part)) continue;
            return false;
        }
        return true;
    }
}

