/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.impl;

import exopandora.worldhandler.builder.CommandBuilderNBT;
import exopandora.worldhandler.builder.component.impl.EntityNBT;
import exopandora.worldhandler.util.MutableStringTextComponent;
import exopandora.worldhandler.util.ResourceHelper;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public abstract class BuilderEntity
extends CommandBuilderNBT {
    private final EntityNBT nbt = new EntityNBT();

    public abstract void setEntity(ResourceLocation var1);

    public abstract ResourceLocation getEntity();

    public void setName(String name) {
        this.setEntity(BuilderEntity.parseEntityName(name));
        this.updateCustomComponent(name);
    }

    public void setNameAndId(String name) {
        this.setName(name);
        this.nbt.setId(this.getEntity());
    }

    public void setId(ResourceLocation resource) {
        this.nbt.setId(resource);
    }

    public ResourceLocation getId() {
        return this.nbt.getId();
    }

    public void setAttribute(Attribute attribute, double ammount) {
        this.nbt.setAttribute(attribute, ammount);
    }

    public void removeAttribute(Attribute attribute) {
        this.nbt.removeAttribute(attribute);
    }

    public double getAttributeAmmount(Attribute attribute) {
        return this.nbt.getAttributeAmmount(attribute);
    }

    public Set<Attribute> getAttributes() {
        return this.nbt.getAttributes();
    }

    public void setCustomName(String name) {
        this.nbt.setCustomName(name);
    }

    @Nullable
    public MutableStringTextComponent getCustomName() {
        return this.nbt.getCustomName();
    }

    public void setPassenger(int index, String name) {
        this.nbt.setPassenger(index, BuilderEntity.parseEntityName(name));
    }

    public void setPassenger(int index, EntityNBT entity) {
        this.nbt.setPassenger(index, entity);
    }

    public void setPassenger(int index, ResourceLocation id) {
        this.setPassenger(index, new EntityNBT(id));
    }

    public void addPassenger(EntityNBT entity) {
        this.nbt.addPassenger(entity);
    }

    public void addPassenger(int index, EntityNBT entity) {
        this.nbt.addPassenger(index, entity);
    }

    public void removePassenger(int index) {
        this.nbt.removePassenger(index);
    }

    public int getPassengerCount() {
        return this.nbt.getPassengerCount();
    }

    public List<EntityNBT> getPassengers() {
        return this.nbt.getPassengers();
    }

    @Nullable
    public EntityNBT getPassenger(int index) {
        return this.nbt.getPassenger(index);
    }

    public boolean hasPassengers() {
        return this.nbt.hasPassengers();
    }

    public void setArmorItem(int index, Block block) {
        this.nbt.setArmorItem(index, block);
    }

    public void setArmorItem(int index, Item item) {
        this.nbt.setArmorItem(index, item);
    }

    public void setArmorItem(int index, ResourceLocation location) {
        this.nbt.setArmorItem(index, location);
    }

    public void setArmorItems(ResourceLocation[] armor) {
        this.nbt.setArmorItems(armor);
    }

    public ResourceLocation getArmorItem(int slot) {
        return this.nbt.getArmorItem(slot);
    }

    public void setHandItem(int index, Block block) {
        this.nbt.setHandItem(index, block);
    }

    public void setHandItem(int index, Item item) {
        this.nbt.setHandItem(index, item);
    }

    public void setHandItem(int index, ResourceLocation location) {
        this.nbt.setHandItem(index, location);
    }

    public ResourceLocation getHandItem(int slot) {
        return this.nbt.getHandItem(slot);
    }

    public double[] getMotion() {
        return this.nbt.getMotion();
    }

    public void setMotion(double x, double y, double z) {
        this.nbt.setMotion(x, y, z);
    }

    public double getMotionX() {
        return this.nbt.getMotionX();
    }

    public double getMotionY() {
        return this.nbt.getMotionY();
    }

    public double getMotionZ() {
        return this.nbt.getMotionZ();
    }

    public void setMotionX(double x) {
        this.nbt.setMotionX(x);
    }

    public void setMotionY(double y) {
        this.nbt.setMotionY(y);
    }

    public void setMotionZ(double z) {
        this.nbt.setMotionZ(z);
    }

    public void setAmplifier(Effect potion, byte amplifier) {
        this.nbt.setAmplifier(potion, amplifier);
    }

    public void setSeconds(Effect potion, int seconds) {
        this.nbt.setSeconds(potion, seconds);
    }

    public void setMinutes(Effect potion, int minutes) {
        this.nbt.setMinutes(potion, minutes);
    }

    public void setHours(Effect potion, int hours) {
        this.nbt.setHours(potion, hours);
    }

    public void setShowParticles(Effect potion, boolean showParticles) {
        this.nbt.setShowParticles(potion, showParticles);
    }

    public void setAmbient(Effect potion, boolean ambient) {
        this.nbt.setAmbient(potion, ambient);
    }

    public byte getAmplifier(Effect potion) {
        return this.nbt.getAmplifier(potion);
    }

    public int getSeconds(Effect potion) {
        return this.nbt.getSeconds(potion);
    }

    public int getMinutes(Effect potion) {
        return this.nbt.getMinutes(potion);
    }

    public int getHours(Effect potion) {
        return this.nbt.getHours(potion);
    }

    public boolean getShowParticles(Effect potion) {
        return this.nbt.getShowParticles(potion);
    }

    public boolean getAmbient(Effect potion) {
        return this.nbt.getAmbient(potion);
    }

    public Set<Effect> getEffects() {
        return this.nbt.getEffects();
    }

    public void setBlockState(BlockState blockState) {
        this.nbt.setBlockState(blockState);
    }

    public BlockState getBlockState() {
        return this.nbt.getBlockState();
    }

    public void setTime(int time) {
        this.nbt.setTime(time);
    }

    public int getTime() {
        return this.nbt.getTime();
    }

    public void setCommand(String command) {
        this.nbt.setCommand(command);
    }

    public String getCommand() {
        return this.nbt.getCommand();
    }

    public void setEntityNBT(String nbt) {
        this.nbt.setNBT(nbt);
    }

    public void setEntityNBT(CompoundNBT nbt) {
        this.nbt.setNBT(nbt);
    }

    public CompoundNBT getEntityNBT() {
        return this.nbt.getNBT();
    }

    @Override
    protected CompoundNBT buildNBT() {
        return this.nbt.serialize();
    }

    private void updateCustomComponent(String name) {
        ResourceLocation entity = this.getEntity();
        if (name != null && entity != null) {
            if (entity.equals((Object)EntityType.field_220360_g.getRegistryName())) {
                this.nbt.setCustomComponent("CatType", (INBT)IntNBT.func_229692_a_((int)new Random().nextInt(11)));
            } else if (entity.equals((Object)EntityType.field_200756_av.getRegistryName())) {
                for (VillagerProfession profession : ForgeRegistries.PROFESSIONS) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)profession.toString())) continue;
                    CompoundNBT villagerData = new CompoundNBT();
                    villagerData.func_74778_a("profession", profession.getRegistryName().toString());
                    this.nbt.setCustomComponent("VillagerData", (INBT)villagerData);
                    break;
                }
            } else if (entity.equals((Object)EntityType.field_200725_aD.getRegistryName())) {
                if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"Baby")) {
                    this.nbt.setCustomComponent("IsBaby", (INBT)ByteNBT.func_229671_a_((byte)1));
                }
            } else if (entity.equals((Object)EntityType.field_200795_i.getRegistryName())) {
                if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"Jockey") && !this.nbt.hasPassengers()) {
                    ListNBT list = new ListNBT();
                    EntityNBT zombie = new EntityNBT(EntityType.field_200725_aD.getRegistryName());
                    zombie.setIsBaby(true);
                    list.add((Object)zombie.serialize());
                    this.nbt.setCustomComponent("Passengers", (INBT)list);
                }
            } else if (entity.equals((Object)EntityType.field_200748_an.getRegistryName())) {
                if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"Jockey") && !this.nbt.hasPassengers()) {
                    ListNBT list = new ListNBT();
                    EntityNBT skeleton = new EntityNBT(EntityType.field_200741_ag.getRegistryName());
                    skeleton.setHandItem(0, Items.field_151031_f);
                    list.add((Object)skeleton.serialize());
                    this.nbt.setCustomComponent("Passengers", (INBT)list);
                }
            } else {
                this.nbt.resetCustomComponent();
            }
        } else {
            this.nbt.resetCustomComponent();
        }
    }

    @Nullable
    public static ResourceLocation parseEntityName(String entityName) {
        String name = ResourceHelper.stripToResourceLocation(entityName);
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (EntityType type : ForgeRegistries.ENTITIES.getValues()) {
            if (!type.func_200720_b() || !entityName.equalsIgnoreCase(I18n.func_135052_a((String)type.func_210760_d(), (Object[])new Object[0]))) continue;
            return type.getRegistryName();
        }
        String entity = name.replaceAll("_", "");
        if ("RedCow".equalsIgnoreCase(entity)) {
            return EntityType.field_200780_T.getRegistryName();
        }
        if ("ChickenJockey".equalsIgnoreCase(entity)) {
            return EntityType.field_200795_i.getRegistryName();
        }
        if ("Pigman".equalsIgnoreCase(entity) || "ZombiePig".equalsIgnoreCase(entity) || "ZombiePigman".equalsIgnoreCase(entity)) {
            return EntityType.field_233591_ai_.getRegistryName();
        }
        if ("Dog".equalsIgnoreCase(entity)) {
            return EntityType.field_200724_aC.getRegistryName();
        }
        if ("Dragon".equalsIgnoreCase(entity)) {
            return EntityType.field_200802_p.getRegistryName();
        }
        if ("SnowMan".equalsIgnoreCase(entity)) {
            return EntityType.field_200745_ak.getRegistryName();
        }
        if ("LavaCube".equalsIgnoreCase(entity) || "MagmaSlime".equalsIgnoreCase(entity) || "LavaSlime".equalsIgnoreCase(entity)) {
            return EntityType.field_200771_K.getRegistryName();
        }
        if ("SpiderJockey".equalsIgnoreCase(entity)) {
            return EntityType.field_200748_an.getRegistryName();
        }
        if ("VillagerGolem".equalsIgnoreCase(entity)) {
            return EntityType.field_200757_aw.getRegistryName();
        }
        if ("Ozelot".equalsIgnoreCase(entity)) {
            return EntityType.field_200781_U.getRegistryName();
        }
        if ("Kitty".equalsIgnoreCase(entity) || "Kitten".equalsIgnoreCase(entity)) {
            return EntityType.field_220360_g.getRegistryName();
        }
        if ("TESTIFICATE".equalsIgnoreCase(entity) || ForgeRegistries.PROFESSIONS.getKeys().stream().anyMatch(profession -> profession.func_110623_a().equalsIgnoreCase(entity))) {
            return EntityType.field_200756_av.getRegistryName();
        }
        if ("Octopus".equalsIgnoreCase(entity) || "Kraken".equalsIgnoreCase(entity)) {
            return EntityType.field_200749_ao.getRegistryName();
        }
        if ("Exwife".equalsIgnoreCase(entity)) {
            return EntityType.field_200811_y.getRegistryName();
        }
        if ("CommandMinecart".equalsIgnoreCase(entity)) {
            return EntityType.field_200774_N.getRegistryName();
        }
        if ("Wizard".equalsIgnoreCase(entity)) {
            return EntityType.field_200806_t.getRegistryName();
        }
        if ("Johnny".equalsIgnoreCase(entity)) {
            return EntityType.field_200758_ax.getRegistryName();
        }
        if ("BabyZombie".equalsIgnoreCase(entity)) {
            return EntityType.field_200725_aD.getRegistryName();
        }
        return ResourceHelper.stringToResourceLocation(name);
    }
}

