/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.tile.IafTileEntityRegistry;
import com.github.alexthe666.iceandfire.entity.tile.PixieJarInvWrapper;
import com.github.alexthe666.iceandfire.enums.EnumParticles;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouse;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouseModel;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieJar;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityJar
extends TileEntity
implements ITickableTileEntity {
    private static final float PARTICLE_WIDTH = 0.3f;
    private static final float PARTICLE_HEIGHT = 0.6f;
    public boolean hasPixie;
    public boolean prevHasProduced;
    public boolean hasProduced;
    public boolean tamedPixie;
    public UUID pixieOwnerUUID;
    public int pixieType;
    public int ticksExisted;
    public NonNullList<ItemStack> pixieItems = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public float rotationYaw;
    public float prevRotationYaw;
    LazyOptional<? extends IItemHandler> downHandler = PixieJarInvWrapper.create(this);
    private Random rand = new Random();

    public TileEntityJar() {
        super((TileEntityType)IafTileEntityRegistry.PIXIE_JAR.get());
        this.hasPixie = true;
    }

    public TileEntityJar(boolean empty) {
        super((TileEntityType)IafTileEntityRegistry.PIXIE_JAR.get());
        this.hasPixie = !empty;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("HasPixie", this.hasPixie);
        compound.func_74768_a("PixieType", this.pixieType);
        compound.func_74757_a("HasProduced", this.hasProduced);
        compound.func_74757_a("TamedPixie", this.tamedPixie);
        if (this.pixieOwnerUUID != null) {
            compound.func_186854_a("PixieOwnerUUID", this.pixieOwnerUUID);
        }
        compound.func_74768_a("TicksExisted", this.ticksExisted);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.pixieItems);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
        if (!this.field_145850_b.field_72995_K) {
            IceAndFire.sendMSGToAll(new MessageUpdatePixieHouseModel(this.field_174879_c.func_218275_a(), packet.func_148857_g().func_74762_e("PixieType")));
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.hasPixie = compound.func_74767_n("HasPixie");
        this.pixieType = compound.func_74762_e("PixieType");
        this.hasProduced = compound.func_74767_n("HasProduced");
        this.ticksExisted = compound.func_74762_e("TicksExisted");
        this.tamedPixie = compound.func_74767_n("TamedPixie");
        if (compound.func_186855_b("PixieOwnerUUID")) {
            this.pixieOwnerUUID = compound.func_186857_a("PixieOwnerUUID");
        }
        this.pixieItems = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.pixieItems);
        super.func_230337_a_(state, compound);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.field_145850_b.field_72995_K && this.hasPixie) {
            IceAndFire.PROXY.spawnParticle(EnumParticles.If_Pixie, (double)((float)this.field_174879_c.func_177958_n() + 0.5f) + (double)(this.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)this.field_174879_c.func_177956_o() + (double)(this.rand.nextFloat() * 0.6f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f) + (double)(this.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, EntityPixie.PARTICLE_RGB[this.pixieType][0], EntityPixie.PARTICLE_RGB[this.pixieType][1], EntityPixie.PARTICLE_RGB[this.pixieType][2]);
        }
        if (this.ticksExisted % 24000 == 0 && !this.hasProduced && this.hasPixie) {
            this.hasProduced = true;
            if (!this.func_145831_w().field_72995_K) {
                IceAndFire.sendMSGToAll(new MessageUpdatePixieJar(this.field_174879_c.func_218275_a(), this.hasProduced));
            }
        }
        if (this.hasPixie && this.hasProduced != this.prevHasProduced && this.ticksExisted > 5) {
            if (!this.func_145831_w().field_72995_K) {
                IceAndFire.sendMSGToAll(new MessageUpdatePixieJar(this.field_174879_c.func_218275_a(), this.hasProduced));
            } else {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, IafSoundRegistry.PIXIE_HURT, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
        this.prevRotationYaw = this.rotationYaw;
        if (this.rand.nextInt(30) == 0) {
            this.rotationYaw = this.rand.nextFloat() * 360.0f - 180.0f;
        }
        if (this.hasPixie && this.ticksExisted % 40 == 0 && this.rand.nextInt(6) == 0 && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, IafSoundRegistry.PIXIE_IDLE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        this.prevHasProduced = this.hasProduced;
    }

    public void releasePixie() {
        EntityPixie pixie = new EntityPixie((EntityType)IafEntityRegistry.PIXIE.get(), this.field_145850_b);
        pixie.func_70080_a((float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f, new Random().nextInt(360), 0.0f);
        pixie.func_184611_a(Hand.MAIN_HAND, (ItemStack)this.pixieItems.get(0));
        pixie.setColor(this.pixieType);
        this.field_145850_b.func_217376_c((Entity)pixie);
        this.hasPixie = false;
        this.pixieType = 0;
        pixie.ticksUntilHouseAI = 500;
        pixie.func_70903_f(this.tamedPixie);
        pixie.func_184754_b(this.pixieOwnerUUID);
        if (!this.field_145850_b.field_72995_K) {
            IceAndFire.sendMSGToAll(new MessageUpdatePixieHouse(this.field_174879_c.func_218275_a(), false, 0));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (facing == Direction.DOWN && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.downHandler.cast();
        }
        return super.getCapability(capability, facing);
    }
}

