/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AdvancedPathNavigate;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathResult;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class MyrmexAIReEnterHive
extends Goal {
    private final EntityMyrmexBase myrmex;
    private final double movementSpeed;
    private PathResult path;
    private BlockPos currentTarget = BlockPos.field_177992_a;
    private Phases currentPhase = Phases.GOTOENTRANCE;
    private MyrmexHive hive;

    public MyrmexAIReEnterHive(EntityMyrmexBase entityIn, double movementSpeedIn) {
        this.myrmex = entityIn;
        this.movementSpeed = movementSpeedIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.myrmex.canMove() || this.myrmex.shouldLeaveHive() || !this.myrmex.shouldEnterHive() || this.currentPhase != Phases.GOTOENTRANCE) {
            return false;
        }
        MyrmexHive village = this.myrmex.getHive();
        if (village == null) {
            village = MyrmexWorldData.get(this.myrmex.field_70170_p).getNearestHive(this.myrmex.func_233580_cy_(), 500);
        }
        if (!(this.myrmex.func_70661_as() instanceof AdvancedPathNavigate) || this.myrmex.func_184218_aH()) {
            return false;
        }
        if (village == null || this.myrmex.isInHive()) {
            return false;
        }
        this.hive = village;
        this.currentTarget = MyrmexHive.getGroundedPos((IWorld)this.myrmex.field_70170_p, this.hive.getClosestEntranceToEntity((Entity)this.myrmex, this.myrmex.func_70681_au(), false));
        this.path = ((AdvancedPathNavigate)this.myrmex.func_70661_as()).moveToXYZ(this.currentTarget.func_177958_n(), this.currentTarget.func_177956_o(), this.currentTarget.func_177952_p(), 1.0);
        this.currentPhase = Phases.GOTOENTRANCE;
        return this.path != null;
    }

    public void func_75246_d() {
        if (this.currentPhase == Phases.GOTOENTRANCE && !this.myrmex.pathReachesTarget(this.path, this.currentTarget, 12.0)) {
            this.currentTarget = MyrmexHive.getGroundedPos((IWorld)this.myrmex.field_70170_p, this.hive.getClosestEntranceToEntity((Entity)this.myrmex, this.myrmex.func_70681_au(), true));
            this.path = ((AdvancedPathNavigate)this.myrmex.func_70661_as()).moveToXYZ(this.currentTarget.func_177958_n(), this.currentTarget.func_177956_o(), this.currentTarget.func_177952_p(), this.movementSpeed);
        }
        if (this.currentPhase == Phases.GOTOENTRANCE && this.myrmex.isCloseEnoughToTarget(this.currentTarget, 12.0) && this.hive != null) {
            this.currentTarget = this.hive.getClosestEntranceBottomToEntity((Entity)this.myrmex, this.myrmex.func_70681_au());
            this.currentPhase = Phases.GOTOEXIT;
            this.path = ((AdvancedPathNavigate)this.myrmex.func_70661_as()).moveToXYZ(this.currentTarget.func_177958_n(), this.currentTarget.func_177956_o(), this.currentTarget.func_177952_p(), 1.0);
        }
        if (this.currentPhase == Phases.GOTOEXIT && this.myrmex.isCloseEnoughToTarget(this.currentTarget, 12.0) && this.hive != null) {
            this.currentTarget = MyrmexHive.getGroundedPos((IWorld)this.myrmex.field_70170_p, this.hive.getCenter());
            this.currentPhase = Phases.GOTOCENTER;
            this.path = ((AdvancedPathNavigate)this.myrmex.func_70661_as()).moveToXYZ(this.currentTarget.func_177958_n(), this.currentTarget.func_177956_o(), this.currentTarget.func_177952_p(), 1.0);
        }
        this.myrmex.isEnteringHive = !this.myrmex.isCloseEnoughToTarget(this.currentTarget, 14.0) && this.currentPhase != Phases.GOTOCENTER;
    }

    public boolean func_75253_b() {
        return !this.myrmex.isCloseEnoughToTarget(this.currentTarget, 9.0) || this.currentPhase == Phases.GOTOCENTER;
    }

    public void func_75251_c() {
        this.currentTarget = BlockPos.field_177992_a;
        this.currentPhase = Phases.GOTOENTRANCE;
    }

    private static enum Phases {
        GOTOENTRANCE,
        GOTOEXIT,
        GOTOCENTER;

    }
}

