/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArrayLayeredTexture
extends Texture {
    private static final Logger LOGGER = LogManager.getLogger();
    public final List<String> layeredTextureNames;

    public ArrayLayeredTexture(List<String> textureNames) {
        this.layeredTextureNames = textureNames;
    }

    public void func_195413_a(IResourceManager manager) {
        Iterator<String> iterator = this.layeredTextureNames.iterator();
        String s = iterator.next();
        try (IResource iresource = manager.func_199002_a(new ResourceLocation(s));){
            NativeImage nativeimage = MinecraftForgeClient.getImageLayer((ResourceLocation)new ResourceLocation(s), (IResourceManager)manager);
            while (iterator.hasNext()) {
                String s1 = iterator.next();
                if (s1 == null) continue;
                IResource iresource1 = manager.func_199002_a(new ResourceLocation(s1));
                Throwable throwable = null;
                try {
                    NativeImage nativeimage1 = NativeImage.func_195713_a((InputStream)iresource1.func_199027_b());
                    Throwable throwable2 = null;
                    try {
                        for (int i = 0; i < Math.min(nativeimage1.func_195714_b(), nativeimage.func_195714_b()); ++i) {
                            for (int j = 0; j < Math.min(nativeimage1.func_195702_a(), nativeimage.func_195702_a()); ++j) {
                                ArrayLayeredTexture.blendPixel(nativeimage, nativeimage1, j, i, nativeimage1.func_195709_a(j, i));
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (nativeimage1 == null) continue;
                        if (throwable2 != null) {
                            try {
                                nativeimage1.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        nativeimage1.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (iresource1 == null) continue;
                    if (throwable != null) {
                        try {
                            iresource1.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    iresource1.close();
                }
            }
            if (!RenderSystem.isOnRenderThreadOrInit()) {
                RenderSystem.recordRenderCall(() -> this.loadImage(nativeimage));
            } else {
                this.loadImage(nativeimage);
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't load layered image", (Throwable)ioexception);
        }
    }

    public static void blendPixel(NativeImage nativeimage, NativeImage nativeimage1, int xIn, int yIn, int colIn) {
        int i = nativeimage.func_195709_a(xIn, yIn);
        float f = (float)NativeImage.func_227786_a_((int)colIn) / 255.0f;
        float f1 = (float)NativeImage.func_227795_d_((int)colIn) / 255.0f;
        float f2 = (float)NativeImage.func_227793_c_((int)colIn) / 255.0f;
        float f3 = (float)NativeImage.func_227791_b_((int)colIn) / 255.0f;
        float f4 = (float)NativeImage.func_227786_a_((int)i) / 255.0f;
        float f5 = (float)NativeImage.func_227795_d_((int)i) / 255.0f;
        float f6 = (float)NativeImage.func_227793_c_((int)i) / 255.0f;
        float f7 = (float)NativeImage.func_227791_b_((int)i) / 255.0f;
        float f8 = 1.0f - f;
        float f9 = f * f + f4 * f8;
        float f10 = f1 * f + f5 * f8;
        float f11 = f2 * f + f6 * f8;
        float f12 = f3 * f + f7 * f8;
        if (f9 > 1.0f) {
            f9 = 1.0f;
        }
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        if (f11 > 1.0f) {
            f11 = 1.0f;
        }
        if (f12 > 1.0f) {
            f12 = 1.0f;
        }
        int j = (int)(f9 * 255.0f);
        int k = (int)(f10 * 255.0f);
        int l = (int)(f11 * 255.0f);
        int i1 = (int)(f12 * 255.0f);
        nativeimage.func_195700_a(xIn, yIn, NativeImage.func_227787_a_((int)j, (int)k, (int)l, (int)i1));
    }

    private void loadImage(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }
}

